/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.arrayabstraction;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class VariableGenerator {
    private final String prefix;
    private int counter;

    public VariableGenerator(String pPrefix) {
        this.prefix = pPrefix;
    }

    private static String getNondetFunctionName(CType pType) {
        if (pType instanceof CSimpleType) {
            CSimpleType simpleType = (CSimpleType)pType;
            CBasicType basicType = simpleType.getType();
            if (basicType == CBasicType.INT) {
                return "__VERIFIER_nondet_int";
            }
            if (basicType == CBasicType.UNSPECIFIED && simpleType.isLong()) {
                return "__VERIFIER_nondet_long";
            }
        }
        throw new AssertionError((Object)("Unable to find nondet function name (__VERIFIER_nondet_X) for type: " + pType));
    }

    static CFunctionCallExpression createNondetFunctionCallExpression(CType pType) {
        String nondetFunctionName = VariableGenerator.getNondetFunctionName(pType);
        CFunctionTypeWithNames nondetFunctionType = new CFunctionTypeWithNames(pType, (List<CParameterDeclaration>)ImmutableList.of(), false);
        nondetFunctionType.setName(nondetFunctionName);
        CFunctionDeclaration nondetFunctionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, nondetFunctionType, nondetFunctionName, nondetFunctionName, (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
        CIdExpression nondetFunctionNameExpression = new CIdExpression(FileLocation.DUMMY, nondetFunctionType, nondetFunctionName, nondetFunctionDeclaration);
        CFunctionCallExpression functionCallExpression = new CFunctionCallExpression(FileLocation.DUMMY, pType, nondetFunctionNameExpression, (List<CExpression>)ImmutableList.of(), nondetFunctionDeclaration);
        return functionCallExpression;
    }

    static CIdExpression createVariableNameExpression(CType pType, MemoryLocation pMemoryLocation) {
        Preconditions.checkNotNull((Object)pType);
        Preconditions.checkNotNull((Object)pMemoryLocation);
        String variableName = pMemoryLocation.getIdentifier();
        CVariableDeclaration variableDeclaration = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, pType, variableName, variableName, pMemoryLocation.getExtendedQualifiedName(), null);
        CIdExpression variableNameExpression = new CIdExpression(FileLocation.DUMMY, pType, variableName, variableDeclaration);
        return variableNameExpression;
    }

    static CIdExpression createVariableNameExpression(CType pType, String pVariableName, Optional<String> pFunctionName) {
        Preconditions.checkNotNull((Object)pType);
        Preconditions.checkNotNull((Object)pVariableName);
        Preconditions.checkNotNull(pFunctionName);
        if (pFunctionName.isPresent()) {
            return VariableGenerator.createVariableNameExpression(pType, MemoryLocation.forLocalVariable(pFunctionName.orElseThrow(), pVariableName));
        }
        return VariableGenerator.createVariableNameExpression(pType, MemoryLocation.forIdentifier(pVariableName));
    }

    static CFAEdge createNondetVariableEdge(CType pType, String pVariableName, Optional<String> pFunctionName) {
        Preconditions.checkNotNull((Object)pType);
        Preconditions.checkNotNull((Object)pVariableName);
        Preconditions.checkNotNull(pFunctionName);
        CIdExpression lhs = VariableGenerator.createVariableNameExpression(pType, pVariableName, pFunctionName);
        CFunctionCallExpression rhs = VariableGenerator.createNondetFunctionCallExpression(pType);
        CFunctionCallAssignmentStatement statement = new CFunctionCallAssignmentStatement(FileLocation.DUMMY, lhs, rhs);
        CStatementEdge statementEdge = new CStatementEdge("", statement, FileLocation.DUMMY, CFANode.newDummyCFANode("dummy-predecessor"), CFANode.newDummyCFANode("dummy-successor"));
        return statementEdge;
    }

    String createNewVariableName() {
        return this.prefix + this.counter++;
    }
}

