/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.assumptions;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class AssumptionWithLocation
implements Appender {
    private final FormulaManagerView manager;
    private final Map<CFANode, BooleanFormula> map = new HashMap<CFANode, BooleanFormula>();

    public AssumptionWithLocation(FormulaManagerView pManager) {
        this.manager = pManager;
    }

    public static AssumptionWithLocation copyOf(AssumptionWithLocation a) {
        AssumptionWithLocation result = new AssumptionWithLocation(a.manager);
        result.map.putAll(a.map);
        return result;
    }

    public int getNumberOfLocations() {
        return this.map.size();
    }

    public void appendTo(Appendable out) throws IOException {
        Joiner.on((char)'\n').appendTo(out, (Iterable)Collections2.transform(this.map.entrySet(), AssumptionWithLocation::formatAssumption));
    }

    public String toString() {
        return Appenders.toString((Appender)this);
    }

    private static String formatAssumption(Map.Entry<CFANode, BooleanFormula> entry) {
        int nodeId = entry.getKey().getNodeNumber();
        BooleanFormula assumption = entry.getValue();
        return "pc = " + nodeId + "\t =====>  " + assumption;
    }

    public void add(CFANode node, BooleanFormula assumption) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)assumption);
        BooleanFormulaManagerView bfmgr = this.manager.getBooleanFormulaManager();
        if (!bfmgr.isTrue(assumption)) {
            BooleanFormula oldInvariant = this.map.get(node);
            if (oldInvariant == null) {
                this.map.put(node, assumption);
            } else {
                this.map.put(node, bfmgr.and(oldInvariant, assumption));
            }
        }
    }
}

