/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.assumptions;

import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;

public enum PreventingHeuristic {
    PATHLENGTH("PL"),
    SUCCESSORCOMPTIME("SCT"),
    PATHCOMPTIME("PCT"),
    ASSUMEEDGESINPATH("AEIP"),
    ASSIGNMENTSINPATH("ASIP"),
    REPETITIONSINPATH("RIP"),
    MEMORYUSED("MU"),
    MEMORYOUT("MO"),
    TIMEOUT("TO"),
    LOOPITERATIONS("LI");

    private final String predicateString;

    private PreventingHeuristic(String predicateStr) {
        this.predicateString = predicateStr;
    }

    public BooleanFormula getFormula(FormulaManagerView fmgr, long thresholdValue) {
        IntegerFormulaManagerView nfmgr = fmgr.getIntegerFormulaManager();
        NumeralFormula.IntegerFormula number = (NumeralFormula.IntegerFormula)nfmgr.makeNumber(thresholdValue);
        NumeralFormula.IntegerFormula var = (NumeralFormula.IntegerFormula)nfmgr.makeVariable(this.predicateString);
        return nfmgr.equal((NumeralFormula)var, (NumeralFormula)number);
    }
}

