/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.automaton;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.CharStreams;
import com.google.common.io.MoreFiles;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.automaton.VerificationTaskMetaData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AutomatonGraphmlCommon {
    private static final String CPACHECKER_TMP_PREFIX = "__CPACHECKER_TMP";
    public static final String SINK_NODE_ID = "sink";
    public static final NodeType defaultNodeType = NodeType.ONPATH;

    public static String computeHash(Path pPath) throws IOException {
        HashCode hash = MoreFiles.asByteSource((Path)pPath, (OpenOption[])new OpenOption[0]).hash(Hashing.sha256());
        return BaseEncoding.base16().lowerCase().encode(hash.asBytes());
    }

    public static String computeSha1Hash(Path pPath) throws IOException {
        HashCode hash = MoreFiles.asByteSource((Path)pPath, (OpenOption[])new OpenOption[0]).hash(Hashing.sha1());
        return BaseEncoding.base16().lowerCase().encode(hash.asBytes());
    }

    public static boolean handleAsEpsilonEdge(CFAEdge pEdge, CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        if (pAdditionalInfo != null && !pAdditionalInfo.getInfos().isEmpty()) {
            return false;
        }
        return AutomatonGraphmlCommon.handleAsEpsilonEdge(pEdge);
    }

    public static boolean handleAsEpsilonEdge(CFAEdge edge) {
        return AutomatonGraphmlCommon.handleAsEpsilonEdge0(edge) && edge.getSuccessor().getNumLeavingEdges() > 0;
    }

    private static boolean handleAsEpsilonEdge0(CFAEdge edge) {
        if (edge instanceof BlankEdge) {
            if (AutomatonGraphmlCommon.isMainFunctionEntry(edge)) {
                return false;
            }
            if (edge.getSuccessor() instanceof FunctionExitNode) {
                return AutomatonGraphmlCommon.isEmptyStub(((FunctionExitNode)edge.getSuccessor()).getEntryNode());
            }
            if (AutomatonGraphmlCommon.treatAsTrivialAssume(edge)) {
                return false;
            }
            return !AutomatonGraphmlCommon.treatAsWhileTrue(edge);
        }
        if (edge instanceof CFunctionCallEdge) {
            return AutomatonGraphmlCommon.isEmptyStub(((CFunctionCallEdge)edge).getSuccessor());
        }
        if (edge instanceof CFunctionReturnEdge) {
            return AutomatonGraphmlCommon.isEmptyStub(((CFunctionReturnEdge)edge).getFunctionEntry());
        }
        if (edge instanceof CDeclarationEdge) {
            CDeclarationEdge declEdge = (CDeclarationEdge)edge;
            CDeclaration decl = declEdge.getDeclaration();
            if (decl instanceof CFunctionDeclaration) {
                return true;
            }
            if (decl instanceof CTypeDeclaration) {
                return true;
            }
            if (decl instanceof CVariableDeclaration) {
                CVariableDeclaration varDecl = (CVariableDeclaration)decl;
                if (varDecl.getName().toUpperCase().startsWith(CPACHECKER_TMP_PREFIX)) {
                    return true;
                }
                if (AutomatonGraphmlCommon.isSplitDeclaration(edge)) {
                    return true;
                }
            }
        } else {
            if (edge instanceof CFunctionSummaryStatementEdge) {
                return true;
            }
            if (edge instanceof AStatementEdge) {
                AStatementEdge statementEdge = (AStatementEdge)edge;
                AStatement statement = statementEdge.getStatement();
                if (statement instanceof AExpressionStatement) {
                    AIdExpression idExpression;
                    AExpressionStatement expressionStatement = (AExpressionStatement)statement;
                    AExpression expression = expressionStatement.getExpression();
                    if (expression instanceof AIdExpression && (idExpression = (AIdExpression)expression).getName().toUpperCase().startsWith(CPACHECKER_TMP_PREFIX)) {
                        return true;
                    }
                } else {
                    return AutomatonGraphmlCommon.isTmpPartOfTernaryExpressionAssignment(statementEdge);
                }
            }
        }
        return false;
    }

    private static boolean isTmpPartOfTernaryExpressionAssignment(AStatementEdge statementEdge) {
        AStatement statement = statementEdge.getStatement();
        if (!(statement instanceof AExpressionAssignmentStatement)) {
            return false;
        }
        AExpressionAssignmentStatement tmpAssignment = (AExpressionAssignmentStatement)statement;
        ALeftHandSide lhs = tmpAssignment.getLeftHandSide();
        if (!(lhs instanceof AIdExpression)) {
            return false;
        }
        AIdExpression idExpression = (AIdExpression)lhs;
        if (!idExpression.getName().toUpperCase().startsWith(CPACHECKER_TMP_PREFIX)) {
            return false;
        }
        FluentIterable<CFAEdge> successorEdges = CFAUtils.leavingEdges(statementEdge.getSuccessor());
        if (successorEdges.size() != 1) {
            return false;
        }
        CFAEdge successorEdge = (CFAEdge)successorEdges.iterator().next();
        if (!(successorEdge instanceof AStatementEdge)) {
            return false;
        }
        FileLocation edgeLoc = statementEdge.getFileLocation();
        FileLocation successorEdgeLoc = successorEdge.getFileLocation();
        if (successorEdgeLoc.getNodeOffset() > edgeLoc.getNodeOffset() || successorEdgeLoc.getNodeOffset() + successorEdgeLoc.getNodeLength() < edgeLoc.getNodeOffset() + edgeLoc.getNodeLength()) {
            return false;
        }
        AStatementEdge successorStatementEdge = (AStatementEdge)successorEdge;
        AStatement successorStatement = successorStatementEdge.getStatement();
        if (!(successorStatement instanceof AExpressionAssignmentStatement)) {
            return false;
        }
        AExpressionAssignmentStatement targetAssignment = (AExpressionAssignmentStatement)successorStatement;
        return targetAssignment.getRightHandSide().equals(idExpression);
    }

    public static boolean isMainFunctionEntry(CFAEdge pEdge) {
        return AutomatonGraphmlCommon.isFunctionStartDummyEdge(pEdge) && !(pEdge.getPredecessor() instanceof FunctionEntryNode);
    }

    public static boolean isFunctionStartDummyEdge(CFAEdge pEdge) {
        if (!(pEdge instanceof BlankEdge)) {
            return false;
        }
        BlankEdge edge = (BlankEdge)pEdge;
        return edge.getDescription().equals("Function start dummy edge");
    }

    public static String getArchitecture(MachineModel pMachineModel) {
        String architecture;
        switch (pMachineModel) {
            case LINUX32: {
                architecture = "32bit";
                break;
            }
            case LINUX64: {
                architecture = "64bit";
                break;
            }
            default: {
                architecture = pMachineModel.toString();
            }
        }
        return architecture;
    }

    public static Set<FileLocation> getFileLocationsFromCfaEdge(CFAEdge pEdge, FunctionEntryNode pMainEntry, CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        if (AutomatonGraphmlCommon.handleAsEpsilonEdge(pEdge, pAdditionalInfo)) {
            return ImmutableSet.of();
        }
        return AutomatonGraphmlCommon.getFileLocationsFromCfaEdge0(pEdge, pMainEntry);
    }

    public static Set<FileLocation> getFileLocationsFromCfaEdge(CFAEdge pEdge, FunctionEntryNode pMainEntry) {
        if (AutomatonGraphmlCommon.handleAsEpsilonEdge(pEdge)) {
            return ImmutableSet.of();
        }
        return AutomatonGraphmlCommon.getFileLocationsFromCfaEdge0(pEdge, pMainEntry);
    }

    public static Set<FileLocation> getFileLocationsFromCfaEdge0(CFAEdge pEdge, FunctionEntryNode pMainEntry) {
        ADeclarationEdge declarationEdge;
        ADeclaration declaration;
        AFunctionCallAssignmentStatement aFunctionCallAssignmentStatement;
        FileLocation callLocation;
        AFunctionCall call;
        FunctionCallEdge functionCallEdge;
        FunctionSummaryEdge summaryEdge;
        AStatementEdge statementEdge;
        FileLocation statementLocation;
        if (AutomatonGraphmlCommon.isMainFunctionEntry(pEdge) && pMainEntry.getFunctionName().equals(pEdge.getSuccessor().getFunctionName())) {
            FileLocation location = pMainEntry.getFileLocation();
            if (location.isRealLocation()) {
                location = new FileLocation(location.getFileName(), location.getNiceFileName(), location.getNodeOffset(), pMainEntry.getFunctionDefinition().toString().length(), location.getStartingLineNumber(), location.getStartingLineNumber(), location.getStartingLineInOrigin(), location.getStartingLineInOrigin(), location.isOffsetRelatedToOrigin());
            }
            HashSet result = Sets.newHashSet((Object[])new FileLocation[]{location});
            for (AParameterDeclaration aParameterDeclaration : pMainEntry.getFunctionDefinition().getParameters()) {
                result.add(aParameterDeclaration.getFileLocation());
            }
            return result;
        }
        if (pEdge instanceof AStatementEdge && (statementLocation = (statementEdge = (AStatementEdge)pEdge).getStatement().getFileLocation()).isRealLocation()) {
            return Collections.singleton(statementLocation);
        }
        if (pEdge instanceof FunctionCallEdge && (summaryEdge = (functionCallEdge = (FunctionCallEdge)pEdge).getSummaryEdge()) != null && summaryEdge.getExpression() != null && (call = summaryEdge.getExpression()) instanceof AFunctionCallAssignmentStatement && (callLocation = (aFunctionCallAssignmentStatement = (AFunctionCallAssignmentStatement)call).getRightHandSide().getFileLocation()).isRealLocation()) {
            return Collections.singleton(callLocation);
        }
        if (pEdge instanceof AssumeEdge) {
            AssumeEdge assumeEdge = (AssumeEdge)pEdge;
            FileLocation location = assumeEdge.getFileLocation();
            if (AutomatonGraphmlCommon.isDefaultCase(assumeEdge)) {
                CFANode successorNode = assumeEdge.getSuccessor();
                FileLocation fileLocation = ((CFAEdge)Iterables.getOnlyElement(CFAUtils.leavingEdges(successorNode))).getFileLocation();
                if (fileLocation.isRealLocation()) {
                    location = fileLocation;
                } else {
                    SwitchDetector switchDetector = new SwitchDetector(assumeEdge);
                    CFATraversal.dfs().backwards().traverseOnce(assumeEdge.getSuccessor(), switchDetector);
                    ImmutableList caseLocations = Collections3.transformedImmutableListCopy(switchDetector.getEdgesBackwardToSwitchNode(), CFAEdge::getFileLocation);
                    location = FileLocation.merge((List<FileLocation>)caseLocations);
                }
            }
            if (location.isRealLocation()) {
                return Collections.singleton(location);
            }
        }
        if (pEdge instanceof ADeclarationEdge && (declaration = (declarationEdge = (ADeclarationEdge)pEdge).getDeclaration()) instanceof AVariableDeclaration) {
            return Collections.singleton(declaration.getFileLocation());
        }
        return CFAUtils.getFileLocationsFromCfaEdge(pEdge);
    }

    public static boolean isPartOfSwitchStatement(AssumeEdge pAssumeEdge) {
        SwitchDetector switchDetector = new SwitchDetector(pAssumeEdge);
        CFATraversal.dfs().backwards().traverseOnce(pAssumeEdge.getSuccessor(), switchDetector);
        return switchDetector.switchDetected();
    }

    public static boolean isDefaultCase(CFAEdge pEdge) {
        if (!(pEdge instanceof AssumeEdge)) {
            return false;
        }
        AssumeEdge assumeEdge = (AssumeEdge)pEdge;
        if (assumeEdge.getTruthAssumption()) {
            return false;
        }
        FluentIterable<CFAEdge> successorEdges = CFAUtils.leavingEdges(assumeEdge.getSuccessor());
        if (successorEdges.size() != 1) {
            return false;
        }
        CFAEdge successorEdge = (CFAEdge)successorEdges.iterator().next();
        if (!(successorEdge instanceof BlankEdge)) {
            return false;
        }
        BlankEdge blankSuccessorEdge = (BlankEdge)successorEdge;
        return blankSuccessorEdge.getDescription().equals("default");
    }

    public static boolean isSplitDeclaration(CFAEdge pEdge) {
        if (pEdge instanceof ADeclarationEdge) {
            ADeclarationEdge declEdge = (ADeclarationEdge)pEdge;
            ADeclaration decl = declEdge.getDeclaration();
            if (decl instanceof AFunctionDeclaration) {
                return false;
            }
            if (decl instanceof CTypeDeclaration) {
                return false;
            }
            if (decl instanceof AVariableDeclaration) {
                AVariableDeclaration varDecl = (AVariableDeclaration)decl;
                CFANode successor = pEdge.getSuccessor();
                boolean intermediateDeclarationsExpected = true;
                boolean cont = true;
                while (cont) {
                    ADeclarationEdge otherDeclEdge;
                    cont = false;
                    Iterator leavingEdges = CFAUtils.leavingEdges(successor).iterator();
                    if (!leavingEdges.hasNext()) {
                        return false;
                    }
                    CFAEdge successorEdge = (CFAEdge)leavingEdges.next();
                    if (leavingEdges.hasNext()) {
                        CFAEdge alternativeSuccessorEdge = (CFAEdge)leavingEdges.next();
                        if (leavingEdges.hasNext()) {
                            return false;
                        }
                        if (successorEdge instanceof FunctionCallEdge && alternativeSuccessorEdge instanceof CFunctionSummaryStatementEdge) {
                            successorEdge = alternativeSuccessorEdge;
                        } else if (!(successorEdge instanceof CFunctionSummaryStatementEdge) || !(alternativeSuccessorEdge instanceof FunctionCallEdge)) {
                            return false;
                        }
                    }
                    if (successorEdge.getFileLocation().equals(pEdge.getFileLocation())) {
                        ALeftHandSide leftHandSide;
                        AAssignment assignment = null;
                        if (successorEdge instanceof FunctionCallEdge) {
                            FunctionCallEdge functionCallEdge = (FunctionCallEdge)successorEdge;
                            FunctionSummaryEdge summaryEdge = functionCallEdge.getSummaryEdge();
                            AFunctionCall functionCall = summaryEdge.getExpression();
                            if (functionCall instanceof AAssignment) {
                                assignment = (AAssignment)((Object)functionCall);
                                successorEdge = summaryEdge;
                            }
                        } else if (successorEdge instanceof AStatementEdge) {
                            intermediateDeclarationsExpected = false;
                            AStatementEdge statementEdge = (AStatementEdge)successorEdge;
                            if (statementEdge.getStatement() instanceof AAssignment) {
                                assignment = (AAssignment)((Object)statementEdge.getStatement());
                            }
                        }
                        if (assignment != null && (leftHandSide = assignment.getLeftHandSide()) instanceof AIdExpression) {
                            AIdExpression lhs = (AIdExpression)leftHandSide;
                            if (lhs.getDeclaration() != null && lhs.getDeclaration().equals(varDecl)) {
                                return true;
                            }
                            cont = true;
                            successor = successorEdge.getSuccessor();
                        }
                    }
                    if (!intermediateDeclarationsExpected || !(successorEdge instanceof ADeclarationEdge) || !((otherDeclEdge = (ADeclarationEdge)successorEdge).getDeclaration() instanceof AVariableDeclaration)) continue;
                    cont = true;
                    successor = successorEdge.getSuccessor();
                }
            }
        }
        return false;
    }

    public static boolean isSplitAssumption(CFAEdge pEdge) {
        if (!(pEdge instanceof AssumeEdge)) {
            return false;
        }
        return ((AssumeEdge)pEdge).isArtificialIntermediate();
    }

    public static boolean isPointerCallAssumption(CFAEdge pEdge) {
        AExpression expression;
        if (!(pEdge instanceof AssumeEdge)) {
            return false;
        }
        AssumeEdge assumeEdge = (AssumeEdge)pEdge;
        if (!assumeEdge.getTruthAssumption()) {
            assumeEdge = CFAUtils.getComplimentaryAssumeEdge(assumeEdge);
        }
        if (!((expression = assumeEdge.getExpression()) instanceof ABinaryExpression)) {
            return false;
        }
        ABinaryExpression binaryExpression = (ABinaryExpression)expression;
        ImmutableSet namesOnEdge = FluentIterable.of((Object)binaryExpression.getOperand1(), (Object[])new AExpression[]{binaryExpression.getOperand2()}).filter(AUnaryExpression.class).filter(unaryExpr -> unaryExpr.getOperator() == CUnaryExpression.UnaryOperator.AMPER).transform(unaryExpr -> unaryExpr.getOperand()).filter(AIdExpression.class).transform(id -> id.getName()).toSet();
        if (namesOnEdge.isEmpty()) {
            return false;
        }
        return !CFAUtils.leavingEdges(assumeEdge.getSuccessor()).filter(e -> e.getFileLocation().equals(pEdge.getFileLocation())).filter(FunctionCallEdge.class).filter(arg_0 -> AutomatonGraphmlCommon.lambda$isPointerCallAssumption$4((Set)namesOnEdge, arg_0)).isEmpty();
    }

    public static boolean isPartOfTerminatingAssumption(CFAEdge pEdge) {
        if (!(pEdge instanceof AssumeEdge)) {
            return false;
        }
        AssumeEdge assumeEdge = (AssumeEdge)pEdge;
        AssumeEdge siblingEdge = CFAUtils.getComplimentaryAssumeEdge(assumeEdge);
        if (assumeEdge.getSuccessor() instanceof CFATerminationNode || siblingEdge.getSuccessor() instanceof CFATerminationNode) {
            return true;
        }
        return AutomatonGraphmlCommon.isTerminatingAssumption(assumeEdge) || AutomatonGraphmlCommon.isTerminatingAssumption(siblingEdge);
    }

    private static boolean isTerminatingAssumption(CFAEdge pEdge) {
        ABinaryExpression.ABinaryOperator operator;
        if (!(pEdge instanceof AssumeEdge)) {
            return false;
        }
        AssumeEdge assumeEdge = (AssumeEdge)pEdge;
        FluentIterable<CFAEdge> leavingEdges = CFAUtils.leavingEdges(assumeEdge.getSuccessor());
        if (leavingEdges.size() != 1) {
            return false;
        }
        CFAEdge leavingEdge = (CFAEdge)leavingEdges.iterator().next();
        if (!(leavingEdge instanceof AStatementEdge)) {
            return false;
        }
        AStatementEdge terminationValueAssignmentEdge = (AStatementEdge)leavingEdge;
        AStatement statement = terminationValueAssignmentEdge.getStatement();
        if (!(statement instanceof AExpressionAssignmentStatement)) {
            return false;
        }
        AExpressionAssignmentStatement terminationValueAssignment = (AExpressionAssignmentStatement)statement;
        ALeftHandSide lhs = terminationValueAssignment.getLeftHandSide();
        AExpression rhs = terminationValueAssignment.getRightHandSide();
        if (!(lhs instanceof AIdExpression) || !(rhs instanceof ALiteralExpression)) {
            return false;
        }
        AIdExpression idExpression = (AIdExpression)lhs;
        if (!idExpression.getName().toUpperCase().startsWith(CPACHECKER_TMP_PREFIX)) {
            return false;
        }
        ALiteralExpression value = (ALiteralExpression)rhs;
        leavingEdges = CFAUtils.leavingEdges(terminationValueAssignmentEdge.getSuccessor());
        if (leavingEdges.size() != 2) {
            return false;
        }
        Optional potentialTerminationValueAssumeEdge = leavingEdges.firstMatch(e -> e.getSuccessor() instanceof CFATerminationNode).toJavaUtil();
        if (!potentialTerminationValueAssumeEdge.isPresent() || !(potentialTerminationValueAssumeEdge.orElseThrow() instanceof AssumeEdge)) {
            return false;
        }
        AssumeEdge terminationValueAssumption = (AssumeEdge)potentialTerminationValueAssumeEdge.orElseThrow();
        AExpression terminationValueAssumeExpression = terminationValueAssumption.getExpression();
        if (!(terminationValueAssumeExpression instanceof ABinaryExpression)) {
            return false;
        }
        ABinaryExpression terminationValueAssumeBinExpr = (ABinaryExpression)terminationValueAssumeExpression;
        List<AExpression> operands = Arrays.asList(terminationValueAssumeBinExpr.getOperand1(), terminationValueAssumeBinExpr.getOperand2());
        if (!operands.contains(idExpression)) {
            return false;
        }
        boolean flip = false;
        if (!operands.contains(value)) {
            flip = true;
        }
        if ((operator = terminationValueAssumeBinExpr.getOperator()).equals(CBinaryExpression.BinaryOperator.NOT_EQUALS) || operator.equals(JBinaryExpression.BinaryOperator.NOT_EQUALS)) {
            return flip == terminationValueAssumption.getTruthAssumption();
        }
        if (operator.equals(CBinaryExpression.BinaryOperator.EQUALS) || operator.equals(JBinaryExpression.BinaryOperator.EQUALS)) {
            return flip ^ terminationValueAssumption.getTruthAssumption();
        }
        return false;
    }

    private static boolean isEmptyStub(FunctionEntryNode pEntryNode) {
        Iterator startEdges = CFAUtils.leavingEdges(pEntryNode).iterator();
        if (!startEdges.hasNext()) {
            return false;
        }
        CFAEdge startEdge = (CFAEdge)startEdges.next();
        if (startEdges.hasNext() || !(startEdge instanceof BlankEdge)) {
            return false;
        }
        CFANode innerNode = startEdge.getSuccessor();
        Iterator defaultReturnEdges = CFAUtils.leavingEdges(innerNode).iterator();
        if (!defaultReturnEdges.hasNext()) {
            return false;
        }
        CFAEdge defaultReturnEdge = (CFAEdge)defaultReturnEdges.next();
        if (defaultReturnEdges.hasNext() || !(defaultReturnEdge instanceof BlankEdge)) {
            return false;
        }
        return pEntryNode.getExitNode().equals(defaultReturnEdge.getSuccessor());
    }

    public static boolean treatAsWhileTrue(CFAEdge pEdge) {
        CFANode pred = pEdge.getPredecessor();
        return pEdge instanceof BlankEdge && pred.getNumLeavingEdges() == 1 && CFAUtils.enteringEdges(pred).filter(BlankEdge.class).anyMatch(e -> e.getDescription().equals("while"));
    }

    private static boolean treatAsTrivialAssume(CFAEdge pEdge) {
        CFANode pred = pEdge.getPredecessor();
        if (pred.getNumLeavingEdges() != 1) {
            return false;
        }
        if (!(pEdge instanceof BlankEdge)) {
            return false;
        }
        BlankEdge edge = (BlankEdge)pEdge;
        if (!edge.getDescription().isEmpty()) {
            return false;
        }
        return !edge.getRawStatement().isEmpty() && !AutomatonGraphmlCommon.treatAsWhileTrue(pEdge) && !AutomatonGraphmlCommon.isFunctionStartDummyEdge(pEdge);
    }

    private static /* synthetic */ boolean lambda$isPointerCallAssumption$4(Set namesOnEdge, FunctionCallEdge e) {
        return namesOnEdge.contains(e.getSuccessor().getFunctionName());
    }

    public static class SwitchDetector
    implements CFATraversal.CFAVisitor {
        private final AExpression assumeExpression;
        private final AExpression switchOperand;
        private final List<AssumeEdge> edgesBackwardToSwitchNode = new ArrayList<AssumeEdge>();
        private CFANode switchNode = null;

        public SwitchDetector(AssumeEdge pAssumeEdge) {
            this.assumeExpression = pAssumeEdge.getExpression();
            this.switchOperand = this.assumeExpression instanceof ABinaryExpression ? ((ABinaryExpression)this.assumeExpression).getOperand1() : this.assumeExpression;
        }

        public boolean switchDetected() {
            return this.switchNode != null;
        }

        public List<AssumeEdge> getEdgesBackwardToSwitchNode() {
            Preconditions.checkState((boolean)this.switchDetected());
            return Collections.unmodifiableList(this.edgesBackwardToSwitchNode);
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            if (this.switchOperand == this.assumeExpression) {
                return CFATraversal.TraversalProcess.ABORT;
            }
            if (pEdge instanceof AssumeEdge) {
                AssumeEdge edge = (AssumeEdge)pEdge;
                AExpression expression = edge.getExpression();
                if (!(expression instanceof ABinaryExpression)) {
                    return CFATraversal.TraversalProcess.ABORT;
                }
                AExpression operand = ((ABinaryExpression)expression).getOperand1();
                if (!operand.equals(this.switchOperand)) {
                    return CFATraversal.TraversalProcess.ABORT;
                }
                this.edgesBackwardToSwitchNode.add(edge);
                return CFATraversal.TraversalProcess.CONTINUE;
            }
            if (pEdge instanceof BlankEdge) {
                BlankEdge edge = (BlankEdge)pEdge;
                String switchPrefix = "switch (";
                if (edge.getDescription().equals(switchPrefix + this.switchOperand + ")") && edge.getFileLocation().isRealLocation() && this.assumeExpression.getFileLocation().getNodeOffset() == edge.getFileLocation().getNodeOffset() + switchPrefix.length()) {
                    this.switchNode = edge.getSuccessor();
                    return CFATraversal.TraversalProcess.ABORT;
                }
                return CFATraversal.TraversalProcess.CONTINUE;
            }
            return CFATraversal.TraversalProcess.SKIP;
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }

    public static class GraphMlBuilder {
        private final Document doc;
        private final Element graph;
        private final Set<KeyDef> definedKeys = EnumSet.noneOf(KeyDef.class);
        private final Map<KeyDef, Node> keyDefsToAppend = new EnumMap<KeyDef, Node>(KeyDef.class);

        public GraphMlBuilder(WitnessType pGraphType, @Nullable String pDefaultSourceFileName, CFA pCfa, VerificationTaskMetaData pVerificationTaskMetaData) throws ParserConfigurationException, DOMException, IOException {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            Element root = this.doc.createElement("graphml");
            this.doc.appendChild(root);
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
            this.defineKey(KeyDef.ORIGINFILE, Optional.of(pDefaultSourceFileName));
            for (KeyDef keyDef : KeyDef.values()) {
                if (keyDef.keyFor != ElementType.GRAPH) continue;
                this.defineKey(keyDef);
            }
            this.graph = this.doc.createElement("graph");
            root.appendChild(this.graph);
            this.graph.setAttribute("edgedefault", "directed");
            this.graph.appendChild(this.createDataElement(KeyDef.WITNESS_TYPE, pGraphType.toString()));
            this.graph.appendChild(this.createDataElement(KeyDef.SOURCECODELANGUAGE, pCfa.getLanguage().toString()));
            this.graph.appendChild(this.createDataElement(KeyDef.PRODUCER, pVerificationTaskMetaData.getProducerString()));
            int nSpecs = 0;
            for (Property property : pVerificationTaskMetaData.getProperties()) {
                this.graph.appendChild(this.createDataElement(KeyDef.SPECIFICATION, property.toFullString(pCfa)));
                ++nSpecs;
            }
            for (Path specFile : pVerificationTaskMetaData.getNonPropertySpecificationFiles()) {
                this.graph.appendChild(this.createDataElement(KeyDef.SPECIFICATION, Files.readString(specFile, StandardCharsets.UTF_8).trim()));
                ++nSpecs;
            }
            if (nSpecs == 0) {
                this.graph.appendChild(this.createDataElement(KeyDef.SPECIFICATION, "TRUE"));
            }
            for (Path inputWitness : pVerificationTaskMetaData.getInputWitnessFiles()) {
                this.graph.appendChild(this.createDataElement(KeyDef.INPUTWITNESSHASH, AutomatonGraphmlCommon.computeHash(inputWitness)));
            }
            for (Path programFile : pCfa.getFileNames()) {
                this.graph.appendChild(this.createDataElement(KeyDef.PROGRAMFILE, programFile.toString()));
            }
            for (Path programFile : pCfa.getFileNames()) {
                this.graph.appendChild(this.createDataElement(KeyDef.PROGRAMHASH, AutomatonGraphmlCommon.computeHash(programFile)));
            }
            this.graph.appendChild(this.createDataElement(KeyDef.ARCHITECTURE, AutomatonGraphmlCommon.getArchitecture(pCfa.getMachineModel())));
            ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault()).withNano(0);
            this.graph.appendChild(this.createDataElement(KeyDef.CREATIONTIME, now.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        }

        private void defineKey(KeyDef pKeyDef) {
            this.defineKey(pKeyDef, Optional.empty());
        }

        private void defineKey(KeyDef pKeyDef, Optional<String> pOverrideDefaultValue) {
            if (this.definedKeys.add(pKeyDef)) {
                this.keyDefsToAppend.put(pKeyDef, this.createKeyDefElement(pKeyDef, pOverrideDefaultValue));
            }
        }

        private Element createElement(GraphMLTag tag) {
            return this.doc.createElement(tag.toString());
        }

        private Element createDataElement(KeyDef key, String value) {
            this.defineKey(key);
            Element result = this.createElement(GraphMLTag.DATA);
            result.setAttribute("key", key.id);
            result.setTextContent(value);
            return result;
        }

        public Element createEdgeElement(String from, String to) {
            Element result = this.createElement(GraphMLTag.EDGE);
            result.setAttribute("source", from);
            result.setAttribute("target", to);
            this.graph.appendChild(result);
            return result;
        }

        public Element createNodeElement(String nodeId, NodeType nodeType) {
            Element result = this.createElement(GraphMLTag.NODE);
            result.setAttribute("id", nodeId);
            if (nodeType != defaultNodeType) {
                this.addDataElementChild(result, KeyDef.NODETYPE, nodeType.toString());
            }
            this.graph.appendChild(result);
            return result;
        }

        private Element createKeyDefElement(KeyDef pKeyDef, Optional<String> pDefaultValue) {
            Element result = this.createElement(GraphMLTag.KEY);
            result.setAttribute("id", pKeyDef.id);
            result.setAttribute("for", pKeyDef.keyFor.toString());
            result.setAttribute("attr.name", pKeyDef.attrName);
            result.setAttribute("attr.type", pKeyDef.attrType);
            String defaultValue = pDefaultValue.orElse(pKeyDef.defaultValue);
            if (defaultValue != null) {
                Element defaultValueElement = this.createElement(GraphMLTag.DEFAULT);
                defaultValueElement.setTextContent(defaultValue);
                result.appendChild(defaultValueElement);
            }
            return result;
        }

        public void addDataElementChild(Element childOf, KeyDef key, String value) {
            Element result = this.createDataElement(key, value);
            childOf.appendChild(result);
        }

        public void appendTo(Appendable pTarget) throws IOException {
            Node root = this.doc.getFirstChild();
            Node insertionLocation = root.getFirstChild();
            for (Node graphMLKeyDefNode : Iterables.consumingIterable(this.keyDefsToAppend.values())) {
                while (insertionLocation != null && insertionLocation.getNodeName().equals(GraphMLTag.KEY.toString())) {
                    insertionLocation = insertionLocation.getNextSibling();
                }
                root.insertBefore(graphMLKeyDefNode, insertionLocation);
            }
            try {
                pTarget.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(new DOMSource(this.doc), new StreamResult(CharStreams.asWriter((Appendable)pTarget)));
            }
            catch (TransformerException ex) {
                for (Throwable cause : Throwables.getCausalChain((Throwable)ex)) {
                    Throwables.throwIfInstanceOf((Throwable)cause, IOException.class);
                }
                throw new RuntimeException("Error while writing witness.", ex);
            }
        }
    }

    public static enum GraphMLTag {
        NODE("node"),
        DATA("data"),
        KEY("key"),
        GRAPH("graph"),
        DEFAULT("default"),
        EDGE("edge");

        public final String text;

        private GraphMLTag(String pText) {
            this.text = pText;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum NodeType {
        ANNOTATION("annotation"),
        ONPATH("path");

        public final String text;

        private NodeType(String pText) {
            this.text = pText;
        }

        public String toString() {
            return this.text;
        }

        public static NodeType fromString(String nodeTypeString) {
            return NodeType.valueOf(nodeTypeString.trim().toLowerCase());
        }
    }

    public static enum WitnessType {
        VIOLATION_WITNESS("violation_witness"),
        CORRECTNESS_WITNESS("correctness_witness");

        public final String text;

        private WitnessType(String pText) {
            this.text = pText;
        }

        public String toString() {
            return this.text;
        }

        public static Optional<WitnessType> tryParse(String pTextualRepresentation) {
            for (WitnessType element : WitnessType.values()) {
                if (!element.text.equals(pTextualRepresentation)) continue;
                return Optional.of(element);
            }
            switch (pTextualRepresentation) {
                case "FALSE": 
                case "false_witness": {
                    return Optional.of(VIOLATION_WITNESS);
                }
                case "TRUE": 
                case "true_witness": {
                    return Optional.of(CORRECTNESS_WITNESS);
                }
            }
            return Optional.empty();
        }
    }

    public static enum NodeFlag {
        ISFRONTIER(KeyDef.ISFRONTIERNODE),
        ISVIOLATION(KeyDef.ISVIOLATIONNODE),
        ISENTRY(KeyDef.ISENTRYNODE),
        ISSINKNODE(KeyDef.ISSINKNODE),
        ISCYCLEHEAD(KeyDef.ISCYCLEHEAD);

        public final KeyDef key;
        private static final Map<String, NodeFlag> stringToFlagMap;

        private NodeFlag(KeyDef pKey) {
            this.key = pKey;
        }

        public static NodeFlag getNodeFlagByKey(String key) {
            return stringToFlagMap.get(key);
        }

        static {
            stringToFlagMap = new HashMap<String, NodeFlag>();
            for (NodeFlag f : NodeFlag.values()) {
                stringToFlagMap.put(f.key.id, f);
            }
        }
    }

    public static enum ElementType {
        GRAPH,
        EDGE,
        NODE;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static ElementType parse(String pElementType) {
            return ElementType.valueOf(pElementType.toUpperCase());
        }
    }

    public static enum KeyDef {
        INVARIANT("invariant", ElementType.NODE, "invariant", "string"),
        INVARIANTSCOPE("invariant.scope", ElementType.NODE, "invariant.scope", "string"),
        NAMED("named", ElementType.NODE, "namedValue", "string"),
        LABEL("label", ElementType.NODE, "label", "string"),
        NODETYPE("nodetype", ElementType.NODE, "nodeType", "string", (Object)((Object)NodeType.ONPATH)),
        ISFRONTIERNODE("frontier", ElementType.NODE, "isFrontierNode", "boolean", false),
        ISVIOLATIONNODE("violation", ElementType.NODE, "isViolationNode", "boolean", false),
        ISENTRYNODE("entry", ElementType.NODE, "isEntryNode", "boolean", false),
        ISSINKNODE("sink", ElementType.NODE, "isSinkNode", "boolean", false),
        ISCYCLEHEAD("cyclehead", ElementType.NODE, "isCycleHead", "boolean", false),
        ENTERLOOPHEAD("enterLoopHead", ElementType.EDGE, "enterLoopHead", "boolean", false),
        VIOLATEDPROPERTY("violatedProperty", ElementType.NODE, "violatedProperty", "string"),
        THREADNAME("threadName", ElementType.EDGE, "threadName", "string"),
        THREADID("threadId", ElementType.EDGE, "threadId", "string"),
        CREATETHREAD("createThread", ElementType.EDGE, "createThread", "string"),
        SOURCECODELANGUAGE("sourcecodelang", ElementType.GRAPH, "sourcecodeLanguage", "string"),
        PROGRAMFILE("programfile", ElementType.GRAPH, "programFile", "string"),
        PROGRAMHASH("programhash", ElementType.GRAPH, "programHash", "string"),
        SPECIFICATION("specification", ElementType.GRAPH, "specification", "string"),
        ARCHITECTURE("architecture", ElementType.GRAPH, "architecture", "string"),
        PRODUCER("producer", ElementType.GRAPH, "producer", "string"),
        CREATIONTIME("creationtime", ElementType.GRAPH, "creationTime", "string"),
        SOURCECODE("sourcecode", ElementType.EDGE, "sourcecode", "string"),
        STARTLINE("startline", ElementType.EDGE, "startline", "int"),
        ENDLINE("endline", ElementType.EDGE, "endline", "int"),
        OFFSET("startoffset", ElementType.EDGE, "startoffset", "int"),
        ENDOFFSET("endoffset", ElementType.EDGE, "endoffset", "int"),
        ORIGINFILE("originfile", ElementType.EDGE, "originFileName", "string"),
        LINECOLS("lineCols", ElementType.EDGE, "lineColSet", "string"),
        CONTROLCASE("control", ElementType.EDGE, "control", "string"),
        ASSUMPTION("assumption", ElementType.EDGE, "assumption", "string"),
        ASSUMPTIONRESULTFUNCTION("assumption.resultfunction", ElementType.EDGE, "assumption.resultfunction", "string"),
        ASSUMPTIONSCOPE("assumption.scope", ElementType.EDGE, "assumption.scope", "string"),
        FUNCTIONENTRY("enterFunction", ElementType.EDGE, "enterFunction", "string"),
        FUNCTIONEXIT("returnFrom", ElementType.EDGE, "returnFromFunction", "string"),
        CFAPREDECESSORNODE("predecessor", ElementType.EDGE, "predecessor", "string"),
        CFASUCCESSORNODE("successor", ElementType.EDGE, "successor", "string"),
        WITNESS_TYPE("witness-type", ElementType.GRAPH, "witness-type", "string"),
        INPUTWITNESSHASH("inputwitnesshash", ElementType.GRAPH, "inputWitnessHash", "string"),
        NOTE("note", ElementType.EDGE, "note", "string"),
        WARNING("warning", ElementType.EDGE, "warning", "string"),
        DECL("declaration", ElementType.EDGE, "declaration", "boolean", false);

        public final String id;
        public final ElementType keyFor;
        public final String attrName;
        public final String attrType;
        public final @Nullable String defaultValue;

        private KeyDef(String pId, ElementType pKeyFor, String pAttrName, String pAttrType) {
            this(pId, pKeyFor, pAttrName, pAttrType, null);
        }

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        private KeyDef(String pId, ElementType pKeyFor, @Nullable String pAttrName, String pAttrType, Object pDefaultValue) {
            this.id = (String)Preconditions.checkNotNull((Object)pId);
            this.keyFor = (ElementType)((Object)Preconditions.checkNotNull((Object)((Object)pKeyFor)));
            this.attrName = (String)Preconditions.checkNotNull((Object)pAttrName);
            this.attrType = (String)Preconditions.checkNotNull((Object)pAttrType);
            this.defaultValue = pDefaultValue == null ? null : pDefaultValue.toString();
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum AssumeCase {
        THEN("condition-true"),
        ELSE("condition-false");

        private final String name;

        private AssumeCase(String pName) {
            this.name = pName;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

