/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.automaton;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProviderImpl;

public class CachingTargetLocationProvider
implements TargetLocationProvider {
    private final TargetLocationProvider backingTargetLocationProvider;
    private final LoadingCache<CacheKey, ImmutableSet<CFANode>> cache = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<CacheKey, ImmutableSet<CFANode>>(){

        public ImmutableSet<CFANode> load(CacheKey pCacheKey) {
            return CachingTargetLocationProvider.this.backingTargetLocationProvider.tryGetAutomatonTargetLocations(pCacheKey.node, pCacheKey.specification);
        }
    });

    public CachingTargetLocationProvider(TargetLocationProvider pBackingTargetLocationProvider) {
        this.backingTargetLocationProvider = pBackingTargetLocationProvider;
    }

    public CachingTargetLocationProvider(ShutdownNotifier pShutdownNotifier, LogManager pLogManager, CFA pCfa) {
        this(new TargetLocationProviderImpl(pShutdownNotifier, pLogManager, pCfa));
    }

    @Override
    public ImmutableSet<CFANode> tryGetAutomatonTargetLocations(CFANode pRootNode, Specification specification) {
        return (ImmutableSet)this.cache.getUnchecked((Object)new CacheKey(pRootNode, specification));
    }

    private static class CacheKey {
        private final CFANode node;
        private final Specification specification;

        public CacheKey(CFANode pNode, Specification pSpecification) {
            this.node = pNode;
            this.specification = pSpecification;
        }

        public String toString() {
            return this.node + ": " + this.specification;
        }

        public int hashCode() {
            return Objects.hash(this.node, this.specification);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof CacheKey) {
                CacheKey other = (CacheKey)pObj;
                return this.node.equals(other.node) && this.specification.equals(other.specification);
            }
            return false;
        }
    }
}

