/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.automaton;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;

public class TargetLocationProviderImpl
implements TargetLocationProvider {
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logManager;
    private final CFA cfa;
    private final ImmutableSet<CFANode> allNodes;

    public TargetLocationProviderImpl(ShutdownNotifier pShutdownNotifier, LogManager pLogManager, CFA pCfa) {
        this.shutdownNotifier = pShutdownNotifier;
        this.logManager = pLogManager.withComponentName("TargetLocationProvider");
        this.cfa = pCfa;
        this.allNodes = ImmutableSet.copyOf(this.cfa.getAllNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<CFANode> tryGetAutomatonTargetLocations(CFANode pRootNode, Specification specification) {
        try {
            ConfigurationBuilder configurationBuilder = Configuration.builder();
            configurationBuilder.loadFromResource(this.getClass(), "find-target-locations.properties");
            Configuration configuration = configurationBuilder.build();
            ReachedSetFactory reachedSetFactory = new ReachedSetFactory(configuration, this.logManager);
            CPABuilder cpaBuilder = new CPABuilder(configuration, this.logManager, this.shutdownNotifier, reachedSetFactory);
            ConfigurableProgramAnalysis cpa = cpaBuilder.buildCPAs(this.cfa, specification, AggregatedReachedSets.empty());
            ReachedSet reached = reachedSetFactory.createAndInitialize(cpa, pRootNode, StateSpacePartition.getDefaultPartition());
            CPAAlgorithm targetFindingAlgorithm = CPAAlgorithm.create(cpa, this.logManager, configuration, this.shutdownNotifier);
            try {
                while (reached.hasWaitingState()) {
                    targetFindingAlgorithm.run(reached);
                }
            }
            finally {
                CPAs.closeCpaIfPossible(cpa, this.logManager);
                CPAs.closeIfPossible(targetFindingAlgorithm, this.logManager);
            }
            return FluentIterable.from((Iterable)reached).filter(AbstractStates::isTargetState).transform(AbstractStates::extractLocation).toSet();
        }
        catch (InvalidConfigurationException e) {
            throw new AssertionError("Configuration of TargetLocationProviderImpl failed", e);
        }
        catch (AutomatonTransferException e) {
            this.logManager.logUserException(Level.INFO, (Throwable)e, "Unable to find precise set of target locations. Defaulting to selecting all locations as potential target locations.");
            return this.allNodes;
        }
        catch (CPAException e) {
            if (!e.toString().toLowerCase().contains("recursion")) {
                this.logManager.logUserException(Level.WARNING, (Throwable)e, "Unable to find target locations. Defaulting to selecting all locations as potential target locations.");
            } else {
                this.logManager.log(Level.INFO, new Object[]{"Recursion detected. Defaulting to selecting all locations as potential target locations."});
                this.logManager.logDebugException((Throwable)e);
            }
            return this.allNodes;
        }
        catch (InterruptedException e) {
            if (!this.shutdownNotifier.shouldShutdown()) {
                this.logManager.logException(Level.WARNING, (Throwable)e, "Unable to find target locations. Defaulting to selecting all locations as potential target locations.");
            } else {
                this.logManager.log(Level.WARNING, new Object[]{"Finding target locations was interrupted. Defaulting to select all locations as potential target locations."});
            }
            return this.allNodes;
        }
    }
}

