/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonGraphmlParser;

public class VerificationTaskMetaData {
    private final HackyOptions hackyOptions = new HackyOptions();
    private final Specification specification;
    private List<Path> nonWitnessAutomatonFiles = null;
    private List<Path> witnessAutomatonFiles = null;
    private final String producerString;

    public VerificationTaskMetaData(Configuration pConfig, Specification pSpecification) throws InvalidConfigurationException {
        pConfig.inject((Object)this.hackyOptions);
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.producerString = CPAchecker.getVersion(pConfig);
    }

    public List<Path> getInputWitnessFiles() throws IOException {
        this.classifyAutomataFiles();
        return this.witnessAutomatonFiles;
    }

    public List<Path> getNonPropertySpecificationFiles() throws IOException {
        this.classifyAutomataFiles();
        return this.nonWitnessAutomatonFiles;
    }

    public Set<Property> getProperties() {
        return this.specification.getProperties();
    }

    public String getProducerString() {
        return this.producerString;
    }

    private void classifyAutomataFiles() throws IOException {
        if (this.nonWitnessAutomatonFiles == null) {
            assert (this.witnessAutomatonFiles == null);
            ImmutableList.Builder nonWitnessAutomatonFilesBuilder = ImmutableList.builder();
            ImmutableList.Builder witnessAutomatonFilesBuilder = ImmutableList.builder();
            ImmutableSet specs = Collections3.transformedImmutableSetCopy(this.specification.getFiles(), Path::normalize);
            for (Path path : specs) {
                if (MoreFiles.getFileExtension((Path)path).equals("prp")) continue;
                if (AutomatonGraphmlParser.isGraphmlAutomaton(path)) {
                    witnessAutomatonFilesBuilder.add((Object)path);
                    continue;
                }
                nonWitnessAutomatonFilesBuilder.add((Object)path);
            }
            Optional<Path> correctnessWitness = Optional.ofNullable(this.hackyOptions.invariantsAutomatonFile).map(Path::normalize);
            if (correctnessWitness.isPresent() && !specs.contains(correctnessWitness.orElseThrow())) {
                witnessAutomatonFilesBuilder.add((Object)correctnessWitness.orElseThrow());
            }
            this.witnessAutomatonFiles = witnessAutomatonFilesBuilder.build();
            this.nonWitnessAutomatonFiles = nonWitnessAutomatonFilesBuilder.build();
        } else assert (this.witnessAutomatonFiles != null);
    }

    @Options
    private static class HackyOptions {
        @Option(secure=true, name="invariantGeneration.kInduction.invariantsAutomatonFile", description="Provides additional candidate invariants to the k-induction invariant generator.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private Path invariantsAutomatonFile = null;

        private HackyOptions() {
        }
    }
}

