/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.blocking;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.blocking.ReducedEdge;
import org.sosy_lab.cpachecker.util.blocking.ReducedFunction;
import org.sosy_lab.cpachecker.util.blocking.ReducedNode;

public class ReducedFunctionTest {
    @Test
    public void testAddAndRemoveEdges() {
        ReducedNode entryNode = new ReducedNode(null, false);
        ReducedNode exitNode = new ReducedNode(null, false);
        ReducedNode n1 = new ReducedNode(null, false);
        ReducedNode n2 = new ReducedNode(null, false);
        ReducedNode n3 = new ReducedNode(null, false);
        ReducedFunctionUnderTest funct = new ReducedFunctionUnderTest(entryNode, exitNode);
        ReducedEdge e1 = funct.addEdge(n1, n2);
        ReducedEdge e2 = funct.addEdge(n2, n3);
        funct.addEdge(n1, n3);
        funct.removeEdge(n1, n2, e1);
        funct.removeEdge(n2, n3, e2);
        Truth.assertThat((Integer)funct.getNumOfActiveNodes()).isEqualTo((Object)2);
        Truth.assertThat(funct.getAllActiveNodes()).hasSize(2);
        Truth.assertThat(funct.getLeavingEdges(n1)).hasSize(1);
        Truth.assertThat((Integer)funct.getNumEnteringEdges(n3)).isEqualTo((Object)1);
        Truth.assertThat(funct.getLeavingEdges(n3)).hasSize(0);
    }

    @Test
    public void testUltimate() {
        ReducedNode entryNode = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode exitNode = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n4 = new ReducedNode(CFANode.newDummyCFANode("loophead"), false);
        ReducedNode n5 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n6 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n7 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n8 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n9 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n20 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n21 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n22 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n23 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n24 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedNode n25 = new ReducedNode(CFANode.newDummyCFANode("test"), false);
        ReducedFunction funct = new ReducedFunction(entryNode, exitNode);
        funct.addEdge(entryNode, n4);
        funct.addEdge(n4, n8);
        funct.addEdge(n4, n5);
        funct.addEdge(n5, n6);
        funct.addEdge(n6, n7);
        funct.addEdge(n7, n4);
        funct.addEdge(n8, n9);
        funct.addEdge(n9, n20);
        funct.addEdge(n20, n21);
        funct.addEdge(n21, n22);
        funct.addEdge(n22, n23);
        funct.addEdge(n23, n24);
        funct.addEdge(n24, n25);
        funct.addEdge(n25, exitNode);
    }

    @Test
    public void test() {
        ReducedNode entryNode = new ReducedNode(null, false);
        ReducedNode exitNode = new ReducedNode(null, false);
        ReducedNode n1 = new ReducedNode(null, false);
        ReducedNode n2 = new ReducedNode(null, false);
        ReducedNode n3 = new ReducedNode(null, false);
        ReducedNode n4 = new ReducedNode(null, false);
        ReducedNode n5 = new ReducedNode(null, false);
        ReducedFunctionUnderTest funct = new ReducedFunctionUnderTest(entryNode, exitNode);
        funct.addEdge(n1, n2);
        funct.addEdge(n2, n3);
        funct.addEdge(n3, n4);
        funct.addEdge(n4, n5);
        Truth.assertThat((Object)funct.getEntryNode()).isEqualTo((Object)entryNode);
        Truth.assertThat((Object)funct.getExitNode()).isEqualTo((Object)exitNode);
        Truth.assertThat((Integer)funct.getNumLeavingEdges(n1)).isEqualTo((Object)1);
        Truth.assertThat((Integer)funct.getNumLeavingEdges(n2)).isEqualTo((Object)1);
        Truth.assertThat((Integer)funct.getNumLeavingEdges(n3)).isEqualTo((Object)1);
        Truth.assertThat((Integer)funct.getNumLeavingEdges(n5)).isEqualTo((Object)0);
        Truth.assertThat(funct.getLeavingEdges(n1)).hasSize(1);
        Truth.assertThat(funct.getLeavingEdges(n5)).hasSize(0);
    }

    @Test
    public void test_MultipleEdgesBetweenTwoNodes() {
        ReducedNode entryNode = new ReducedNode(null, false);
        ReducedNode exitNode = new ReducedNode(null, false);
        ReducedFunctionUnderTest funct = new ReducedFunctionUnderTest(entryNode, exitNode);
        funct.addEdge(entryNode, exitNode);
        funct.addEdge(entryNode, exitNode);
        Truth.assertThat((Integer)funct.getNumLeavingEdges(entryNode)).isEqualTo((Object)2);
        Truth.assertThat((Integer)funct.getNumEnteringEdges(exitNode)).isEqualTo((Object)2);
    }

    private static class ReducedFunctionUnderTest
    extends ReducedFunction {
        public ReducedFunctionUnderTest(ReducedNode pEntryNode, ReducedNode pExitNode) {
            super(pEntryNode, pExitNode);
        }
    }
}

