/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class AppliedCustomInstruction {
    private final CFANode ciStartNode;
    private final Collection<CFANode> ciEndNodes;
    private final List<String> inputVariables;
    private final List<String> outputVariables;
    private final List<String> inputVariablesAndConstants;
    private final Pair<List<String>, String> fakeDescription;
    private final SSAMap indicesForReturnVars;

    public AppliedCustomInstruction(CFANode pCiStartNode, Collection<CFANode> pCiEndNodes, List<String> pInputVariables, List<String> pOutputVariables, List<String> inputVarsAndConstants, Pair<List<String>, String> pFakeDescription, SSAMap pIndicesForReturnVars) {
        this.ciStartNode = pCiStartNode;
        this.ciEndNodes = pCiEndNodes;
        this.inputVariables = pInputVariables;
        this.outputVariables = pOutputVariables;
        this.inputVariablesAndConstants = inputVarsAndConstants;
        this.fakeDescription = pFakeDescription;
        this.indicesForReturnVars = pIndicesForReturnVars;
    }

    public boolean isStartState(AbstractState pState) throws CPAException {
        CFANode locState = AbstractStates.extractLocation(pState);
        if (locState == null) {
            throw new CPAException("The State " + pState + " has to contain a location state!");
        }
        return locState.equals(this.ciStartNode);
    }

    public boolean isEndState(AbstractState pState) throws CPAException {
        CFANode locState = AbstractStates.extractLocation(pState);
        if (locState == null) {
            throw new CPAException("The State " + pState + " has to contain a location state!");
        }
        return this.ciEndNodes.contains(locState);
    }

    public Pair<List<String>, String> getFakeSMTDescription() {
        return this.fakeDescription;
    }

    public SSAMap getIndicesForReturnVars() {
        return this.indicesForReturnVars;
    }

    public Collection<CFANode> getStartAndEndNodes() {
        return ImmutableSet.builder().add((Object)this.ciStartNode).addAll(this.ciEndNodes).build();
    }

    public List<String> getInputVariables() {
        return this.inputVariables;
    }

    public List<String> getOutputVariables() {
        return this.outputVariables;
    }

    public List<String> getInputVariablesAndConstants() {
        return this.inputVariablesAndConstants;
    }
}

