/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatorVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParsingFailedException;
import org.sosy_lab.cpachecker.util.ci.CustomInstruction;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionApplications;

public class AppliedCustomInstructionParser {
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logger;
    private final CFA cfa;
    private final ImmutableMap<Integer, CFANode> numberToCFANode;
    private final GlobalVarCheckVisitor visitor = new GlobalVarCheckVisitor();

    public AppliedCustomInstructionParser(ShutdownNotifier pShutdownNotifier, LogManager pLogger, CFA pCfa) {
        this.shutdownNotifier = pShutdownNotifier;
        this.logger = pLogger;
        this.cfa = pCfa;
        ImmutableMap.Builder nodeNumberToNode0 = ImmutableMap.builder();
        for (CFANode node : this.cfa.getAllNodes()) {
            nodeNumberToNode0.put((Object)node.getNodeNumber(), (Object)node);
        }
        this.numberToCFANode = nodeNumberToNode0.buildOrThrow();
    }

    public CustomInstructionApplications parse(Path file, Path signatureFile) throws IOException, AppliedCustomInstructionParsingFailedException, InterruptedException {
        CustomInstruction ci = null;
        try (BufferedReader br = Files.newBufferedReader(file);){
            String line = br.readLine();
            if (line == null) {
                throw new AppliedCustomInstructionParsingFailedException("Empty specification. Missing at least function name for custom instruction.");
            }
            ci = this.readCustomInstruction(line);
            this.writeCustomInstructionSpecification(ci, signatureFile);
            CustomInstructionApplications customInstructionApplications = this.parseACIs(br, ci);
            return customInstructionApplications;
        }
    }

    private void writeCustomInstructionSpecification(CustomInstruction ci, Path signatureFile) throws IOException {
        try (Writer br = IO.openOutputFile((Path)signatureFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            br.write(ci.getSignature() + "\n");
            String ciString = ci.getFakeSMTDescription().getSecond();
            int index = ciString.indexOf("a");
            index = index == -1 || ciString.charAt(index - 1) != '(' ? ciString.indexOf("(", ciString.indexOf("B")) : --index;
            if (index != -1) {
                br.write(ciString.substring(index, ciString.length() - 1) + ";");
            }
        }
    }

    public CustomInstructionApplications parse(CustomInstruction pCi, Path file) throws AppliedCustomInstructionParsingFailedException, IOException, InterruptedException {
        try (BufferedReader br = Files.newBufferedReader(file);){
            CustomInstructionApplications customInstructionApplications = this.parseACIs(br, pCi);
            return customInstructionApplications;
        }
    }

    private CustomInstructionApplications parseACIs(BufferedReader br, CustomInstruction ci) throws AppliedCustomInstructionParsingFailedException, IOException, InterruptedException {
        String line;
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        while ((line = br.readLine()) != null) {
            AppliedCustomInstruction aci;
            CFANode startNode;
            this.shutdownNotifier.shutdownIfNecessary();
            if ((line = line.trim()).isEmpty() || (startNode = this.getCFANode(line)) == null) continue;
            try {
                aci = ci.inspectAppliedCustomInstruction(startNode);
            }
            catch (InterruptedException ex) {
                throw new AppliedCustomInstructionParsingFailedException("Parsing failed because of ShutdownNotifier: " + ex.getMessage());
            }
            map.put((Object)startNode, (Object)aci);
        }
        return new CustomInstructionApplications((Map<CFANode, AppliedCustomInstruction>)map.buildOrThrow(), ci);
    }

    protected CFANode getCFANode(String pNodeID) throws AppliedCustomInstructionParsingFailedException {
        try {
            return (CFANode)this.numberToCFANode.get((Object)Integer.parseInt(pNodeID));
        }
        catch (NumberFormatException ex) {
            throw new AppliedCustomInstructionParsingFailedException("It is not possible to parse " + pNodeID + " to an integer!", ex);
        }
    }

    protected ImmutableSet<CFANode> getCFANodes(String[] pNodes) throws AppliedCustomInstructionParsingFailedException {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (String pNode : pNodes) {
            builder.add((Object)this.getCFANode(pNode));
        }
        return builder.build();
    }

    public CustomInstruction readCustomInstruction(String functionName) throws InterruptedException, AppliedCustomInstructionParsingFailedException {
        CFANode pred;
        FunctionEntryNode function = this.cfa.getFunctionHead(functionName);
        if (function == null) {
            throw new AppliedCustomInstructionParsingFailedException("Function unknown in program");
        }
        CFANode ciStartNode = null;
        HashSet<CFANode> ciEndNodes = new HashSet<CFANode>();
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> queue = new ArrayDeque<CFANode>();
        queue.add(function);
        visitedNodes.add(function);
        while (!queue.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            pred = (CFANode)queue.poll();
            if (pred instanceof CFALabelNode && ((CFALabelNode)pred).getLabel().equals("start_ci") && pred.getFunctionName().equals(functionName)) {
                ciStartNode = pred;
                break;
            }
            for (CFANode succ : CFAUtils.allSuccessorsOf(pred)) {
                if (visitedNodes.contains(succ) || !succ.getFunctionName().equals(functionName)) continue;
                queue.add(succ);
                visitedNodes.add(succ);
            }
        }
        if (ciStartNode == null) {
            throw new AppliedCustomInstructionParsingFailedException("Missing label for start of custom instruction");
        }
        ArrayDeque<Pair<CFANode, Set<String>>> pairQueue = new ArrayDeque<Pair<CFANode, Set<String>>>();
        HashSet<String> inputVariables = new HashSet<String>();
        HashSet<String> outputVariables = new HashSet<String>();
        HashSet<String> predOutputVars = new HashSet();
        HashSet<Pair<CFANode, Set<String>>> visitedPairs = new HashSet<Pair<CFANode, Set<String>>>();
        Pair nextNode = Pair.of(ciStartNode, predOutputVars);
        pairQueue.add(nextNode);
        HashSet<FunctionEntryNode> functionsWithoutGlobalVars = new HashSet<FunctionEntryNode>();
        boolean usesMultiEdges = false;
        while (!pairQueue.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            nextNode = (Pair)pairQueue.poll();
            pred = (CFANode)nextNode.getFirst();
            predOutputVars = (Set)nextNode.getSecond();
            if (pred instanceof CFALabelNode && ((CFALabelNode)pred).getLabel().startsWith("end_ci_")) {
                CFAUtils.predecessorsOf(pred).copyInto(ciEndNodes);
                continue;
            }
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(pred)) {
                Pair<CFANode, Set<String>> nextPair;
                if (leavingEdge instanceof FunctionReturnEdge) continue;
                this.addNewInputVariables(leavingEdge, predOutputVars, inputVariables);
                Set<String> succOutputVars = this.getOutputVariablesForSuccessorAndAddNewOutputVariables(leavingEdge, predOutputVars, outputVariables);
                if (leavingEdge instanceof FunctionCallEdge) {
                    if (!this.noGlobalVariablesUsed(functionsWithoutGlobalVars, ((CFunctionCallEdge)leavingEdge).getSuccessor())) {
                        throw new AppliedCustomInstructionParsingFailedException("Function " + leavingEdge.getSuccessor().getFunctionName() + " is not side effect free, uses global variables");
                    }
                    nextPair = Pair.of(((CFunctionCallEdge)leavingEdge).getSummaryEdge().getSuccessor(), succOutputVars);
                } else {
                    nextPair = Pair.of(leavingEdge.getSuccessor(), succOutputVars);
                }
                if (!visitedPairs.add(nextPair)) continue;
                pairQueue.add(nextPair);
            }
        }
        if (usesMultiEdges) {
            this.logger.log(Level.WARNING, new Object[]{"Multi edges used in custom instruction. Results may be unreliable. Disable option cfa.useMultiEdges to get reliable results."});
        }
        if (ciEndNodes.isEmpty()) {
            throw new AppliedCustomInstructionParsingFailedException("Missing label for end of custom instruction");
        }
        ImmutableList outputVariablesAsList = ImmutableList.sortedCopyOf(outputVariables);
        ImmutableList inputVariablesAsList = ImmutableList.sortedCopyOf(inputVariables);
        return new CustomInstruction(ciStartNode, ciEndNodes, (ImmutableList<String>)inputVariablesAsList, (ImmutableList<String>)outputVariablesAsList, this.shutdownNotifier);
    }

    private void addNewInputVariables(CFAEdge pLeavingEdge, Set<String> pPredOutputVars, Set<String> pInputVariables) {
        for (String var : this.getPotentialInputVariables(pLeavingEdge)) {
            if (pPredOutputVars.contains(var)) continue;
            pInputVariables.add(var);
        }
    }

    private Collection<String> getPotentialInputVariables(CFAEdge pLeavingEdge) {
        if (pLeavingEdge instanceof CStatementEdge) {
            CStatement edgeStmt = ((CStatementEdge)pLeavingEdge).getStatement();
            if (edgeStmt instanceof CExpressionAssignmentStatement) {
                return CFAUtils.getVariableNamesOfExpression(((CExpressionAssignmentStatement)edgeStmt).getRightHandSide()).toSet();
            }
            if (edgeStmt instanceof CExpressionStatement) {
                return CFAUtils.getVariableNamesOfExpression(((CExpressionStatement)edgeStmt).getExpression()).toSet();
            }
            if (edgeStmt instanceof CFunctionCallStatement) {
                return this.getFunctionParameterInput(((CFunctionCallStatement)edgeStmt).getFunctionCallExpression());
            }
            if (edgeStmt instanceof CFunctionCallAssignmentStatement) {
                return this.getFunctionParameterInput(((CFunctionCallAssignmentStatement)edgeStmt).getFunctionCallExpression());
            }
        } else if (pLeavingEdge instanceof CDeclarationEdge) {
            CInitializer edgeDecInit;
            CDeclaration edgeDec = ((CDeclarationEdge)pLeavingEdge).getDeclaration();
            if (edgeDec instanceof CVariableDeclaration && (edgeDecInit = ((CVariableDeclaration)edgeDec).getInitializer()) instanceof CInitializerExpression) {
                return CFAUtils.getVariableNamesOfExpression(((CInitializerExpression)edgeDecInit).getExpression()).toSet();
            }
        } else if (pLeavingEdge instanceof CReturnStatementEdge) {
            Optional<CExpression> edgeExp = ((CReturnStatementEdge)pLeavingEdge).getExpression();
            if (edgeExp.isPresent()) {
                return CFAUtils.getVariableNamesOfExpression(edgeExp.orElseThrow()).toSet();
            }
        } else {
            if (pLeavingEdge instanceof CAssumeEdge) {
                return CFAUtils.getVariableNamesOfExpression(((CAssumeEdge)pLeavingEdge).getExpression()).toSet();
            }
            if (pLeavingEdge instanceof CFunctionCallEdge) {
                return FluentIterable.from(((CFunctionCallEdge)pLeavingEdge).getArguments()).transformAndConcat(CFAUtils::getVariableNamesOfExpression).toSet();
            }
        }
        return ImmutableSet.of();
    }

    private Set<String> getFunctionParameterInput(CFunctionCallExpression funCall) {
        return FluentIterable.from(funCall.getParameterExpressions()).transformAndConcat(CFAUtils::getVariableNamesOfExpression).toSet();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getOutputVariablesForSuccessorAndAddNewOutputVariables(CFAEdge pLeavingEdge, Set<String> pPredOutputVars, Set<String> pOutputVariables) {
        void var4_12;
        if (pLeavingEdge instanceof CStatementEdge) {
            CStatement edgeStmt = ((CStatementEdge)pLeavingEdge).getStatement();
            if (edgeStmt instanceof CExpressionAssignmentStatement) {
                ImmutableSet immutableSet = CFAUtils.getVariableNamesOfExpression(((CExpressionAssignmentStatement)edgeStmt).getLeftHandSide()).toSet();
            } else {
                if (!(edgeStmt instanceof CFunctionCallAssignmentStatement)) return pPredOutputVars;
                Set<String> set = this.getFunctionalCallAssignmentOutputVars((CFunctionCallAssignmentStatement)edgeStmt);
            }
        } else if (pLeavingEdge instanceof CDeclarationEdge) {
            ImmutableSet immutableSet = ImmutableSet.of((Object)((CDeclarationEdge)pLeavingEdge).getDeclaration().getQualifiedName());
        } else {
            if (!(pLeavingEdge instanceof CFunctionCallEdge)) return pPredOutputVars;
            CFunctionCall funCall = ((CFunctionCallEdge)pLeavingEdge).getSummaryEdge().getExpression();
            if (funCall instanceof CFunctionCallAssignmentStatement) {
                Set<String> set = this.getFunctionalCallAssignmentOutputVars((CFunctionCallAssignmentStatement)funCall);
            } else {
                ImmutableSet immutableSet = ImmutableSet.of();
            }
        }
        pOutputVariables.addAll((Collection<String>)var4_12);
        HashSet<String> returnRes = new HashSet<String>(pPredOutputVars);
        returnRes.addAll((Collection<String>)var4_12);
        return returnRes;
    }

    private Set<String> getFunctionalCallAssignmentOutputVars(CFunctionCallAssignmentStatement stmt) {
        return CFAUtils.getVariableNamesOfExpression(stmt.getLeftHandSide()).toSet();
    }

    private boolean noGlobalVariablesUsed(Set<FunctionEntryNode> noGlobalVarUse, FunctionEntryNode function) {
        ArrayDeque<CFANode> toVisit = new ArrayDeque<CFANode>();
        HashSet<CFANode> visited = new HashSet<CFANode>();
        toVisit.push(function);
        visited.add(function);
        while (!toVisit.isEmpty()) {
            CFANode visit = (CFANode)toVisit.pop();
            if (visit instanceof FunctionExitNode || visit instanceof FunctionEntryNode && !noGlobalVarUse.add((FunctionEntryNode)visit)) continue;
            for (CFAEdge leave : CFAUtils.allLeavingEdges(visit)) {
                if (this.containsGlobalVars(leave)) {
                    return false;
                }
                CFANode successor = leave.getSuccessor();
                if (!visited.add(successor)) continue;
                toVisit.push(successor);
            }
        }
        return true;
    }

    private boolean containsGlobalVars(CFAEdge pLeave) {
        switch (pLeave.getEdgeType()) {
            case BlankEdge: {
                break;
            }
            case AssumeEdge: {
                return ((CAssumeEdge)pLeave).getExpression().accept(this.visitor);
            }
            case StatementEdge: {
                return this.globalVarInStatement(((CStatementEdge)pLeave).getStatement());
            }
            case DeclarationEdge: {
                CInitializer init;
                if (!(((CDeclarationEdge)pLeave).getDeclaration() instanceof CVariableDeclaration) || (init = ((CVariableDeclaration)((CDeclarationEdge)pLeave).getDeclaration()).getInitializer()) == null) break;
                return init.accept(this.visitor);
            }
            case ReturnStatementEdge: {
                if (!((CReturnStatementEdge)pLeave).getExpression().isPresent()) break;
                return ((CReturnStatementEdge)pLeave).getExpression().orElseThrow().accept(this.visitor);
            }
            case FunctionCallEdge: {
                for (CExpression exp : ((CFunctionCallEdge)pLeave).getArguments()) {
                    if (!exp.accept(this.visitor).booleanValue()) continue;
                    return true;
                }
                break;
            }
            case FunctionReturnEdge: {
                break;
            }
            case CallToReturnEdge: {
                return this.globalVarInStatement(((CFunctionSummaryEdge)pLeave).getExpression());
            }
            default: {
                throw new AssertionError((Object)("Unhandled enum value in switch: " + pLeave.getEdgeType()));
            }
        }
        return false;
    }

    private boolean globalVarInStatement(CStatement statement) {
        block7: {
            block6: {
                if (statement instanceof CExpressionStatement) {
                    return ((CExpressionStatement)statement).getExpression().accept(this.visitor);
                }
                if (!(statement instanceof CFunctionCallStatement)) break block6;
                for (CExpression param : ((CFunctionCallStatement)statement).getFunctionCallExpression().getParameterExpressions()) {
                    if (!param.accept(this.visitor).booleanValue()) continue;
                    return true;
                }
                break block7;
            }
            if (statement instanceof CExpressionAssignmentStatement) {
                if (((CExpressionAssignmentStatement)statement).getLeftHandSide().accept(this.visitor).booleanValue()) {
                    return true;
                }
                return ((CExpressionAssignmentStatement)statement).getRightHandSide().accept(this.visitor);
            }
            if (!(statement instanceof CFunctionCallAssignmentStatement)) break block7;
            if (((CFunctionCallAssignmentStatement)statement).getLeftHandSide().accept(this.visitor).booleanValue()) {
                return true;
            }
            for (CExpression param : ((CFunctionCallAssignmentStatement)statement).getFunctionCallExpression().getParameterExpressions()) {
                if (!param.accept(this.visitor).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAppliedCI(CustomInstruction pCi, CFANode pNode) {
        try {
            return pCi.inspectAppliedCustomInstruction(pNode) != null;
        }
        catch (InterruptedException | AppliedCustomInstructionParsingFailedException e) {
            return false;
        }
    }

    private static class GlobalVarCheckVisitor
    extends DefaultCExpressionVisitor<Boolean, NoException>
    implements CInitializerVisitor<Boolean, NoException>,
    CDesignatorVisitor<Boolean, RuntimeException> {
        private GlobalVarCheckVisitor() {
        }

        @Override
        public Boolean visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            if (!pIastArraySubscriptExpression.getArrayExpression().accept(this).booleanValue()) {
                return pIastArraySubscriptExpression.getSubscriptExpression().accept(this);
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(CFieldReference pIastFieldReference) {
            return pIastFieldReference.getFieldOwner().accept(this);
        }

        @Override
        public Boolean visit(CIdExpression pIastIdExpression) {
            if (pIastIdExpression.getDeclaration().getQualifiedName().equals(pIastIdExpression.getDeclaration().getName())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(CPointerExpression pPointerExpression) {
            return pPointerExpression.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CComplexCastExpression pComplexCastExpression) {
            return pComplexCastExpression.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CBinaryExpression pIastBinaryExpression) {
            if (!pIastBinaryExpression.getOperand1().accept(this).booleanValue()) {
                return pIastBinaryExpression.getOperand2().accept(this);
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(CCastExpression pIastCastExpression) {
            return pIastCastExpression.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CUnaryExpression pIastUnaryExpression) {
            return pIastUnaryExpression.getOperand().accept(this);
        }

        @Override
        protected Boolean visitDefault(CExpression pExp) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(CInitializerExpression pInitializerExpression) {
            return pInitializerExpression.getExpression().accept(this);
        }

        @Override
        public Boolean visit(CInitializerList pInitializerList) {
            for (CInitializer init : pInitializerList.getInitializers()) {
                if (!init.accept(this).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(CDesignatedInitializer pCStructInitializerPart) {
            for (CDesignator des : pCStructInitializerPart.getDesignators()) {
                if (!des.accept(this).booleanValue()) continue;
                return Boolean.TRUE;
            }
            if (pCStructInitializerPart.getRightHandSide() != null) {
                return pCStructInitializerPart.getRightHandSide().accept(this);
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(CArrayDesignator pArrayDesignator) {
            return pArrayDesignator.getSubscriptExpression().accept(this);
        }

        @Override
        public Boolean visit(CArrayRangeDesignator pArrayRangeDesignator) {
            if (pArrayRangeDesignator.getCeilExpression().accept(this).booleanValue()) {
                return Boolean.TRUE;
            }
            return pArrayRangeDesignator.getFloorExpression().accept(this);
        }

        @Override
        public Boolean visit(CFieldDesignator pFieldDesignator) {
            return Boolean.FALSE;
        }
    }
}

