/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParser;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParsingFailedException;
import org.sosy_lab.cpachecker.util.ci.CustomInstruction;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionApplications;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class AppliedCustomInstructionParserTest {
    private CFA cfa;
    private AppliedCustomInstructionParser aciParser;
    private List<CFALabelNode> labelNodes;

    @Before
    public void init() throws ParserException, InterruptedException {
        this.cfa = TestDataTools.makeCFA("extern int test3(int);", "int test(int p) {", "  return p+1;", "}", "int test2(int p) {", "  start_ci: return p+2;", "}", "void ci(int var) {", "  var = var + 39;", "  int globalVar;", "  int u;", "  int x = globalVar + 5;", "  int y;", "  int z;", "  start_ci:", "  if (z>0) {", "    y = y + 1;", "  } else {", "    var = var + 1;", "  }", "  test(u);", "  z = test(globalVar);", "  end_ci_1: x = x + 1;", "}", "void main() {", "  int m;", "  int n;", "  int o;", "  start_ci:", "  if (m>o) {", "    ci(m);", "  }", "  test3(n);", "  n = test3(o);", "  end_ci_2:", "  test2(4);", "}");
        this.aciParser = new AppliedCustomInstructionParser(ShutdownNotifier.createDummy(), LogManager.createTestLogManager(), this.cfa);
        GlobalInfo.getInstance().storeCFA(this.cfa);
        this.labelNodes = this.getLabelNodes(this.cfa);
    }

    @Test
    public void testGetCFANode() throws AppliedCustomInstructionParsingFailedException {
        try {
            this.aciParser.getCFANode("N57");
            Truth.assert_().fail();
        }
        catch (CPAException e) {
            Truth.assertThat((Throwable)e).isInstanceOf(AppliedCustomInstructionParsingFailedException.class);
        }
        Truth.assertThat((Comparable)this.aciParser.getCFANode("-1")).isNull();
        Truth.assertThat((Comparable)this.aciParser.getCFANode("" + this.cfa.getFunctionHead("main").getNodeNumber())).isEqualTo((Object)this.cfa.getMainFunction());
    }

    @Test
    public void testReadCustomInstruction() throws Exception {
        try {
            this.aciParser.readCustomInstruction("test4");
            Truth.assert_().fail();
        }
        catch (CPAException e) {
            Truth.assertThat((Throwable)e).isInstanceOf(AppliedCustomInstructionParsingFailedException.class);
            Truth.assertThat((String)e.getMessage()).matches("Function unknown in program");
        }
        try {
            this.aciParser.readCustomInstruction("test");
            Truth.assert_().fail();
        }
        catch (CPAException e) {
            Truth.assertThat((Throwable)e).isInstanceOf(AppliedCustomInstructionParsingFailedException.class);
            Truth.assertThat((String)e.getMessage()).matches("Missing label for start of custom instruction");
        }
        try {
            this.aciParser.readCustomInstruction("test2");
            Truth.assert_().fail();
        }
        catch (CPAException e) {
            Truth.assertThat((Throwable)e).isInstanceOf(AppliedCustomInstructionParsingFailedException.class);
            Truth.assertThat((String)e.getMessage()).matches("Missing label for end of custom instruction");
        }
        CustomInstruction ci = this.aciParser.readCustomInstruction("ci");
        CFALabelNode expectedStart = null;
        ArrayList expectedEnds = new ArrayList(2);
        for (CFALabelNode n : this.labelNodes) {
            if (n.getLabel().startsWith("start_ci") && n.getFunctionName().equals("ci")) {
                expectedStart = n;
            }
            if (!n.getLabel().startsWith("end_ci") || !n.getFunctionName().equals("ci")) continue;
            CFAUtils.predecessorsOf(n).copyInto(expectedEnds);
        }
        Truth.assertThat((Comparable)ci.getStartNode()).isEqualTo(expectedStart);
        Truth.assertThat(ci.getEndNodes()).containsExactlyElementsIn(expectedEnds);
        ArrayList<String> list = new ArrayList<String>();
        list.add("ci::globalVar");
        list.add("ci::u");
        list.add("ci::var");
        list.add("ci::y");
        list.add("ci::z");
        Truth.assertThat(ci.getInputVariables()).containsExactlyElementsIn(list).inOrder();
        list = new ArrayList();
        list.add("ci::var");
        list.add("ci::y");
        list.add("ci::z");
        Truth.assertThat(ci.getOutputVariables()).containsExactlyElementsIn(list).inOrder();
        ci = this.aciParser.readCustomInstruction("main");
        expectedStart = null;
        expectedEnds = new ArrayList(1);
        for (CFALabelNode n : this.labelNodes) {
            if (n.getLabel().startsWith("start_ci") && n.getFunctionName().equals("main")) {
                expectedStart = n;
            }
            if (!n.getLabel().startsWith("end_ci") || !n.getFunctionName().equals("main")) continue;
            CFAUtils.predecessorsOf(n).copyInto(expectedEnds);
        }
        Truth.assertThat((Comparable)ci.getStartNode()).isEqualTo((Object)expectedStart);
        Truth.assertThat(ci.getEndNodes()).containsExactlyElementsIn(expectedEnds);
        list = new ArrayList();
        list.add("main::m");
        list.add("main::n");
        list.add("main::o");
        Truth.assertThat(ci.getInputVariables()).containsExactlyElementsIn(list).inOrder();
        list = new ArrayList();
        list.add("main::n");
        Truth.assertThat(ci.getOutputVariables()).containsExactlyElementsIn(list).inOrder();
    }

    private List<CFALabelNode> getLabelNodes(CFA pCfa) {
        ArrayList<CFALabelNode> result = new ArrayList<CFALabelNode>();
        for (CFANode n : pCfa.getAllNodes()) {
            if (!(n instanceof CFALabelNode)) continue;
            result.add((CFALabelNode)n);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParse() throws Exception {
        this.cfa = TestDataTools.makeCFA("void main() {", "  int x;", "  int y;", "  start_ci: x = x + y;", "  end_ci_1:", "  x = x + x;", "  y = y + y;", "  y = y + x;", "}");
        GlobalInfo.getInstance().storeCFA(this.cfa);
        this.aciParser = new AppliedCustomInstructionParser(ShutdownNotifier.createDummy(), LogManager.createTestLogManager(), this.cfa);
        Path p = TempFile.builder().prefix("test_acis").create();
        try (Writer file = IO.openOutputFile((Path)p, (Charset)StandardCharsets.US_ASCII, (OpenOption[])new OpenOption[0]);){
            file.append("main\n");
            ArrayDeque<CFANode> toVisit = new ArrayDeque<CFANode>();
            toVisit.add(this.cfa.getMainFunction());
            while (!toVisit.isEmpty()) {
                CFANode node = (CFANode)toVisit.pop();
                for (CFANode succ : CFAUtils.allSuccessorsOf(node)) {
                    toVisit.add(succ);
                    if (!node.getEdgeTo(succ).getEdgeType().equals((Object)CFAEdgeType.StatementEdge)) continue;
                    file.append(node.getNodeNumber() + "\n");
                }
            }
            file.flush();
        }
        Path signatureFile = TempFile.builder().prefix("ci_spec").suffix(".txt").create();
        try {
            this.testParse(p, signatureFile);
        }
        finally {
            try {
                Files.deleteIfExists(p);
                Files.deleteIfExists(signatureFile);
            }
            catch (IOException iOException) {}
        }
    }

    private void testParse(Path p, Path signatureFile) throws Exception {
        CFANode expectedStart = this.getLabelNodes(this.cfa).stream().filter(n -> n.getLabel().startsWith("start_ci") && n.getFunctionName().equals("main")).findAny().orElseThrow();
        int startNodeNr = expectedStart.getNodeNumber();
        CustomInstructionApplications cia = this.aciParser.parse(p, signatureFile);
        Map<CFANode, AppliedCustomInstruction> cis = cia.getMapping();
        Truth.assertThat((Integer)cis.size()).isEqualTo((Object)4);
        ArrayList<CFANode> aciNodes = new ArrayList<CFANode>(2);
        for (Map.Entry<CFANode, AppliedCustomInstruction> entry : cis.entrySet()) {
            SSAMap ssaMap;
            Pair<List<String>, String> fakeSMTDescription;
            ArrayList<String> inputVars = new ArrayList<String>();
            ArrayList<String> outputVars = new ArrayList<String>();
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> variables = new ArrayList<String>();
            aciNodes.clear();
            aciNodes.add(entry.getKey());
            aciNodes.add(entry.getKey().getLeavingEdge(0).getSuccessor());
            if (entry.getKey().getNodeNumber() == startNodeNr) {
                inputVars.add("main::x");
                inputVars.add("main::y");
                Truth.assertThat(entry.getValue().getInputVariables()).containsExactlyElementsIn(inputVars);
                outputVars.add("main::x");
                Truth.assertThat(entry.getValue().getOutputVariables()).containsExactlyElementsIn(outputVars);
                fakeSMTDescription = entry.getValue().getFakeSMTDescription();
                list.add("(declare-fun |main::x| () Int)");
                list.add("(declare-fun |main::y| () Int)");
                list.add("(declare-fun |main::x@1| () Int)");
                Truth.assertThat((Iterable)fakeSMTDescription.getFirst()).containsExactlyElementsIn(list);
                Truth.assertThat((String)fakeSMTDescription.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(and (= |main::x| 0)(and (= |main::y| 0) (= |main::x@1| 0))))");
                ssaMap = entry.getValue().getIndicesForReturnVars();
                variables.add("main::x");
                Truth.assertThat(ssaMap.allVariables()).containsExactlyElementsIn(variables);
                Truth.assertThat((Integer)ssaMap.getIndex((String)variables.get(0))).isEqualTo((Object)1);
                Truth.assertThat(entry.getValue().getStartAndEndNodes()).containsExactlyElementsIn(aciNodes);
                continue;
            }
            if (entry.getKey().getNodeNumber() == startNodeNr + 2) {
                inputVars.add("main::x");
                inputVars.add("main::x");
                Truth.assertThat(entry.getValue().getInputVariables()).containsExactlyElementsIn(inputVars);
                outputVars.add("main::x");
                Truth.assertThat(entry.getValue().getOutputVariables()).containsExactlyElementsIn(outputVars);
                fakeSMTDescription = entry.getValue().getFakeSMTDescription();
                list.clear();
                list.add("(declare-fun |main::x| () Int)");
                list.add("(declare-fun |main::x| () Int)");
                list.add("(declare-fun |main::x@1| () Int)");
                Truth.assertThat((Iterable)fakeSMTDescription.getFirst()).containsExactlyElementsIn(list);
                Truth.assertThat((String)fakeSMTDescription.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(and (= |main::x| 0)(and (= |main::x| 0) (= |main::x@1| 0))))");
                ssaMap = entry.getValue().getIndicesForReturnVars();
                variables.add("main::x");
                Truth.assertThat(ssaMap.allVariables()).containsExactlyElementsIn(variables);
                Truth.assertThat((Integer)ssaMap.getIndex((String)variables.get(0))).isEqualTo((Object)1);
                Truth.assertThat(entry.getValue().getStartAndEndNodes()).containsExactlyElementsIn(aciNodes);
                continue;
            }
            if (entry.getKey().getNodeNumber() == startNodeNr + 3) {
                inputVars.add("main::y");
                inputVars.add("main::y");
                Truth.assertThat(entry.getValue().getInputVariables()).containsExactlyElementsIn(inputVars);
                outputVars.add("main::y");
                Truth.assertThat(entry.getValue().getOutputVariables()).containsExactlyElementsIn(outputVars);
                fakeSMTDescription = entry.getValue().getFakeSMTDescription();
                list.clear();
                list.add("(declare-fun |main::y| () Int)");
                list.add("(declare-fun |main::y| () Int)");
                list.add("(declare-fun |main::y@1| () Int)");
                Truth.assertThat((Iterable)fakeSMTDescription.getFirst()).containsExactlyElementsIn(list);
                Truth.assertThat((String)fakeSMTDescription.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(and (= |main::y| 0)(and (= |main::y| 0) (= |main::y@1| 0))))");
                ssaMap = entry.getValue().getIndicesForReturnVars();
                variables.add("main::y");
                Truth.assertThat(ssaMap.allVariables()).containsExactlyElementsIn(variables);
                Truth.assertThat((Integer)ssaMap.getIndex((String)variables.get(0))).isEqualTo((Object)1);
                Truth.assertThat(entry.getValue().getStartAndEndNodes()).containsExactlyElementsIn(aciNodes);
                continue;
            }
            if (entry.getKey().getNodeNumber() == startNodeNr + 4) {
                inputVars.add("main::y");
                inputVars.add("main::x");
                Truth.assertThat(entry.getValue().getInputVariables()).containsExactlyElementsIn(inputVars);
                outputVars.add("main::y");
                Truth.assertThat(entry.getValue().getOutputVariables()).containsExactlyElementsIn(outputVars);
                fakeSMTDescription = entry.getValue().getFakeSMTDescription();
                list.clear();
                list.add("(declare-fun |main::y| () Int)");
                list.add("(declare-fun |main::x| () Int)");
                list.add("(declare-fun |main::y@1| () Int)");
                Truth.assertThat((Iterable)fakeSMTDescription.getFirst()).containsExactlyElementsIn(list);
                Truth.assertThat((String)fakeSMTDescription.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(and (= |main::y| 0)(and (= |main::x| 0) (= |main::y@1| 0))))");
                ssaMap = entry.getValue().getIndicesForReturnVars();
                variables.add("main::y");
                Truth.assertThat(ssaMap.allVariables()).containsExactlyElementsIn(variables);
                Truth.assertThat((Integer)ssaMap.getIndex((String)variables.get(0))).isEqualTo((Object)1);
                Truth.assertThat(entry.getValue().getStartAndEndNodes()).containsExactlyElementsIn(aciNodes);
                continue;
            }
            Truth.assert_().fail();
        }
    }
}

