/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParsingFailedException;
import org.sosy_lab.cpachecker.util.ci.CIUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class CustomInstruction {
    private final CFANode ciStartNode;
    private final Set<CFANode> ciEndNodes;
    private final ImmutableList<String> inputVariables;
    private final ImmutableList<String> outputVariables;
    private final ShutdownNotifier shutdownNotifier;

    public int hashCode() {
        return Objects.hash(this.ciEndNodes, this.ciStartNode, this.inputVariables, this.outputVariables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomInstruction)) {
            return false;
        }
        CustomInstruction other = (CustomInstruction)obj;
        return Objects.equals(this.ciEndNodes, other.ciEndNodes) && Objects.equals(this.ciStartNode, other.ciStartNode) && Objects.equals(this.inputVariables, other.inputVariables) && Objects.equals(this.outputVariables, other.outputVariables);
    }

    public CustomInstruction(CFANode pCIStartNode, Set<CFANode> pCIEndNodes, ImmutableList<String> pInputVariables, ImmutableList<String> pOutputVariables, ShutdownNotifier pShutdownNotifier) {
        this.ciStartNode = pCIStartNode;
        this.ciEndNodes = pCIEndNodes;
        this.inputVariables = pInputVariables;
        this.outputVariables = pOutputVariables;
        this.shutdownNotifier = pShutdownNotifier;
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (!this.inputVariables.isEmpty()) {
            Joiner.on((String)", ").appendTo(sb, Iterables.transform(this.inputVariables, CIUtils::getSMTName));
        }
        sb.append(") -> (");
        if (!this.outputVariables.isEmpty()) {
            Joiner.on((String)", ").appendTo(sb, Iterables.transform(this.outputVariables, CIUtils::getSMTNameWithIndex));
        }
        sb.append(")");
        return sb.toString();
    }

    public Pair<List<String>, String> getFakeSMTDescription() {
        String last;
        if (this.inputVariables.isEmpty() && this.outputVariables.isEmpty()) {
            return Pair.of(ImmutableList.of(), "(define-fun ci() Bool true)");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(define-fun ci() Bool");
        int BracketCounter = 0;
        if (!this.inputVariables.isEmpty()) {
            last = (String)this.inputVariables.get(this.inputVariables.size() - 1);
            for (String variable : this.inputVariables) {
                if (this.outputVariables.isEmpty() && variable.equals(last)) {
                    sb.append(this.getAssignmentOfVariableToZero(variable, false));
                    continue;
                }
                sb.append("(and ");
                sb.append(this.getAssignmentOfVariableToZero(variable, false));
                ++BracketCounter;
            }
        }
        if (!this.outputVariables.isEmpty()) {
            last = (String)this.outputVariables.get(this.outputVariables.size() - 1);
            for (String variable : this.outputVariables) {
                if (variable.equals(last)) {
                    sb.append(" ");
                    sb.append(this.getAssignmentOfVariableToZero(variable, true));
                    continue;
                }
                sb.append("(and ");
                sb.append(this.getAssignmentOfVariableToZero(variable, true));
                ++BracketCounter;
            }
        }
        for (int i = 0; i < BracketCounter + 1; ++i) {
            sb.append(")");
        }
        ArrayList<CallSite> outputVariableList = new ArrayList<CallSite>();
        for (String var : this.inputVariables) {
            try {
                Integer.parseInt(var);
            }
            catch (NumberFormatException e) {
                outputVariableList.add((CallSite)((Object)("(declare-fun " + CIUtils.getSMTName(var) + " () Int)")));
            }
        }
        for (String var : this.outputVariables) {
            outputVariableList.add((CallSite)((Object)("(declare-fun " + CIUtils.getSMTName(var + "@1") + " () Int)")));
        }
        return Pair.of(outputVariableList, sb.toString());
    }

    private String getAssignmentOfVariableToZero(String var, boolean isOutputVariable) {
        StringBuilder sb = new StringBuilder();
        boolean isNumber = false;
        try {
            Integer.parseInt(var);
            isNumber = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        sb.append("(= ");
        if (!isNumber) {
            if (isOutputVariable) {
                sb.append(CIUtils.getSMTName(var + "@1"));
            } else {
                sb.append(CIUtils.getSMTName(var));
            }
        } else {
            sb.append(var);
        }
        sb.append(" 0)");
        return sb.toString();
    }

    public AppliedCustomInstruction inspectAppliedCustomInstruction(CFANode aciStartNode) throws InterruptedException, AppliedCustomInstructionParsingFailedException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        HashSet<String> outVariables = new HashSet<String>();
        HashSet<CFANode> aciEndNodes = new HashSet<CFANode>();
        HashSet<Pair<CFANode, CFANode>> visitedNodes = new HashSet<Pair<CFANode, CFANode>>();
        ArrayDeque<Pair<CFANode, CFANode>> queue = new ArrayDeque<Pair<CFANode, CFANode>>();
        visitedNodes.add(Pair.of(this.ciStartNode, aciStartNode));
        queue.add(Pair.of(this.ciStartNode, aciStartNode));
        while (!queue.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            Pair nextPair = (Pair)queue.poll();
            CFANode ciPred = (CFANode)nextPair.getFirst();
            CFANode aciPred = (CFANode)nextPair.getSecond();
            if (this.ciEndNodes.contains(ciPred)) {
                aciEndNodes.add(aciPred);
                continue;
            }
            if (aciPred.getNumLeavingEdges() != ciPred.getNumLeavingEdges()) {
                throw new AppliedCustomInstructionParsingFailedException("Structure mismatch");
            }
            for (int i = 0; i < ciPred.getNumLeavingEdges(); ++i) {
                Pair<CFANode, CFANode> next;
                this.shutdownNotifier.shutdownIfNecessary();
                CFAEdge ciEdge = ciPred.getLeavingEdge(i);
                CFANode ciSucc = ciEdge.getSuccessor();
                CFAEdge aciEdge = aciPred.getLeavingEdge(i);
                CFANode aciSucc = aciEdge.getSuccessor();
                this.computeMappingOfCiAndAci(ciEdge, aciEdge, mapping, outVariables);
                if (ciEdge instanceof FunctionCallEdge) {
                    this.computeMappingOfCiAndAci(((FunctionCallEdge)ciEdge).getSummaryEdge(), ((FunctionCallEdge)aciEdge).getSummaryEdge(), mapping, outVariables);
                    next = Pair.of(((FunctionCallEdge)ciEdge).getSummaryEdge().getSuccessor(), ((FunctionCallEdge)aciEdge).getSummaryEdge().getSuccessor());
                } else {
                    next = Pair.of(ciSucc, aciSucc);
                }
                if (visitedNodes.contains(next)) continue;
                queue.add(next);
                visitedNodes.add(next);
            }
        }
        if (this.ciEndNodes.size() != aciEndNodes.size()) {
            throw new AppliedCustomInstructionParsingFailedException("The amout of endNodes of ci and aci are different!");
        }
        SSAMap.SSAMapBuilder ssaMapBuilder = SSAMap.emptySSAMap().builder();
        for (String var : outVariables) {
            ssaMapBuilder.setIndex(var, CNumericTypes.INT, 1);
        }
        List<String> inVars = this.getVariablesOrdered((Map<String, String>)mapping, (List<String>)this.inputVariables);
        List<String> outVars = this.getVariablesOrdered((Map<String, String>)mapping, (List<String>)this.outputVariables);
        ArrayList<String> inVarsConst = new ArrayList<String>(this.inputVariables.size());
        for (String ciVar : this.inputVariables) {
            inVarsConst.add((String)mapping.get(ciVar));
        }
        return new AppliedCustomInstruction(aciStartNode, aciEndNodes, inVars, outVars, inVarsConst, this.getFakeSMTDescriptionForACI(mapping), ssaMapBuilder.build());
    }

    private List<String> getVariablesOrdered(Map<String, String> pMapping, List<String> pVariables) {
        ArrayList<String> result = new ArrayList<String>(pVariables.size());
        for (String ciVar : pVariables) {
            assert (pMapping.containsKey(ciVar));
            String aciVar = pMapping.get(ciVar);
            try {
                Integer.parseInt(aciVar);
            }
            catch (NumberFormatException ex) {
                result.add(aciVar);
            }
        }
        return result;
    }

    private Pair<List<String>, String> getFakeSMTDescriptionForACI(Map<String, String> map) {
        String last;
        if (this.inputVariables.isEmpty() && this.outputVariables.isEmpty()) {
            return Pair.of(ImmutableList.of(), "(define-fun ci() Bool true)");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(define-fun ci() Bool");
        int BracketCounter = 0;
        if (!this.inputVariables.isEmpty()) {
            last = (String)this.inputVariables.get(this.inputVariables.size() - 1);
            for (String variable : this.inputVariables) {
                if (this.outputVariables.isEmpty() && variable.equals(last)) {
                    sb.append(this.getAssignmentOfVariableToZero(map.get(variable), false));
                    continue;
                }
                sb.append("(and ");
                sb.append(this.getAssignmentOfVariableToZero(map.get(variable), false));
                ++BracketCounter;
            }
        }
        if (!this.outputVariables.isEmpty()) {
            last = (String)this.outputVariables.get(this.outputVariables.size() - 1);
            for (String variable : this.outputVariables) {
                if (variable.equals(last)) {
                    sb.append(" ");
                    sb.append(this.getAssignmentOfVariableToZero(map.get(variable), true));
                    continue;
                }
                sb.append("(and ");
                sb.append(this.getAssignmentOfVariableToZero(map.get(variable), true));
                ++BracketCounter;
            }
        }
        for (int i = 0; i < BracketCounter + 1; ++i) {
            sb.append(")");
        }
        ArrayList<CallSite> outputVariableList = new ArrayList<CallSite>();
        for (String var : this.inputVariables) {
            try {
                Integer.parseInt(map.get(var));
            }
            catch (NumberFormatException e) {
                outputVariableList.add((CallSite)((Object)("(declare-fun " + CIUtils.getSMTName(map.get(var)) + " () Int)")));
            }
        }
        for (String var : this.outputVariables) {
            outputVariableList.add((CallSite)((Object)("(declare-fun " + CIUtils.getSMTName(map.get(var) + "@1") + " () Int)")));
        }
        return Pair.of(outputVariableList, sb.toString());
    }

    private void computeMappingOfCiAndAci(CFAEdge ciEdge, CFAEdge aciEdge, Map<String, String> ciVarToAciVar, Collection<String> outVariables) throws AppliedCustomInstructionParsingFailedException {
        if (ciEdge.getEdgeType() != aciEdge.getEdgeType()) {
            throw new AppliedCustomInstructionParsingFailedException("The edgeType of " + ciEdge + " and " + aciEdge + " are different.");
        }
        switch (ciEdge.getEdgeType()) {
            case BlankEdge: {
                return;
            }
            case AssumeEdge: {
                this.compareAssumeEdge((CAssumeEdge)ciEdge, (CAssumeEdge)aciEdge, ciVarToAciVar);
                return;
            }
            case StatementEdge: {
                this.compareStatementEdge((CStatementEdge)ciEdge, (CStatementEdge)aciEdge, ciVarToAciVar, outVariables);
                return;
            }
            case DeclarationEdge: {
                this.compareDeclarationEdge((CDeclarationEdge)ciEdge, (CDeclarationEdge)aciEdge, ciVarToAciVar, outVariables);
                return;
            }
            case ReturnStatementEdge: {
                this.compareReturnStatementEdge((CReturnStatementEdge)ciEdge, (CReturnStatementEdge)aciEdge, ciVarToAciVar);
                return;
            }
            case FunctionCallEdge: {
                this.compareFunctionCallEdge((CFunctionCallEdge)ciEdge, (CFunctionCallEdge)aciEdge, ciVarToAciVar);
                return;
            }
            case FunctionReturnEdge: {
                return;
            }
            case CallToReturnEdge: {
                this.compareStatementsOfStatementEdge(((CFunctionSummaryEdge)ciEdge).getExpression(), ((CFunctionSummaryEdge)aciEdge).getExpression(), ciVarToAciVar, outVariables);
                return;
            }
        }
        throw new AssertionError((Object)("Unhandeled enum value in switch: " + ciEdge.getEdgeType()));
    }

    private void compareAssumeEdge(CAssumeEdge ciEdge, CAssumeEdge aciEdge, Map<String, String> ciVarToAciVar) throws AppliedCustomInstructionParsingFailedException {
        if (ciEdge.getTruthAssumption() != aciEdge.getTruthAssumption()) {
            throw new AppliedCustomInstructionParsingFailedException("The truthAssumption of the CAssumeEdges " + ciEdge + " and " + aciEdge + "are different!");
        }
        ciEdge.getExpression().accept(new StructureComparisonVisitor(aciEdge.getExpression(), ciVarToAciVar));
    }

    private void compareStatementEdge(CStatementEdge ciEdge, CStatementEdge aciEdge, Map<String, String> ciVarToAciVar, Collection<String> outVariables) throws AppliedCustomInstructionParsingFailedException {
        if (ciEdge.getStatement() instanceof CFunctionSummaryStatementEdge && aciEdge.getStatement() instanceof CFunctionSummaryStatementEdge) {
            CFunctionSummaryStatementEdge ciStmt = (CFunctionSummaryStatementEdge)((Object)ciEdge.getStatement());
            CFunctionSummaryStatementEdge aciStmt = (CFunctionSummaryStatementEdge)((Object)aciEdge.getStatement());
            if (!ciStmt.getFunctionName().equals(aciStmt.getFunctionName())) {
                throw new AppliedCustomInstructionParsingFailedException("The functionName of the CFunctionSummaryStatementEdges " + ciEdge + " and " + aciEdge + " are different!");
            }
            this.compareStatementsOfStatementEdge(ciStmt.getFunctionCall(), aciStmt.getFunctionCall(), ciVarToAciVar, outVariables);
        }
        this.compareStatementsOfStatementEdge(ciEdge.getStatement(), aciEdge.getStatement(), ciVarToAciVar, outVariables);
    }

    private void compareStatementsOfStatementEdge(CStatement ci, CStatement aci, Map<String, String> ciVarToAciVar, Collection<String> outVariables) throws AppliedCustomInstructionParsingFailedException {
        if (ci instanceof CExpressionAssignmentStatement && aci instanceof CExpressionAssignmentStatement) {
            CExpressionAssignmentStatement ciStmt = (CExpressionAssignmentStatement)ci;
            CExpressionAssignmentStatement aciStmt = (CExpressionAssignmentStatement)aci;
            HashMap<String, String> currentCiVarToAciVar = new HashMap<String, String>();
            ciStmt.getLeftHandSide().accept(new StructureExtendedComparisonVisitor(aciStmt.getLeftHandSide(), ciVarToAciVar, currentCiVarToAciVar));
            outVariables.addAll(currentCiVarToAciVar.values());
            ciStmt.getRightHandSide().accept(new StructureExtendedComparisonVisitor(aciStmt.getRightHandSide(), ciVarToAciVar, currentCiVarToAciVar));
        } else if (ci instanceof CExpressionStatement && aci instanceof CExpressionStatement) {
            CExpressionStatement ciStmt = (CExpressionStatement)ci;
            CExpressionStatement aciStmt = (CExpressionStatement)aci;
            ciStmt.getExpression().accept(new StructureComparisonVisitor(aciStmt.getExpression(), ciVarToAciVar));
        } else if (ci instanceof CFunctionCallAssignmentStatement && aci instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement ciStmt = (CFunctionCallAssignmentStatement)ci;
            CFunctionCallAssignmentStatement aciStmt = (CFunctionCallAssignmentStatement)aci;
            HashMap<String, String> currentCiVarToAciVar = new HashMap<String, String>();
            ciStmt.getLeftHandSide().accept(new StructureExtendedComparisonVisitor(aciStmt.getLeftHandSide(), ciVarToAciVar, currentCiVarToAciVar));
            outVariables.addAll(currentCiVarToAciVar.values());
            this.compareFunctionCallExpressions(ciStmt.getFunctionCallExpression(), aciStmt.getFunctionCallExpression(), ciVarToAciVar);
        } else if (ci instanceof CFunctionCallStatement && aci instanceof CFunctionCallStatement) {
            CFunctionCallStatement ciStmt = (CFunctionCallStatement)ci;
            CFunctionCallStatement aciStmt = (CFunctionCallStatement)aci;
            this.compareFunctionCallExpressions(ciStmt.getFunctionCallExpression(), aciStmt.getFunctionCallExpression(), ciVarToAciVar);
        } else {
            throw new AppliedCustomInstructionParsingFailedException("The types of the CStatement " + ci + " and " + aci + " are different!");
        }
    }

    private void compareFunctionCallExpressions(CFunctionCallExpression exp, CFunctionCallExpression aexp, Map<String, String> ciVarToAciVar) throws AppliedCustomInstructionParsingFailedException {
        if (!exp.getExpressionType().equals(aexp.getExpressionType())) {
            throw new AppliedCustomInstructionParsingFailedException("The expressionType of the CStatementEdges " + exp + " and " + aexp + " are different!");
        }
        exp.getFunctionNameExpression().accept(new StructureComparisonVisitor(aexp.getFunctionNameExpression(), new HashMap<String, String>()));
        List<CExpression> ciList = exp.getParameterExpressions();
        List<CExpression> aciList = aexp.getParameterExpressions();
        for (int i = 0; i < ciList.size(); ++i) {
            ciList.get(i).accept(new StructureComparisonVisitor(aciList.get(i), ciVarToAciVar));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compareDeclarationEdge(CDeclarationEdge ciEdge, CDeclarationEdge aciEdge, Map<String, String> ciVarToAciVar, Collection<String> outVariables) throws AppliedCustomInstructionParsingFailedException {
        CVariableDeclaration aciVarDec;
        CVariableDeclaration ciVarDec;
        CDeclaration ciDec = ciEdge.getDeclaration();
        CDeclaration aciDec = aciEdge.getDeclaration();
        if (ciDec instanceof CVariableDeclaration && aciDec instanceof CVariableDeclaration) {
            ciVarDec = (CVariableDeclaration)ciDec;
            aciVarDec = (CVariableDeclaration)aciDec;
            if (!ciVarDec.getCStorageClass().equals((Object)aciVarDec.getCStorageClass())) {
                throw new AppliedCustomInstructionParsingFailedException("The CVariableDeclaration of ci " + ciVarDec + " and aci " + aciVarDec + " have different StorageClasses.");
            }
            if (!ciVarDec.getType().equals(aciVarDec.getType())) {
                throw new AppliedCustomInstructionParsingFailedException("The CVariableDeclaration of ci " + ciVarDec + " and aci " + aciVarDec + " have different declaration types!");
            }
            if (ciVarToAciVar.containsKey(ciVarDec.getQualifiedName()) && !ciVarToAciVar.get(ciVarDec.getQualifiedName()).equals(aciVarDec.getQualifiedName())) {
                throw new AppliedCustomInstructionParsingFailedException("The mapping is not clear. The map contains " + ciVarDec.getQualifiedName() + " with the value " + ciVarToAciVar.get(ciVarDec.getQualifiedName()) + ", which is different to " + aciVarDec.getQualifiedName() + ".");
            }
            this.compareInitializer(ciVarDec.getInitializer(), aciVarDec.getInitializer(), ciVarToAciVar, outVariables);
            if (ciVarDec.getInitializer() != null) {
                if (!(ciVarDec.getInitializer() instanceof CInitializerExpression) && !(ciVarDec.getInitializer() instanceof CInitializerList)) throw new AppliedCustomInstructionParsingFailedException("Unsupported initializer: " + ciVarDec.getInitializer());
                outVariables.add(aciVarDec.getQualifiedName());
            }
        } else {
            if (ciDec instanceof CComplexTypeDeclaration && aciDec instanceof CComplexTypeDeclaration) {
                throw new AppliedCustomInstructionParsingFailedException("The code contains a CComplexTypeDeclaration, which is unsupported.");
            }
            if (ciDec instanceof CTypeDefDeclaration && aciDec instanceof CTypeDefDeclaration) {
                throw new AppliedCustomInstructionParsingFailedException("The code contains a CTypeDefDeclaration, which is unsupported.");
            }
            if (!(ciDec instanceof CFunctionDeclaration) || !(aciDec instanceof CFunctionDeclaration)) throw new AppliedCustomInstructionParsingFailedException("The declaration of the CDeclarationEdge ci " + ciDec + " and aci " + aciDec + " have different classes.");
            throw new AppliedCustomInstructionParsingFailedException("The code contains a CFunctionDeclaration, which is unsupported.");
        }
        ciVarToAciVar.put(ciVarDec.getQualifiedName(), aciVarDec.getQualifiedName());
    }

    private void compareInitializer(CInitializer ciI, CInitializer aciI, Map<String, String> ciVarToAciVar, Collection<String> outVariables) throws AppliedCustomInstructionParsingFailedException {
        if (ciI != null || aciI != null) {
            if (ciI == null && aciI != null) {
                throw new AppliedCustomInstructionParsingFailedException("The aci has an initializer but not the ci.");
            }
            if (ciI != null && aciI == null) {
                throw new AppliedCustomInstructionParsingFailedException("The ci has an initializer but not the aci.");
            }
            if (ciI instanceof CInitializerExpression && aciI instanceof CInitializerExpression) {
                ((CInitializerExpression)ciI).getExpression().accept(new StructureComparisonVisitor(((CInitializerExpression)aciI).getExpression(), ciVarToAciVar));
            } else {
                if (ciI instanceof CDesignatedInitializer && aciI instanceof CDesignatedInitializer) {
                    throw new AppliedCustomInstructionParsingFailedException("The code contains a CDesignatedInitializer, which is unsupported.");
                }
                if (ciI instanceof CInitializerList && aciI instanceof CInitializerList) {
                    List<CInitializer> ciList = ((CInitializerList)ciI).getInitializers();
                    List<CInitializer> aciList = ((CInitializerList)aciI).getInitializers();
                    if (ciList.size() != aciList.size()) {
                        throw new AppliedCustomInstructionParsingFailedException("The CInitializerList of the Initializer of ci " + ciI + " and aci " + aciI + " have different length.");
                    }
                    for (int i = 0; i < ciList.size(); ++i) {
                        this.compareInitializer(ciList.get(i), aciList.get(i), ciVarToAciVar, outVariables);
                    }
                } else {
                    throw new AppliedCustomInstructionParsingFailedException("The CInitializer of ci " + ciI + " and aci " + aciI + " are different.");
                }
            }
        }
    }

    private void compareReturnStatementEdge(CReturnStatementEdge ciEdge, CReturnStatementEdge aciEdge, Map<String, String> ciVarToAciVar) throws AppliedCustomInstructionParsingFailedException {
        if (ciEdge.getExpression().isPresent() && aciEdge.getExpression().isPresent()) {
            ciEdge.getExpression().orElseThrow().accept(new StructureComparisonVisitor(aciEdge.getExpression().orElseThrow(), ciVarToAciVar));
        } else if (!ciEdge.getExpression().isPresent() && aciEdge.getExpression().isPresent() || ciEdge.getExpression().isPresent() && !aciEdge.getExpression().isPresent()) {
            throw new AppliedCustomInstructionParsingFailedException("The expression of the CReturnStatementEdge of ci " + ciEdge + " and aci " + aciEdge + " is present in one of them, but not in the otherone.");
        }
    }

    private void compareFunctionCallEdge(CFunctionCallEdge ciEdge, CFunctionCallEdge aciEdge, Map<String, String> ciVarToAciVar) throws AppliedCustomInstructionParsingFailedException {
        if (!Objects.equals(ciEdge.getSuccessor(), aciEdge.getSuccessor())) {
            throw new AppliedCustomInstructionParsingFailedException("Applied custom instruction calls different method than custom instruction.");
        }
        List<CExpression> ciArguments = ciEdge.getArguments();
        List<CExpression> aciArguments = aciEdge.getArguments();
        if (ciArguments.size() != aciArguments.size()) {
            throw new AppliedCustomInstructionParsingFailedException("The amount of arguments of the FunctionCallEdges " + ciEdge + " and " + aciEdge + " are different!");
        }
        for (int i = 0; i < ciArguments.size(); ++i) {
            ciArguments.get(i).accept(new StructureComparisonVisitor(aciArguments.get(i), ciVarToAciVar));
        }
    }

    CFANode getStartNode() {
        return this.ciStartNode;
    }

    Collection<CFANode> getEndNodes() {
        return this.ciEndNodes;
    }

    List<String> getInputVariables() {
        return this.inputVariables;
    }

    List<String> getOutputVariables() {
        return this.outputVariables;
    }

    private static class StructureExtendedComparisonVisitor
    extends StructureComparisonVisitor {
        private final Map<String, String> currentCiVarToAciVar;

        public StructureExtendedComparisonVisitor(CExpression pAciExp, Map<String, String> pCiVarToAciVar, Map<String, String> pCurrentCiVarToAciVar) {
            super(pAciExp, pCiVarToAciVar);
            this.currentCiVarToAciVar = pCurrentCiVarToAciVar;
        }

        @Override
        protected void computeMapping(String ciString, String aciString) {
            this.ciVarToAciVar.put(ciString, aciString);
            this.currentCiVarToAciVar.put(ciString, aciString);
        }
    }

    private static class StructureComparisonVisitor
    implements CExpressionVisitor<Void, AppliedCustomInstructionParsingFailedException> {
        protected CExpression aciExp;
        protected final Map<String, String> ciVarToAciVar;

        public StructureComparisonVisitor(CExpression pAciExp, Map<String, String> pCiVarToAciVar) {
            this.aciExp = pAciExp;
            this.ciVarToAciVar = pCiVarToAciVar;
        }

        @Override
        public Void visit(CArraySubscriptExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CArraySubscriptExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CArraySubscriptExpression, but ci is.");
            }
            CArraySubscriptExpression aciAExp = (CArraySubscriptExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(this.aciExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of ci " + ciExp + " and aci " + this.aciExp + " are different.");
            }
            this.aciExp = aciAExp.getArrayExpression();
            ciExp.getArrayExpression().accept(this);
            this.aciExp = aciAExp.getSubscriptExpression();
            ciExp.getSubscriptExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CFieldReference ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CFieldReference)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CFieldReference, but ci is.");
            }
            CFieldReference aciFieldRefExp = (CFieldReference)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciFieldRefExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the FieldReference of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciFieldRefExp + " (" + aciFieldRefExp.getExpressionType() + ").");
            }
            if (ciExp.isPointerDereference() != aciFieldRefExp.isPointerDereference()) {
                throw new AppliedCustomInstructionParsingFailedException("One of the ci " + ciExp + " and aci " + aciFieldRefExp + " is a pointerDereference, while the other one not.");
            }
            this.aciExp = aciFieldRefExp.getFieldOwner();
            ciExp.getFieldOwner().accept(this);
            return null;
        }

        @Override
        public Void visit(CIdExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (this.aciExp instanceof CIdExpression) {
                CIdExpression aciIdExp = (CIdExpression)this.aciExp;
                if (!ciExp.getExpressionType().equals(aciIdExp.getExpressionType())) {
                    throw new AppliedCustomInstructionParsingFailedException("The expression type of the IdExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciIdExp + " (" + aciIdExp.getExpressionType() + ").");
                }
                if (this.ciVarToAciVar.containsKey(ciExp.getDeclaration().getQualifiedName()) && !this.ciVarToAciVar.get(ciExp.getDeclaration().getQualifiedName()).equals(aciIdExp.getDeclaration().getQualifiedName())) {
                    throw new AppliedCustomInstructionParsingFailedException("The mapping is not clear. The map contains " + ciExp.getDeclaration().getQualifiedName() + " with the value " + this.ciVarToAciVar.get(ciExp.getDeclaration().getQualifiedName()) + ", which is different to " + aciIdExp.getDeclaration().getQualifiedName() + ".");
                }
                this.computeMapping(ciExp.getDeclaration().getQualifiedName(), aciIdExp.getDeclaration().getQualifiedName());
            } else {
                if (this.aciExp instanceof CCharLiteralExpression) {
                    throw new AppliedCustomInstructionParsingFailedException("The code contains a CCharLiteralExpression, which is unsupported.");
                }
                if (this.aciExp instanceof CStringLiteralExpression) {
                    throw new AppliedCustomInstructionParsingFailedException("The code contains a CStringLiteralExpression, which is unsupported.");
                }
                if (this.aciExp instanceof CImaginaryLiteralExpression) {
                    throw new AppliedCustomInstructionParsingFailedException("The code contains a CImaginaryLiteralExpression, which is unsupported.");
                }
                if (this.aciExp instanceof CIntegerLiteralExpression) {
                    this.compareSimpleTypes(ciExp, ((CIntegerLiteralExpression)this.aciExp).getValue(), (CSimpleType)this.aciExp.getExpressionType());
                } else if (this.aciExp instanceof CFloatLiteralExpression) {
                    this.compareSimpleTypes(ciExp, ((CFloatLiteralExpression)this.aciExp).getValue(), (CSimpleType)this.aciExp.getExpressionType());
                } else {
                    throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not a CSimpleType.");
                }
            }
            return null;
        }

        protected void computeMapping(String ciString, String aciString) {
            this.ciVarToAciVar.put(ciString, aciString);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void compareSimpleTypes(CIdExpression ciExp, Number aciExpValue, CSimpleType aciType) throws AppliedCustomInstructionParsingFailedException {
            if (!(ciExp.getExpressionType() instanceof CSimpleType)) throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not a CIdExpression.");
            CSimpleType ciST = (CSimpleType)ciExp.getExpressionType();
            if (!this.isValidSimpleType(ciST, aciType)) throw new AppliedCustomInstructionParsingFailedException("The simpleType of the ci " + ciExp + " is not a valid one.");
            if (!this.ciVarToAciVar.containsKey(ciExp.getDeclaration().getQualifiedName())) {
                this.ciVarToAciVar.put(ciExp.getDeclaration().getQualifiedName(), aciExpValue.toString());
                return;
            } else {
                if (this.ciVarToAciVar.get(ciExp.getDeclaration().getQualifiedName()).equals(aciExpValue.toString())) return;
                throw new AppliedCustomInstructionParsingFailedException("The mapping is not clear. The map contains " + ciExp.getDeclaration().getQualifiedName() + " with the value " + this.ciVarToAciVar.get(ciExp.getDeclaration().getQualifiedName()) + ", which is different to " + aciExpValue + ".");
            }
        }

        private boolean isValidSimpleType(CSimpleType ciST, CSimpleType pAciType) {
            return ciST.isComplex() == pAciType.isComplex() && ciST.isConst() == pAciType.isConst() && ciST.isImaginary() == pAciType.isImaginary() && ciST.isLong() == pAciType.isLong() && ciST.isLongLong() == pAciType.isLongLong() && ciST.isShort() == pAciType.isShort() && ciST.isSigned() == pAciType.isSigned() && ciST.isUnsigned() == pAciType.isUnsigned() && ciST.isVolatile() == pAciType.isVolatile() && (ciST.getType().isIntegerType() || ciST.getType().isFloatingPointType()) && ciST.isComplex() == ciST.isImaginary() && ciST.isImaginary() == ciST.isLong() && ciST.isLong() == ciST.isLongLong() && ciST.isLongLong() == ciST.isShort() && ciST.isShort() == ciST.isSigned() && ciST.isSigned() == ciST.isUnsigned();
        }

        @Override
        public Void visit(CPointerExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CPointerExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CPointerExpression, but ci is.");
            }
            CPointerExpression aciPExp = (CPointerExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciPExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the CPointerExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciPExp + " (" + aciPExp.getExpressionType() + ").");
            }
            this.aciExp = aciPExp.getOperand();
            ciExp.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CComplexCastExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CComplexCastExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CComplexCastExpression, but ci is.");
            }
            CComplexCastExpression aciCExp = (CComplexCastExpression)this.aciExp;
            if (ciExp.isImaginaryCast() != aciCExp.isImaginaryCast()) {
                throw new AppliedCustomInstructionParsingFailedException("One of the ci " + ciExp + " and aci " + aciCExp + " is an imaginaryCast, while the other one not.");
            }
            if (ciExp.isRealCast() != aciCExp.isRealCast()) {
                throw new AppliedCustomInstructionParsingFailedException("One of the ci " + ciExp + " and aci " + aciCExp + " is a realCast, while the other one not.");
            }
            if (!ciExp.getExpressionType().equals(aciCExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the CComplexCastExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciCExp + " (" + aciCExp.getExpressionType() + ").");
            }
            if (!ciExp.getType().equals(aciCExp.getType())) {
                throw new AppliedCustomInstructionParsingFailedException("The type of the CComplexCastExpression of ci " + ciExp + " (" + ciExp.getType() + ") is not equal to the one of the aci " + aciCExp + " (" + aciCExp.getType() + ").");
            }
            this.aciExp = aciCExp.getOperand();
            ciExp.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CBinaryExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            CBinaryExpression aciBinExp;
            if (this.aciExp instanceof CBinaryExpression) {
                aciBinExp = (CBinaryExpression)this.aciExp;
                if (!ciExp.getExpressionType().equals(aciBinExp.getExpressionType())) {
                    throw new AppliedCustomInstructionParsingFailedException("The expression type of the CBinaryExpression of ci " + ciExp + " is not equal to the one of the aci " + aciBinExp + ".");
                }
                if (!ciExp.getOperator().getOperator().equals(aciBinExp.getOperator().getOperator())) {
                    throw new AppliedCustomInstructionParsingFailedException("The operators of the CBinaryExpression the ci " + ciExp + " and aci " + aciBinExp + " are different.");
                }
                if (!ciExp.getCalculationType().equals(aciBinExp.getCalculationType())) {
                    throw new AppliedCustomInstructionParsingFailedException("The calculationType of the CBinaryExpression of ci " + ciExp + " and aci " + aciBinExp + " are different.");
                }
            } else {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CBinaryExpression, but ci is.");
            }
            this.aciExp = aciBinExp.getOperand1();
            ciExp.getOperand1().accept(this);
            this.aciExp = aciBinExp.getOperand2();
            ciExp.getOperand2().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CCastExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CCastExpression, but ci is.");
            }
            CCastExpression aciPExp = (CCastExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciPExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the CCastExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciPExp + " (" + aciPExp.getExpressionType() + ").");
            }
            this.aciExp = aciPExp.getOperand();
            ciExp.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CCharLiteralExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CCharLiteralExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CCharLiteralExpression, but ci is.");
            }
            CCharLiteralExpression aciCharExp = (CCharLiteralExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciCharExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the CharLiteralExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciCharExp + " (" + aciCharExp.getExpressionType() + ").");
            }
            if (ciExp.getCharacter() != aciCharExp.getCharacter()) {
                throw new AppliedCustomInstructionParsingFailedException("The value of the CCharLiteralExpression of ci " + ciExp + " and aci " + aciCharExp + " are different.");
            }
            return null;
        }

        @Override
        public Void visit(CFloatLiteralExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CFloatLiteralExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CFloatLiteralExpression, but ci is.");
            }
            CFloatLiteralExpression aciFloatExp = (CFloatLiteralExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciFloatExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the FloatLiteralExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciFloatExp + " (" + aciFloatExp.getExpressionType() + ").");
            }
            if (ciExp.getValue().compareTo(aciFloatExp.getValue()) != 0) {
                throw new AppliedCustomInstructionParsingFailedException("The value of the CCharLiteralExpression of ci " + ciExp + " and aci " + aciFloatExp + " are different.");
            }
            return null;
        }

        @Override
        public Void visit(CIntegerLiteralExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CIntegerLiteralExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CIntegerLiteralExpression, but ci is.");
            }
            CIntegerLiteralExpression aciIntegerLiteralExp = (CIntegerLiteralExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciIntegerLiteralExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the IntegerLiteralExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciIntegerLiteralExp + " (" + aciIntegerLiteralExp.getExpressionType() + ").");
            }
            if (!ciExp.getValue().equals(aciIntegerLiteralExp.getValue())) {
                throw new AppliedCustomInstructionParsingFailedException("The value of the CIntegerLiteralExpression of ci " + ciExp + " and aci " + aciIntegerLiteralExp + " are different.");
            }
            return null;
        }

        @Override
        public Void visit(CStringLiteralExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CStringLiteralExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CStringLiteralExpression, but ci is.");
            }
            CStringLiteralExpression aciStringLiteralExp = (CStringLiteralExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciStringLiteralExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the StringLiteralExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciStringLiteralExp + " (" + aciStringLiteralExp.getExpressionType() + ").");
            }
            if (!ciExp.getValue().equals(aciStringLiteralExp.getValue())) {
                throw new AppliedCustomInstructionParsingFailedException("The value of the CIntegerLiteralExpression of ci " + ciExp + " and aci " + aciStringLiteralExp + " are different.");
            }
            return null;
        }

        @Override
        public Void visit(CTypeIdExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CTypeIdExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CTypeIdExpression, but ci is.");
            }
            CTypeIdExpression aciIdExp = (CTypeIdExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciIdExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the CTypeIdExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciIdExp + " (" + aciIdExp.getExpressionType() + ").");
            }
            if (!ciExp.getType().equals(aciIdExp.getType())) {
                throw new AppliedCustomInstructionParsingFailedException("The type of the CTypeIdExpression of ci " + ciExp + " (" + ciExp.getType() + ") is not equal to the one of the aci " + aciIdExp + " (" + aciIdExp.getType() + ").");
            }
            if (!ciExp.getOperator().equals((Object)aciIdExp.getOperator())) {
                throw new AppliedCustomInstructionParsingFailedException("The operator of the CTypeIdExpression of ci " + ciExp + " (" + ciExp.getOperator() + ") is not equal to the one of the aci " + aciIdExp + " (" + aciIdExp.getOperator() + ").");
            }
            return null;
        }

        @Override
        public Void visit(CUnaryExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            CUnaryExpression aciUnExp;
            if (this.aciExp instanceof CUnaryExpression) {
                aciUnExp = (CUnaryExpression)this.aciExp;
                if (!ciExp.getExpressionType().equals(aciUnExp.getExpressionType())) {
                    throw new AppliedCustomInstructionParsingFailedException("The expression type of the CUnaryExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciUnExp + " (" + aciUnExp.getExpressionType() + ").");
                }
                if (!ciExp.getOperator().getOperator().equals(aciUnExp.getOperator().getOperator())) {
                    throw new AppliedCustomInstructionParsingFailedException("The operators of the ci expression " + ciExp + " and aci expression " + aciUnExp + " don't fit together!");
                }
            } else {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type UnaryExpression, but ci is.");
            }
            this.aciExp = aciUnExp.getOperand();
            ciExp.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CImaginaryLiteralExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            throw new AppliedCustomInstructionParsingFailedException("The code contains a CImaginaryLiteralExpression, which is unsupported.");
        }

        @Override
        public Void visit(CAddressOfLabelExpression ciExp) throws AppliedCustomInstructionParsingFailedException {
            if (!(this.aciExp instanceof CAddressOfLabelExpression)) {
                throw new AppliedCustomInstructionParsingFailedException("The aci expression " + this.aciExp + " is not from the type CAddressOfLabelExpression, but ci is.");
            }
            CAddressOfLabelExpression aciAExp = (CAddressOfLabelExpression)this.aciExp;
            if (!ciExp.getExpressionType().equals(aciAExp.getExpressionType())) {
                throw new AppliedCustomInstructionParsingFailedException("The expression type of the CAddressOfLabelExpression of ci " + ciExp + " (" + ciExp.getExpressionType() + ") is not equal to the one of the aci " + aciAExp + " (" + aciAExp.getExpressionType() + ").");
            }
            if (!ciExp.getLabelName().equals(aciAExp.getLabelName())) {
                throw new AppliedCustomInstructionParsingFailedException("The label name of the CAddressOfLabelExpression of ci " + ciExp + " and aci " + aciAExp + " are different.");
            }
            return null;
        }
    }
}

