/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParser;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParsingFailedException;
import org.sosy_lab.cpachecker.util.ci.CustomInstruction;

public class CustomInstructionApplications {
    private final Map<CFANode, AppliedCustomInstruction> cis;
    private final CustomInstruction ci;

    protected CustomInstructionApplications(Map<CFANode, AppliedCustomInstruction> pCis, CustomInstruction pCi) {
        this.cis = pCis;
        this.ci = pCi;
    }

    public boolean isStartState(AbstractState pState) throws CPAException {
        CFANode locState = AbstractStates.extractLocation(pState);
        if (locState == null) {
            throw new CPAException("The state " + pState + " has to contain a location state!");
        }
        return this.cis.containsKey(locState);
    }

    public boolean isEndState(AbstractState pIsEnd, AbstractState pCIStart) throws CPAException {
        return this.isEndState(pIsEnd, AbstractStates.extractLocation(pCIStart));
    }

    public boolean isEndState(AbstractState pIsEnd, CFANode pCIStart) throws CPAException {
        assert (this.cis.containsKey(pCIStart));
        return this.cis.get(pCIStart).isEndState(pIsEnd);
    }

    public AppliedCustomInstruction getAppliedCustomInstructionFor(ARGState pState) throws CPAException {
        CFANode locState = AbstractStates.extractLocation(pState);
        if (locState == null) {
            throw new CPAException("The state " + pState + " has to contain a location state!");
        }
        if (!this.isStartState(pState)) {
            throw new CPAException("The state does not represent start of known custom instruction");
        }
        return this.cis.get(locState);
    }

    public CustomInstruction getCustomInstruction() {
        return this.ci;
    }

    public Map<CFANode, AppliedCustomInstruction> getMapping() {
        return this.cis;
    }

    public ImmutableSet<CFANode> getStartAndEndLocationsOfCIApplications() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AppliedCustomInstruction aci : this.cis.values()) {
            result.addAll(aci.getStartAndEndNodes());
        }
        return result.build();
    }

    public int getNumApplications() {
        return this.cis.size();
    }

    @Options(prefix="custominstructions")
    private static class CustomInstructionsForBinaryOperator
    extends CustomInstructionApplicationBuilder {
        @Option(secure=true, description="Specify simple custom instruction by specifying the binary operator op. All simple cis are of the form r = x op y. Leave empty (default) if you specify a more complex custom instruction within code.")
        private CBinaryExpression.BinaryOperator binaryOperatorForSimpleCustomInstruction = CBinaryExpression.BinaryOperator.PLUS;
        @Option(secure=true, name="definitionFile", description="File to dump start location of identified custom instruction applications")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        private Path foundCustomInstructionsDefinition = Path.of("ci_def.txt", new String[0]);

        public CustomInstructionsForBinaryOperator(Configuration pConfig, LogManager pLogger, ShutdownNotifier pSdNotifier, CFA pCfa) throws InvalidConfigurationException {
            super(pConfig, pLogger, pSdNotifier, pCfa);
            pConfig.inject((Object)this);
            this.logger.log(Level.FINE, new Object[]{"Using a simple custom instruction. Find out the applications ourselves"});
        }

        private CustomInstructionApplications findSimpleCustomInstructionApplications() throws AppliedCustomInstructionParsingFailedException, IOException, InterruptedException, UnrecognizedCodeException {
            CSimpleType type = CNumericTypes.INT;
            CIdExpression r = new CIdExpression(FileLocation.DUMMY, new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.AUTO, type, "r", "r", "r", null));
            CIdExpression x = new CIdExpression(FileLocation.DUMMY, new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.AUTO, type, "x", "x", "x", null));
            CIdExpression y = new CIdExpression(FileLocation.DUMMY, new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.AUTO, type, "y", "y", "y", null));
            CExpressionAssignmentStatement stmt = new CExpressionAssignmentStatement(FileLocation.DUMMY, r, new CBinaryExpressionBuilder(MachineModel.LINUX64, this.logger).buildBinaryExpression(x, y, this.binaryOperatorForSimpleCustomInstruction));
            CFunctionDeclaration ciDef = new CFunctionDeclaration(FileLocation.DUMMY, CFunctionType.NO_ARGS_VOID_FUNCTION, "ci", (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
            CFANode start = new CFANode(ciDef);
            CFANode end = new CFANode(ciDef);
            CStatementEdge ciEdge = new CStatementEdge("r=x" + this.binaryOperatorForSimpleCustomInstruction + "y;", stmt, FileLocation.DUMMY, start, end);
            start.addLeavingEdge(ciEdge);
            end.addEnteringEdge(ciEdge);
            ImmutableList input = ImmutableList.of((Object)"x", (Object)"y");
            CustomInstruction ci = new CustomInstruction(start, (Set<CFANode>)ImmutableSet.of((Object)end), (ImmutableList<String>)input, (ImmutableList<String>)ImmutableList.of((Object)"r"), this.shutdownNotifier);
            try (Writer aciDef = IO.openOutputFile((Path)this.foundCustomInstructionsDefinition, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                for (CFANode node : this.cfa.getAllNodes()) {
                    for (CFAEdge edge : CFAUtils.allLeavingEdges(node)) {
                        if (!(edge instanceof CStatementEdge) || !(((CStatementEdge)edge).getStatement() instanceof CExpressionAssignmentStatement) || !((stmt = (CExpressionAssignmentStatement)((CStatementEdge)edge).getStatement()).getRightHandSide() instanceof CBinaryExpression) || !((CBinaryExpression)stmt.getRightHandSide()).getOperator().equals(this.binaryOperatorForSimpleCustomInstruction) || !stmt.getLeftHandSide().getExpressionType().equals(type)) continue;
                        aciDef.write(node.getNodeNumber() + "\n");
                    }
                }
            }
            try (Writer br = IO.openOutputFile((Path)this.ciSpec, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                br.write(ci.getSignature() + "\n");
                String ciString = ci.getFakeSMTDescription().getSecond();
                br.write(ciString.substring(ciString.indexOf("a") - 1, ciString.length() - 1) + ";");
            }
            return new AppliedCustomInstructionParser(this.shutdownNotifier, this.logger, this.cfa).parse(ci, this.foundCustomInstructionsDefinition);
        }

        @Override
        public CustomInstructionApplications identifyCIApplications() throws UnrecognizedCodeException, AppliedCustomInstructionParsingFailedException, IOException, InterruptedException {
            CustomInstructionApplications cia = this.findSimpleCustomInstructionApplications();
            this.logger.log(Level.INFO, new Object[]{"Found ", cia.getMapping().size(), " applications of binary operator", this.binaryOperatorForSimpleCustomInstruction, " in code."});
            return cia;
        }
    }

    @Options(prefix="custominstructions")
    private static class CustomInstructionApplicationsAutomatic
    extends CustomInstructionApplicationBuilder {
        @Option(secure=true, name="ciFun", description="Name of function containing the custom instruction definition")
        private String ciFunction;
        @Option(secure=true, name="definitionFile", description="File specifying start locations of custom instruction applications")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        private Path appliedCustomInstructionsDefinition = Path.of("ci_def.txt", new String[0]);

        public CustomInstructionApplicationsAutomatic(Configuration pConfig, CFA pCfa, LogManager pLogger, ShutdownNotifier pSdNotifier) throws InvalidConfigurationException {
            super(pConfig, pLogger, pSdNotifier, pCfa);
            pConfig.inject((Object)this);
            Preconditions.checkNotNull((Object)this.ciFunction);
        }

        @Override
        public CustomInstructionApplications identifyCIApplications() throws AppliedCustomInstructionParsingFailedException, IOException, InterruptedException {
            AppliedCustomInstructionParser parser = new AppliedCustomInstructionParser(this.shutdownNotifier, this.logger, this.cfa);
            return parser.parse(this.findCIApplications(parser), this.appliedCustomInstructionsDefinition);
        }

        private CustomInstruction findCIApplications(AppliedCustomInstructionParser pParser) throws AppliedCustomInstructionParsingFailedException, InterruptedException, IOException {
            CustomInstruction ci = pParser.readCustomInstruction(this.ciFunction);
            try (Writer out = IO.openOutputFile((Path)this.appliedCustomInstructionsDefinition, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                for (CFANode node : this.cfa.getAllNodes()) {
                    if (Objects.equals(node, ci.getStartNode()) || !pParser.isAppliedCI(ci, node)) continue;
                    this.shutdownNotifier.shutdownIfNecessary();
                    out.append(node.getNodeNumber() + "\n");
                }
            }
            return ci;
        }
    }

    @Options(prefix="custominstructions")
    private static class CustomInstructionApplicationsFromFile
    extends CustomInstructionApplicationBuilder {
        @Option(secure=true, name="definitionFile", description="File specifying start locations of custom instruction applications")
        @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
        private Path appliedCustomInstructionsDefinition = Path.of("ci_def.txt", new String[0]);

        public CustomInstructionApplicationsFromFile(Configuration pConfig, CFA pCfa, LogManager pLogger, ShutdownNotifier pSdNotifier) throws InvalidConfigurationException {
            super(pConfig, pLogger, pSdNotifier, pCfa);
            pConfig.inject((Object)this, CustomInstructionApplicationsFromFile.class);
            try {
                IO.checkReadableFile((Path)this.appliedCustomInstructionsDefinition);
            }
            catch (FileNotFoundException e) {
                throw new InvalidConfigurationException("Definition file for custom instruction application does not exist", (Throwable)e);
            }
        }

        @Override
        public CustomInstructionApplications identifyCIApplications() throws AppliedCustomInstructionParsingFailedException, IOException, InterruptedException {
            return new AppliedCustomInstructionParser(this.shutdownNotifier, this.logger, this.cfa).parse(this.appliedCustomInstructionsDefinition, this.ciSpec);
        }
    }

    @Options(prefix="custominstructions")
    public static abstract class CustomInstructionApplicationBuilder {
        @Option(secure=true, name="ciSignature", description="Signature for custom instruction, describes names and order of input and output variables of a custom instruction")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        protected Path ciSpec = Path.of("ci_spec.txt", new String[0]);
        protected final LogManager logger;
        protected final ShutdownNotifier shutdownNotifier;
        protected final CFA cfa;

        protected CustomInstructionApplicationBuilder(Configuration config, LogManager pLogger, ShutdownNotifier sdNotifier, CFA pCfa) throws InvalidConfigurationException {
            config.inject((Object)this, CustomInstructionApplicationBuilder.class);
            this.logger = pLogger;
            this.shutdownNotifier = sdNotifier;
            this.cfa = pCfa;
        }

        public abstract CustomInstructionApplications identifyCIApplications() throws AppliedCustomInstructionParsingFailedException, IOException, InterruptedException, UnrecognizedCodeException;

        public static CustomInstructionApplicationBuilder getBuilder(CIDescriptionType type, Configuration pConfig, LogManager pLogger, ShutdownNotifier pSdNotifier, CFA pCfa) throws InvalidConfigurationException {
            switch (type) {
                case AUTOMATIC: {
                    return new CustomInstructionApplicationsAutomatic(pConfig, pCfa, pLogger, pSdNotifier);
                }
                case MANUAL: {
                    return new CustomInstructionApplicationsFromFile(pConfig, pCfa, pLogger, pSdNotifier);
                }
                case OPERATOR: {
                    return new CustomInstructionsForBinaryOperator(pConfig, pLogger, pSdNotifier, pCfa);
                }
            }
            throw new IllegalArgumentException("Unknown type of custom instruction applications identifier");
        }

        public static enum CIDescriptionType {
            MANUAL,
            OPERATOR,
            AUTOMATIC;

        }
    }
}

