/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionApplications;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionRequirementsWriter;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemover;

@Options(prefix="custominstructions")
public class CustomInstructionRequirementsExtractor {
    @Option(secure=true, description="Try to remove requirements that are covered by another requirment and are, thus, irrelevant for custom instruction behavior")
    private boolean removeCoveredRequirements = false;
    @Option(secure=true, description="Try to remove parts of requirements that are not related to custom instruction and are, thus, irrelevant for custom instruction behavior")
    private boolean enableRequirementsSlicing = false;
    @Option(secure=true, description="Where to dump the requirements on custom instruction extracted from analysis")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathCounterTemplate dumpCIRequirements = PathCounterTemplate.ofFormatString((String)"ci%d.smt");
    @Option(secure=true, description="Qualified name of class for abstract state which provides custom instruction requirements.")
    private String requirementsStateClassName;
    private final Class<? extends AbstractState> requirementsStateClass;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final ConfigurableProgramAnalysis cpa;

    public CustomInstructionRequirementsExtractor(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        try {
            this.requirementsStateClass = Class.forName(this.requirementsStateClassName);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("The abstract state " + this.requirementsStateClassName + " is unknown.");
        }
        catch (ClassCastException ex) {
            throw new InvalidConfigurationException(this.requirementsStateClassName + "is not an abstract state.");
        }
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cpa = pCpa;
    }

    public void extractRequirements(ARGState root, CustomInstructionApplications cia) throws InterruptedException, CPAException {
        if (this.dumpCIRequirements == null) {
            this.logger.log(Level.WARNING, new Object[]{"Output files for saving requirements for custom instruction not specified."});
            return;
        }
        CustomInstructionRequirementsWriter writer = new CustomInstructionRequirementsWriter(this.dumpCIRequirements, this.requirementsStateClass, this.logger, this.cpa, this.enableRequirementsSlicing);
        Collection<ARGState> ciStartNodes = this.getCustomInstructionStartNodes(root, cia);
        List<Pair<ARGState, Collection<ARGState>>> requirements = new ArrayList<Pair<ARGState, Collection<ARGState>>>(ciStartNodes.size());
        ArrayList<Pair<List<String>, List<String>>> signatures = new ArrayList<Pair<List<String>, List<String>>>(ciStartNodes.size());
        for (ARGState aRGState : ciStartNodes) {
            this.shutdownNotifier.shutdownIfNecessary();
            requirements.add(Pair.of(aRGState, this.findEndStatesFor(aRGState, cia)));
            signatures.add(Pair.of(cia.getAppliedCustomInstructionFor(aRGState).getInputVariablesAndConstants(), cia.getAppliedCustomInstructionFor(aRGState).getOutputVariables()));
        }
        if (this.removeCoveredRequirements) {
            requirements = RedundantRequirementsRemover.removeRedundantRequirements(requirements, signatures, this.requirementsStateClass);
        }
        for (Pair pair : requirements) {
            this.shutdownNotifier.shutdownIfNecessary();
            try {
                writer.writeCIRequirement((ARGState)pair.getFirst(), (Collection)pair.getSecond(), cia.getAppliedCustomInstructionFor((ARGState)pair.getFirst()));
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, new Object[]{"Writing  the CIRequirement failed at node " + pair.getFirst() + ".", e});
            }
        }
    }

    public Class<? extends AbstractState> getRequirementsStateClass() {
        return this.requirementsStateClass;
    }

    private Collection<ARGState> getCustomInstructionStartNodes(ARGState root, CustomInstructionApplications pCustomIA) throws InterruptedException, CPAException {
        ImmutableSet.Builder set = new ImmutableSet.Builder();
        HashSet<ARGState> visitedNodes = new HashSet<ARGState>();
        ArrayDeque<ARGState> queue = new ArrayDeque<ARGState>();
        queue.add(root);
        visitedNodes.add(root);
        while (!queue.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ARGState tmp = (ARGState)queue.poll();
            visitedNodes.add(tmp);
            if (pCustomIA.isStartState(tmp)) {
                set.add((Object)this.uncover(tmp));
            }
            for (ARGState child : tmp.getChildren()) {
                if (visitedNodes.contains(child)) continue;
                queue.add(child);
                visitedNodes.add(child);
            }
        }
        return set.build();
    }

    private Collection<ARGState> findEndStatesFor(ARGState ciStart, CustomInstructionApplications pCustomIA) throws InterruptedException, CPAException {
        ArrayList<ARGState> list = new ArrayList<ARGState>();
        ArrayDeque<ARGState> queue = new ArrayDeque<ARGState>();
        HashSet<ARGState> visitedNodes = new HashSet<ARGState>();
        queue.add(ciStart);
        visitedNodes.add(ciStart);
        while (!queue.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ARGState tmp = (ARGState)queue.poll();
            if (pCustomIA.isEndState((AbstractState)tmp, ciStart)) {
                list.add(tmp);
                continue;
            }
            for (ARGState child : tmp.getChildren()) {
                if (visitedNodes.contains(child = this.uncover(child))) continue;
                queue.add(child);
                visitedNodes.add(child);
            }
        }
        return list;
    }

    private ARGState uncover(ARGState state) {
        if (state.isCovered()) {
            return this.uncover(state.getCoveringState());
        }
        return state;
    }
}

