/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.translators.AbstractRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.ApronRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.IntervalRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.PredicateRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.SignRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.ValueRequirementsTranslator;

public class CustomInstructionRequirementsWriter {
    private final Class<?> requirementsState;
    private AbstractRequirementsTranslator<? extends AbstractState> abstractReqTranslator;
    private final LogManager logger;
    private final boolean enableRequirementSlicing;
    private final PathCounterTemplate fileTemplate;

    public CustomInstructionRequirementsWriter(PathCounterTemplate ciReqFiles, Class<?> reqirementsState, LogManager log, ConfigurableProgramAnalysis cpa, boolean enableRequirementSlicing) throws CPAException {
        this.fileTemplate = ciReqFiles;
        this.requirementsState = reqirementsState;
        this.logger = log;
        this.enableRequirementSlicing = enableRequirementSlicing;
        this.createRequirementTranslator(cpa);
    }

    public void writeCIRequirement(ARGState pState, Collection<ARGState> pSet, AppliedCustomInstruction pACI) throws IOException, CPAException {
        Pair<Pair<List<String>, String>, Pair<List<String>, String>> convertedRequirements = this.enableRequirementSlicing ? this.abstractReqTranslator.convertRequirements(pState, pSet, pACI.getIndicesForReturnVars(), pACI.getInputVariables(), pACI.getOutputVariables()) : this.abstractReqTranslator.convertRequirements(pState, pSet, pACI.getIndicesForReturnVars(), null, null);
        if (convertedRequirements.getSecond().getSecond().matches("\\(define-fun post \\(\\) Bool(\\s)+true\\)")) {
            return;
        }
        Pair<List<String>, String> fakeSMTDesc = pACI.getFakeSMTDescription();
        List<String> set = this.removeDuplicates(convertedRequirements.getFirst().getFirst(), convertedRequirements.getSecond().getFirst(), fakeSMTDesc.getFirst());
        try (Writer br = IO.openOutputFile((Path)this.fileTemplate.getFreshPath(), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            for (String element : set) {
                br.write(element);
                br.write("\n");
            }
            br.write("\n;Custom Instruction\n");
            br.write(pACI.getFakeSMTDescription().getSecond());
            br.write("\n\n;Pre and Post Conditions\n");
            br.write(convertedRequirements.getFirst().getSecond());
            br.write("\n");
            br.write(convertedRequirements.getSecond().getSecond());
            br.write("\n");
        }
    }

    private List<String> removeDuplicates(List<String> pre, List<String> post, List<String> ci) {
        int sumSize = pre.size() + post.size() + ci.size();
        ArrayList<String> duplicateFreeSet = new ArrayList<String>(sumSize);
        HashSet set = Sets.newHashSetWithExpectedSize((int)sumSize);
        this.addNonMembersToList(pre, duplicateFreeSet, set);
        this.addNonMembersToList(post, duplicateFreeSet, set);
        this.addNonMembersToList(ci, duplicateFreeSet, set);
        return duplicateFreeSet;
    }

    private void addNonMembersToList(List<String> candidates, List<String> list, Set<String> listElems) {
        for (String next : candidates) {
            if (!listElems.add(next)) continue;
            list.add(next);
        }
    }

    private void createRequirementTranslator(ConfigurableProgramAnalysis cpa) throws CPAException {
        if (this.requirementsState.equals(SignState.class)) {
            this.abstractReqTranslator = new SignRequirementsTranslator(this.logger);
        } else if (this.requirementsState.equals(ValueAnalysisState.class)) {
            this.abstractReqTranslator = new ValueRequirementsTranslator(this.logger);
        } else if (this.requirementsState.equals(IntervalAnalysisState.class)) {
            this.abstractReqTranslator = new IntervalRequirementsTranslator(this.logger);
        } else if (this.requirementsState.equals(PredicateAbstractState.class)) {
            PredicateCPA pCpa = CPAs.retrieveCPA(cpa, PredicateCPA.class);
            if (pCpa == null) {
                pCpa = CPAs.retrieveCPA(cpa, BAMPredicateCPA.class);
            }
            if (pCpa == null) {
                throw new CPAException("Cannot extract analysis which was responsible for construction PredicateAbstract States");
            }
            this.abstractReqTranslator = new PredicateRequirementsTranslator(pCpa.getSolver().getFormulaManager());
        } else if (this.requirementsState.equals(ApronState.class)) {
            this.abstractReqTranslator = new ApronRequirementsTranslator(ApronState.class, this.logger);
        } else {
            throw new CPAException("There is no suitable requirementTranslator available.");
        }
    }
}

