/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.CustomInstruction;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionApplications;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class CustomInstructionTest {
    private CustomInstructionApplications cia;
    private AppliedCustomInstruction aci;
    private Map<CFANode, AppliedCustomInstruction> cis;
    private CustomInstruction ci;
    private Constructor<? extends AbstractState> locConstructor;
    private CFA cfa;
    private CFANode startNode;
    private Set<CFANode> endNodes;
    private ARGState start;
    private ARGState end;

    @Before
    @SuppressForbidden(value="reflection only in test")
    public void init() throws Exception {
        this.cfa = TestDataTools.makeCFA("void main(int a) {", "  int a;", "  if (a>0) {", "    a=a+1;", "  } else {", "    a=a-1;", "  }", "}");
        this.locConstructor = LocationState.class.getDeclaredConstructor(CFANode.class, Boolean.TYPE);
        this.locConstructor.setAccessible(true);
        this.startNode = this.cfa.getMainFunction();
        this.endNodes = new HashSet<CFANode>();
        for (CFAEdge edge : CFAUtils.allEnteringEdges(this.cfa.getMainFunction().getExitNode())) {
            this.endNodes.add(edge.getPredecessor());
        }
        ImmutableList input = ImmutableList.of((Object)"a");
        ImmutableList output = ImmutableList.of((Object)"b");
        this.ci = new CustomInstruction(this.startNode, this.endNodes, (ImmutableList<String>)input, (ImmutableList<String>)output, ShutdownNotifier.createDummy());
        this.cis = new HashMap<CFANode, AppliedCustomInstruction>();
        this.aci = new AppliedCustomInstruction(this.startNode, this.endNodes, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Pair.of(ImmutableList.of(), ""), SSAMap.emptySSAMap());
        this.cis.put(this.startNode, this.aci);
        this.cia = new CustomInstructionApplications(this.cis, this.ci);
        this.start = new ARGState(this.locConstructor.newInstance(this.startNode, true), null);
        this.end = new ARGState(this.locConstructor.newInstance(this.endNodes.iterator().next(), true), null);
    }

    @Test
    public void testIsStartState() throws Exception {
        ARGState notStart = new ARGState(this.locConstructor.newInstance(this.startNode.getLeavingEdge(0).getSuccessor(), true), this.start);
        ARGState noLocation = new ARGState(new CallstackState(null, "main", this.startNode), null);
        Truth.assertThat((Boolean)this.aci.isStartState(this.start)).isTrue();
        Truth.assertThat((Boolean)this.aci.isStartState(notStart)).isFalse();
        try {
            this.aci.isStartState(noLocation);
            Truth.assert_().fail();
        }
        catch (CPAException cPAException) {
            // empty catch block
        }
        Truth.assertThat((Boolean)this.cia.isStartState(this.start)).isTrue();
        Truth.assertThat((Boolean)this.cia.isStartState(notStart)).isFalse();
        try {
            this.cia.isStartState(noLocation);
            Truth.assert_().fail();
        }
        catch (CPAException cPAException) {
            // empty catch block
        }
    }

    @Test
    public void testIsEndState() throws CPAException, IllegalArgumentException {
        ARGState noLocation = new ARGState(new CallstackState(null, "main", this.startNode), null);
        Truth.assertThat((Boolean)this.aci.isEndState(this.end)).isTrue();
        Truth.assertThat((Boolean)this.aci.isEndState(this.start)).isFalse();
        try {
            this.aci.isEndState(noLocation);
            Truth.assert_().fail();
        }
        catch (CPAException cPAException) {
            // empty catch block
        }
        Truth.assertThat((Boolean)this.cia.isEndState((AbstractState)this.end, this.startNode)).isTrue();
        Truth.assertThat((Boolean)this.cia.isEndState((AbstractState)this.start, this.startNode)).isFalse();
        Truth.assertThat((Boolean)this.cia.isEndState((AbstractState)this.end, this.start)).isTrue();
        Truth.assertThat((Boolean)this.cia.isEndState((AbstractState)this.start, this.start)).isFalse();
    }

    @Test
    public void testGetAppliedCustomInstruction() throws IllegalArgumentException, CPAException {
        Truth.assertThat((Object)this.cia.getAppliedCustomInstructionFor(this.start)).isEqualTo((Object)this.cis.get(this.startNode));
        try {
            this.cia.getAppliedCustomInstructionFor(this.end);
            Truth.assert_().fail();
        }
        catch (CPAException e) {
            Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"The state does not represent start of known custom instruction");
        }
        try {
            this.cia.getAppliedCustomInstructionFor(new ARGState(new CallstackState(null, "main", this.startNode), null));
            Truth.assert_().fail();
        }
        catch (CPAException cPAException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSignature() {
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of(), ShutdownNotifier.createDummy());
        Truth.assertThat((String)this.ci.getSignature()).isEqualTo((Object)"() -> ()");
        ImmutableList inputVars = ImmutableList.of((Object)"var");
        ImmutableList outputVars = ImmutableList.of((Object)"var0");
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)inputVars, (ImmutableList<String>)outputVars, ShutdownNotifier.createDummy());
        Truth.assertThat((String)this.ci.getSignature()).isEqualTo((Object)"(var) -> (var0@1)");
        inputVars = ImmutableList.of((Object)"f::var1", (Object)"var2");
        outputVars = ImmutableList.of((Object)"var3", (Object)"f::var4", (Object)"var5");
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)inputVars, (ImmutableList<String>)outputVars, ShutdownNotifier.createDummy());
        Truth.assertThat((String)this.ci.getSignature()).isEqualTo((Object)"(|f::var1|, var2) -> (var3@1, |f::var4@1|, var5@1)");
    }

    @Test
    public void testGetFakeSMTDescription() {
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of(), ShutdownNotifier.createDummy());
        Pair<List<String>, String> pair = this.ci.getFakeSMTDescription();
        Truth.assertThat((Iterable)pair.getFirst()).isEmpty();
        Truth.assertThat((String)pair.getSecond()).isEqualTo((Object)"(define-fun ci() Bool true)");
        ImmutableList inputVars = ImmutableList.of((Object)"var");
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)inputVars, (ImmutableList<String>)ImmutableList.of(), ShutdownNotifier.createDummy());
        pair = this.ci.getFakeSMTDescription();
        Truth.assertThat((Iterable)pair.getFirst()).hasSize(1);
        Truth.assertThat((String)pair.getFirst().get(0)).isEqualTo((Object)"(declare-fun var () Int)");
        Truth.assertThat((String)pair.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(= var 0))");
        ImmutableList outputVars = ImmutableList.of((Object)"var1");
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)ImmutableList.of(), (ImmutableList<String>)outputVars, ShutdownNotifier.createDummy());
        pair = this.ci.getFakeSMTDescription();
        Truth.assertThat((Iterable)pair.getFirst()).hasSize(1);
        Truth.assertThat((String)pair.getFirst().get(0)).isEqualTo((Object)"(declare-fun var1@1 () Int)");
        Truth.assertThat((String)pair.getSecond()).isEqualTo((Object)"(define-fun ci() Bool (= var1@1 0))");
        inputVars = ImmutableList.of((Object)"var1");
        outputVars = ImmutableList.of((Object)"var2");
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)inputVars, (ImmutableList<String>)outputVars, ShutdownNotifier.createDummy());
        pair = this.ci.getFakeSMTDescription();
        Truth.assertThat((Iterable)pair.getFirst()).hasSize(2);
        Truth.assertThat((String)pair.getFirst().get(0)).isEqualTo((Object)"(declare-fun var1 () Int)");
        Truth.assertThat((String)pair.getFirst().get(1)).isEqualTo((Object)"(declare-fun var2@1 () Int)");
        Truth.assertThat((String)pair.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(and (= var1 0) (= var2@1 0)))");
        inputVars = ImmutableList.of((Object)"var", (Object)"f::var1", (Object)"var2");
        outputVars = ImmutableList.of((Object)"var3", (Object)"f::var4");
        this.ci = new CustomInstruction(null, null, (ImmutableList<String>)inputVars, (ImmutableList<String>)outputVars, ShutdownNotifier.createDummy());
        pair = this.ci.getFakeSMTDescription();
        Truth.assertThat((Iterable)pair.getFirst()).hasSize(5);
        Truth.assertThat((String)pair.getFirst().get(0)).isEqualTo((Object)"(declare-fun var () Int)");
        Truth.assertThat((String)pair.getFirst().get(1)).isEqualTo((Object)"(declare-fun |f::var1| () Int)");
        Truth.assertThat((String)pair.getFirst().get(2)).isEqualTo((Object)"(declare-fun var2 () Int)");
        Truth.assertThat((String)pair.getFirst().get(3)).isEqualTo((Object)"(declare-fun var3@1 () Int)");
        Truth.assertThat((String)pair.getFirst().get(4)).isEqualTo((Object)"(declare-fun |f::var4@1| () Int)");
        Truth.assertThat((String)pair.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(and (= var 0)(and (= |f::var1| 0)(and (= var2 0)(and (= var3@1 0) (= |f::var4@1| 0))))))");
    }

    @Test
    public void testInspectAppliedCustomInstruction() throws Exception {
        this.cfa = TestDataTools.makeCFA("extern int f2(int);", "int f(int x) {", "  return x * x;", "}", "void main() {", "  int z;", "  int y;", "  start_ci: int x = 5 * z;", "  if (!(x>y)) {", "    if (z>0) {", "      x + y;", "      z = x + y;", "      z = f(x);", "      x = f2(y);", "    }", "  }", "  end_ci_1: int b;", "  int a = 5 * b;", "  if (!(a>7)) {", "    if (b>0) {", "      a + 7;", "      b = a + 7;", "      b = f(a);", "      a = f2(7);", "    }", "  }", "  x = x + 1;", "}");
        CFANode aciStartNode = null;
        CFANode aciEndNode = null;
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> queue = new ArrayDeque<CFANode>();
        queue.add(this.cfa.getFunctionHead("main"));
        this.endNodes = new HashSet<CFANode>();
        this.startNode = null;
        while (!queue.isEmpty()) {
            CFANode node = (CFANode)queue.poll();
            if (node instanceof CFALabelNode) {
                if (((CFALabelNode)node).getLabel().startsWith("start_ci")) {
                    this.startNode = node;
                }
                if (((CFALabelNode)node).getLabel().startsWith("end_ci")) {
                    CFAUtils.allPredecessorsOf(node).copyInto(this.endNodes);
                }
            }
            for (CFAEdge e : CFAUtils.allLeavingEdges(node)) {
                if (!visitedNodes.contains(e.getSuccessor())) {
                    queue.add(e.getSuccessor());
                    visitedNodes.add(e.getSuccessor());
                }
                if (e.getCode().equals("int a = 5 * b;")) {
                    aciStartNode = e.getPredecessor();
                }
                if (!e.getCode().equals("x = x + 1;")) continue;
                aciEndNode = e.getPredecessor();
            }
        }
        Truth.assertThat(aciStartNode).isNotNull();
        Truth.assertThat(aciEndNode).isNotNull();
        Truth.assertThat((Comparable)this.startNode).isNotNull();
        Truth.assertThat(this.endNodes).hasSize(1);
        ImmutableList input = ImmutableList.of((Object)"main::y", (Object)"main::z");
        ImmutableList output = ImmutableList.of((Object)"main::x", (Object)"main::z");
        this.ci = new CustomInstruction(this.startNode, this.endNodes, (ImmutableList<String>)input, (ImmutableList<String>)output, ShutdownNotifier.createDummy());
        this.aci = this.ci.inspectAppliedCustomInstruction(aciStartNode);
        ArrayList<String> inputVars = new ArrayList<String>();
        inputVars.add("main::b");
        Truth.assertThat(this.aci.getInputVariables()).containsExactlyElementsIn(inputVars);
        ArrayList<String> outputVars = new ArrayList<String>();
        outputVars.add("main::a");
        outputVars.add("main::b");
        Truth.assertThat(this.aci.getOutputVariables()).containsExactlyElementsIn(outputVars);
        Pair<List<String>, String> pair = this.aci.getFakeSMTDescription();
        Truth.assertThat((Iterable)pair.getFirst()).hasSize(3);
        Truth.assertThat((String)pair.getFirst().get(0)).isEqualTo((Object)"(declare-fun |main::b| () Int)");
        Truth.assertThat((String)pair.getFirst().get(1)).isEqualTo((Object)"(declare-fun |main::a@1| () Int)");
        Truth.assertThat((String)pair.getFirst().get(2)).isEqualTo((Object)"(declare-fun |main::b@1| () Int)");
        Truth.assertThat((String)pair.getSecond()).isEqualTo((Object)"(define-fun ci() Bool(and (= 7 0)(and (= |main::b| 0)(and (= |main::a@1| 0) (= |main::b@1| 0)))))");
        SSAMap ssaMap = this.aci.getIndicesForReturnVars();
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("main::a");
        variables.add("main::b");
        Truth.assertThat(ssaMap.allVariables()).containsExactlyElementsIn(variables);
        Truth.assertThat((Integer)ssaMap.getIndex((String)variables.get(0))).isEqualTo((Object)1);
        Truth.assertThat((Integer)ssaMap.getIndex((String)variables.get(1))).isEqualTo((Object)1);
        ArrayList<CFANode> aciNodes = new ArrayList<CFANode>(2);
        aciNodes.add(aciStartNode);
        aciNodes.add(aciEndNode);
        Truth.assertThat(this.aci.getStartAndEndNodes()).containsExactlyElementsIn(aciNodes);
    }

    @Test
    public void testGetInputVariables() {
        Truth.assertThat(this.aci.getInputVariables()).isEmpty();
        ArrayList<String> inputVariables = new ArrayList<String>(1);
        inputVariables.add("main::a");
        this.aci = new AppliedCustomInstruction(this.startNode, this.endNodes, inputVariables, (List<String>)ImmutableList.of(), inputVariables, Pair.of(ImmutableList.of(), ""), SSAMap.emptySSAMap());
        Truth.assertThat(this.aci.getInputVariables()).containsExactly(new Object[]{"main::a"});
    }

    @Test
    public void testGetOutputVariables() {
        Truth.assertThat(this.aci.getOutputVariables()).isEmpty();
        ArrayList<String> outputVariables = new ArrayList<String>(1);
        outputVariables.add("main::a");
        this.aci = new AppliedCustomInstruction(this.startNode, this.endNodes, (List<String>)ImmutableList.of(), outputVariables, (List<String>)ImmutableList.of(), Pair.of(ImmutableList.of(), ""), SSAMap.emptySSAMap());
        Truth.assertThat(this.aci.getOutputVariables()).containsExactly(new Object[]{"main::a"});
    }

    @Test
    public void testGetInputVariablesAndConstants() {
        Truth.assertThat(this.aci.getOutputVariables()).isEmpty();
        ArrayList<String> inputVarsAndConstants = new ArrayList<String>(2);
        inputVarsAndConstants.add("main::a");
        inputVarsAndConstants.add("1");
        this.aci = new AppliedCustomInstruction(this.startNode, this.endNodes, (List<String>)ImmutableList.of((Object)"main::a"), (List<String>)ImmutableList.of(), inputVarsAndConstants, Pair.of(ImmutableList.of(), ""), SSAMap.emptySSAMap());
        Truth.assertThat(this.aci.getInputVariablesAndConstants()).containsExactlyElementsIn(inputVarsAndConstants).inOrder();
    }
}

