/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.redundancyremover;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.cpa.sign.SIGN;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemoverIntervalStateImplementation;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemoverSignStateImplementation;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsValueAnalysisStateImplementation;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class RedundancyRemoverTest {
    private final MachineModel machineModel = MachineModel.LINUX32;

    @Test
    public void testCompareIntervalState() {
        RedundantRequirementsRemoverIntervalStateImplementation intervalStateImpl = new RedundantRequirementsRemoverIntervalStateImplementation();
        Interval i01 = Interval.UNBOUND;
        Interval i02 = Interval.UNBOUND;
        Truth.assertThat((Integer)intervalStateImpl.compare(i02, i01)).isEqualTo((Object)0);
        Truth.assertThat((Integer)intervalStateImpl.compare(i01, i02)).isEqualTo((Object)0);
        Interval i11 = new Interval(-5L, 8L);
        Interval i12 = new Interval(0L, 5L);
        Truth.assertThat((Integer)intervalStateImpl.compare(i11, i12)).isEqualTo((Object)1);
        Interval i21 = new Interval(-1L, 3L);
        Interval i22 = new Interval(-1L, 7L);
        Truth.assertThat((Integer)intervalStateImpl.compare(i21, i22)).isEqualTo((Object)-1);
        Interval i31 = new Interval(3L, 9L);
        Interval i32 = new Interval(5L, 7L);
        Truth.assertThat((Integer)intervalStateImpl.compare(i31, i32)).isEqualTo((Object)1);
    }

    @Test
    public void testCoversIntervalState() {
        RedundantRequirementsRemoverIntervalStateImplementation intervalStateImpl = new RedundantRequirementsRemoverIntervalStateImplementation();
        Interval i_35 = new Interval(-3L, 5L);
        Interval i01 = new Interval(0L, 1L);
        Truth.assertThat((Boolean)intervalStateImpl.covers(i_35, i01)).isTrue();
        Interval i11a = new Interval(1L, 1L);
        Interval i11b = new Interval(1L, 1L);
        Truth.assertThat((Boolean)intervalStateImpl.covers(i11a, i11b)).isTrue();
        Interval iUnbounded = Interval.UNBOUND;
        Interval i37 = new Interval(3L, 7L);
        Truth.assertThat((Boolean)intervalStateImpl.covers(iUnbounded, i37)).isTrue();
        Interval i_38 = new Interval(-3L, 8L);
        Truth.assertThat((Boolean)intervalStateImpl.covers(i_35, i_38)).isFalse();
        Interval i17 = new Interval(1L, 7L);
        Interval i_57 = new Interval(-5L, 7L);
        Truth.assertThat((Boolean)intervalStateImpl.covers(i17, i_57)).isFalse();
        Interval i03 = new Interval(0L, 3L);
        Interval i912 = new Interval(9L, 12L);
        Truth.assertThat((Boolean)intervalStateImpl.covers(i03, i912)).isFalse();
    }

    @Test
    public void testGetAbstractValueIntervalState() {
        IntervalAnalysisState intervalState1 = new IntervalAnalysisState().addInterval("1", new Interval(1L, 1L), 0);
        IntervalAnalysisState intervalState3 = new IntervalAnalysisState().addInterval("y", Interval.UNBOUND, 0);
        RedundantRequirementsRemoverIntervalStateImplementation intervalStateImpl = new RedundantRequirementsRemoverIntervalStateImplementation();
        Truth.assertThat((Object)intervalStateImpl.getAbstractValue(intervalState1, "1")).isEqualTo((Object)new Interval(1L, 1L));
        Truth.assertThat((Object)intervalStateImpl.getAbstractValue(intervalState3, "y")).isEqualTo((Object)Interval.UNBOUND);
    }

    @Test
    public void testCompareSignState() {
        RedundantRequirementsRemoverSignStateImplementation signImpl = new RedundantRequirementsRemoverSignStateImplementation();
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.EMPTY)).isEqualTo((Object)0);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.EMPTY)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.PLUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.EMPTY)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.MINUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.EMPTY)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.ZERO)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.EMPTY)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.PLUSMINUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.EMPTY)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.PLUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.EMPTY)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.MINUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.EMPTY)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.EMPTY, SIGN.ALL)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.PLUS)).isEqualTo((Object)0);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.PLUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.MINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.PLUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.ZERO)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.PLUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.PLUSMINUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.PLUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.PLUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.PLUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.MINUS0)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.PLUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS, SIGN.ALL)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.MINUS)).isEqualTo((Object)0);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.MINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.ZERO)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.MINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.PLUSMINUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.MINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.PLUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.MINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.MINUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.MINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS, SIGN.ALL)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.ZERO)).isEqualTo((Object)0);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.ZERO)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.PLUSMINUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.ZERO)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.PLUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.ZERO)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.MINUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.ZERO)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ZERO, SIGN.ALL)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.PLUSMINUS)).isEqualTo((Object)0);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.PLUSMINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.PLUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.PLUSMINUS)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.MINUS0)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.PLUSMINUS)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUSMINUS, SIGN.ALL)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.PLUS0)).isEqualTo((Object)0);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.PLUS0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.MINUS0)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.PLUS0)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.PLUS0, SIGN.ALL)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.MINUS0)).isEqualTo((Object)0);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.MINUS0)).isEqualTo((Object)1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.MINUS0, SIGN.ALL)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)signImpl.compare(SIGN.ALL, SIGN.ALL)).isEqualTo((Object)0);
    }

    @Test
    public void testCoversSignState() {
        RedundantRequirementsRemoverSignStateImplementation signImpl = new RedundantRequirementsRemoverSignStateImplementation();
        Truth.assertThat((Boolean)signImpl.covers(SIGN.PLUS, SIGN.MINUS)).isFalse();
        Truth.assertThat((Boolean)signImpl.covers(SIGN.PLUS0, SIGN.ZERO)).isTrue();
        Truth.assertThat((Boolean)signImpl.covers(SIGN.MINUS0, SIGN.PLUSMINUS)).isFalse();
        Truth.assertThat((Boolean)signImpl.covers(SIGN.ALL, SIGN.EMPTY)).isTrue();
    }

    @Test
    public void testGetAbstractValueSignState() {
        RedundantRequirementsRemoverSignStateImplementation signImpl = new RedundantRequirementsRemoverSignStateImplementation();
        SignState signState1 = SignState.TOP.assignSignToVariable("-1", SIGN.MINUS);
        SignState signState2 = SignState.TOP.assignSignToVariable("0", SIGN.ZERO);
        SignState signState3 = SignState.TOP.assignSignToVariable("1", SIGN.PLUS);
        SignState signState4 = SignState.TOP.assignSignToVariable("x", SIGN.PLUSMINUS);
        SignState signState5 = SignState.TOP.assignSignToVariable("y", SIGN.ALL);
        Truth.assertThat((Comparable)((Object)signImpl.getAbstractValue(signState1, "-1"))).isEqualTo((Object)SIGN.MINUS);
        Truth.assertThat((Comparable)((Object)signImpl.getAbstractValue(signState2, "0"))).isEqualTo((Object)SIGN.ZERO);
        Truth.assertThat((Comparable)((Object)signImpl.getAbstractValue(signState3, "1"))).isEqualTo((Object)SIGN.PLUS);
        Truth.assertThat((Comparable)((Object)signImpl.getAbstractValue(signState4, "x"))).isEqualTo((Object)SIGN.PLUSMINUS);
        Truth.assertThat((Comparable)((Object)signImpl.getAbstractValue(signState5, "y"))).isEqualTo((Object)SIGN.ALL);
    }

    @Test
    public void testCompareValueAnalysisState() {
        RedundantRequirementsValueAnalysisStateImplementation valueImpl = new RedundantRequirementsValueAnalysisStateImplementation();
        Value v11 = Value.UnknownValue.getInstance();
        Value v12 = Value.UnknownValue.getInstance();
        Truth.assertThat((Integer)valueImpl.compare(v11, v12)).isEqualTo((Object)0);
        v11 = Value.UnknownValue.getInstance();
        v12 = new NumericValue(-3);
        Truth.assertThat((Integer)valueImpl.compare(v12, v11)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)valueImpl.compare(v11, v12)).isEqualTo((Object)1);
        v11 = new NumericValue(7);
        v12 = new NumericValue(7);
        Truth.assertThat((Integer)valueImpl.compare(v11, v12)).isEqualTo((Object)0);
        v11 = new NumericValue(-5);
        v12 = new NumericValue(9);
        Truth.assertThat((Integer)valueImpl.compare(v12, v11)).isEqualTo((Object)14);
        Truth.assertThat((Integer)valueImpl.compare(v11, v12)).isEqualTo((Object)-14);
    }

    @Test
    public void testCoversValueAnalysisState() {
        RedundantRequirementsValueAnalysisStateImplementation valueImpl = new RedundantRequirementsValueAnalysisStateImplementation();
        Value v11 = Value.UnknownValue.getInstance();
        NumericValue v12 = new NumericValue(7);
        Truth.assertThat((Boolean)valueImpl.covers(v11, v12)).isTrue();
        v11 = new NumericValue(7);
        v12 = new NumericValue(7);
        Truth.assertThat((Boolean)valueImpl.covers(v11, v12)).isTrue();
        v11 = new NumericValue(7);
        v12 = new NumericValue(-4);
        Truth.assertThat((Boolean)valueImpl.covers(v11, v12)).isFalse();
    }

    @Test
    public void testGetAbstractValueValueAnalysisState() {
        RedundantRequirementsValueAnalysisStateImplementation valueImpl = new RedundantRequirementsValueAnalysisStateImplementation();
        ValueAnalysisState valState1 = new ValueAnalysisState(this.machineModel);
        NumericValue val1 = new NumericValue(1L);
        valState1.assignConstant(MemoryLocation.forIdentifier("1"), (Value)val1, CNumericTypes.INT);
        ValueAnalysisState valState2 = new ValueAnalysisState(this.machineModel);
        NumericValue val2 = new NumericValue(7L);
        valState2.assignConstant(MemoryLocation.forIdentifier("x"), (Value)val2, CNumericTypes.INT);
        Truth.assertThat((Object)valueImpl.getAbstractValue(valState2, "x")).isEqualTo((Object)val2);
        ValueAnalysisState valState3 = new ValueAnalysisState(this.machineModel);
        Value.UnknownValue val3 = Value.UnknownValue.getInstance();
        valState3.assignConstant(MemoryLocation.forIdentifier("y"), (Value)val3, CNumericTypes.INT);
        Truth.assertThat((Object)valueImpl.getAbstractValue(valState3, "y")).isEqualTo((Object)val3);
    }

    @Test
    public void testIdentifyAndRemoveRedundantRequirements() {
    }
}

