/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.redundancyremover;

import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemoverIntervalStateImplementation;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemoverSignStateImplementation;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsValueAnalysisStateImplementation;

public class RedundantRequirementsRemover {
    public static List<Pair<ARGState, Collection<ARGState>>> removeRedundantRequirements(List<Pair<ARGState, Collection<ARGState>>> requirements, List<Pair<List<String>, List<String>>> inputOutputSignatures, Class<? extends AbstractState> reqStateClass) {
        RedundantRequirementsRemoverImplementation remover;
        if (reqStateClass.equals(ValueAnalysisState.class)) {
            remover = new RedundantRequirementsValueAnalysisStateImplementation();
        } else if (reqStateClass.equals(IntervalAnalysisState.class)) {
            remover = new RedundantRequirementsRemoverIntervalStateImplementation();
        } else if (reqStateClass.equals(SignState.class)) {
            remover = new RedundantRequirementsRemoverSignStateImplementation();
        } else {
            return requirements;
        }
        return remover.identifyAndRemoveRedundantRequirements(requirements, inputOutputSignatures);
    }

    public static abstract class RedundantRequirementsRemoverImplementation<S extends AbstractState, V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 2610823786116954949L;
        private SortingArrayHelper sortHelper = new SortingArrayHelper();

        protected abstract boolean covers(V var1, V var2);

        protected abstract V getAbstractValue(S var1, String var2);

        protected abstract V[] emptyArrayOfSize(int var1);

        protected abstract V[][] emptyMatrixOfSize(int var1);

        protected abstract S extractState(AbstractState var1);

        private V[] getAbstractValues(S abstractState, List<String> varsAndConsts) {
            V[] result = this.emptyArrayOfSize(varsAndConsts.size());
            int i = 0;
            for (String varOrConst : varsAndConsts) {
                result[i++] = this.getAbstractValue(abstractState, varOrConst);
            }
            return result;
        }

        private V[][] getAbstractValuesForSignature(ARGState start, Collection<ARGState> ends, List<String> inputVarsAndConsts) throws CPAException {
            V[][] result = this.emptyMatrixOfSize(1 + ends.size());
            result[0] = this.getAbstractValues(this.extractState(start), inputVarsAndConsts);
            int i = 1;
            CFANode loc = null;
            for (ARGState end : ends) {
                if (loc == null) {
                    loc = AbstractStates.extractLocation(end);
                } else if (!loc.equals(AbstractStates.extractLocation(end))) {
                    throw new CPAException("");
                }
                result[i] = this.getAbstractValues(this.extractState(end), inputVarsAndConsts);
                ++i;
            }
            Arrays.sort(result, 1, ends.size() + 1, this.sortHelper);
            return result;
        }

        private boolean covers(V[] covering, V[] covered) {
            if (covering.length == covered.length) {
                for (int i = 0; i < covering.length; ++i) {
                    if (!this.covers(covering[i], covered[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean covers(V[][] covering, V[][] covered) {
            if (this.covers(covering[0], covered[0])) {
                for (int i = 1; i < covering.length; ++i) {
                    boolean isCovered = false;
                    for (int j = 1; j < covered.length; ++j) {
                        if (!this.covers(covered[j], covering[i])) continue;
                        isCovered = true;
                        break;
                    }
                    if (isCovered) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public List<Pair<ARGState, Collection<ARGState>>> identifyAndRemoveRedundantRequirements(List<Pair<ARGState, Collection<ARGState>>> requirements, List<Pair<List<String>, List<String>>> inputOutputSignatures) {
            assert (requirements.size() == inputOutputSignatures.size());
            ArrayList<Pair<V[][], Pair<ARGState, Collection<ARGState>>>> sortList = new ArrayList<Pair<V[][], Pair<ARGState, Collection<ARGState>>>>(requirements.size());
            try {
                for (int i = 0; i < requirements.size(); ++i) {
                    sortList.add(Pair.of(this.getAbstractValuesForSignature(requirements.get(i).getFirst(), requirements.get(i).getSecond(), inputOutputSignatures.get(i).getFirst()), requirements.get(i)));
                }
                sortList.sort(new SortingHelper());
                ArrayList<Pair<ARGState, Collection<ARGState>>> reducedReq = new ArrayList<Pair<ARGState, Collection<ARGState>>>(sortList.size());
                block3: for (int i = 0; i < sortList.size(); ++i) {
                    for (int j = 0; j < i; ++j) {
                        if (this.covers((Object[][])((Pair)sortList.get(j)).getFirst(), (Object[][])((Pair)sortList.get(i)).getFirst())) continue block3;
                    }
                    reducedReq.add((Pair)((Pair)sortList.get(i)).getSecond());
                }
                return reducedReq;
            }
            catch (CPAException e) {
                return requirements;
            }
        }

        @SuppressFBWarnings(value={"SE_INNER_CLASS"}, justification="Cannot make class static as suggested because require generic type parameters of outer class. Removing interface Serializable is also no option because it introduces another warning suggesting to implement Serializable interface.")
        private class SortingHelper
        implements Comparator<Pair<V[][], Pair<ARGState, Collection<ARGState>>>>,
        Serializable {
            private static final long serialVersionUID = 3894486288294859800L;

            private SortingHelper() {
            }

            @Override
            public int compare(Pair<V[][], Pair<ARGState, Collection<ARGState>>> arg0, Pair<V[][], Pair<ARGState, Collection<ARGState>>> arg1) {
                if (arg0 == null || arg1 == null) {
                    throw new NullPointerException();
                }
                V[][] firstArg = arg0.getFirst();
                V[][] secondArg = arg1.getFirst();
                if (firstArg == null || secondArg == null) {
                    return firstArg == null ? 1 : 0 + (secondArg == null ? -1 : 0);
                }
                if (firstArg.length == 0 || secondArg.length == 0) {
                    return -(firstArg.length - secondArg.length);
                }
                if (firstArg[0].length != secondArg[0].length) {
                    return Integer.compare(secondArg[0].length, firstArg[0].length);
                }
                int r = RedundantRequirementsRemoverImplementation.this.sortHelper.compare(secondArg[0], firstArg[0]);
                if (r != 0) {
                    return r;
                }
                if (firstArg.length != secondArg.length) {
                    return Integer.compare(secondArg.length, firstArg.length);
                }
                return Comparators.lexicographical((Comparator)RedundantRequirementsRemoverImplementation.this.sortHelper).compare(Arrays.asList(firstArg).subList(1, firstArg.length), Arrays.asList(secondArg).subList(1, secondArg.length));
            }
        }

        @SuppressFBWarnings(value={"SE_INNER_CLASS"}, justification="Cannot make class static as suggested because require generic type parameters of outer class. Removing interface Serializable is also no option because it introduces another warning suggesting to implement Serializable interface.")
        private class SortingArrayHelper
        implements Comparator<V[]>,
        Serializable {
            private static final long serialVersionUID = 3970718511743910013L;

            private SortingArrayHelper() {
            }

            @Override
            public int compare(V[] arg0, V[] arg1) {
                Preconditions.checkNotNull(arg0);
                Preconditions.checkNotNull(arg1);
                if (arg0.length == 0 || arg1.length == 0) {
                    return Integer.compare(arg1.length, arg0.length);
                }
                return Comparators.lexicographical((Comparator)RedundantRequirementsRemoverImplementation.this).compare(Arrays.asList(arg0), Arrays.asList(arg1));
            }
        }
    }
}

