/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.redundancyremover;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemover;

public class RedundantRequirementsRemoverIntervalStateImplementation
extends RedundantRequirementsRemover.RedundantRequirementsRemoverImplementation<IntervalAnalysisState, Interval> {
    private static final long serialVersionUID = 1323131138350817689L;

    @Override
    public int compare(Interval pO1, Interval pO2) {
        if (pO1 == null || pO2 == null) {
            throw new NullPointerException("At least one of the arguments " + pO1 + " or " + pO2 + " is null.");
        }
        if (pO1.getLow().equals(pO2.getLow()) && pO1.getHigh().equals(pO2.getHigh())) {
            return 0;
        }
        if (pO2.contains(pO1)) {
            return -1;
        }
        if (pO1.contains(pO2)) {
            return 1;
        }
        if (pO1.getLow().compareTo(pO2.getLow()) < 0) {
            return -1;
        }
        if (pO1.getLow().equals(pO2.getLow()) && pO1.getHigh().compareTo(pO2.getHigh()) < 0) {
            return -1;
        }
        return 1;
    }

    @Override
    protected boolean covers(Interval pCovering, Interval pCovered) {
        return pCovering.contains(pCovered);
    }

    @Override
    protected Interval getAbstractValue(IntervalAnalysisState pAbstractState, String pVarOrConst) {
        try {
            long constant = Long.parseLong(pVarOrConst);
            return new Interval(constant, constant);
        }
        catch (NumberFormatException e) {
            if (pAbstractState.contains(pVarOrConst)) {
                return pAbstractState.getInterval(pVarOrConst);
            }
            return Interval.UNBOUND;
        }
    }

    protected Interval[] emptyArrayOfSize(int pSize) {
        return new Interval[Math.max(0, pSize)];
    }

    protected Interval[][] emptyMatrixOfSize(int pSize) {
        return new Interval[Math.max(0, pSize)][];
    }

    @Override
    protected IntervalAnalysisState extractState(AbstractState pWrapperState) {
        return AbstractStates.extractStateByType(pWrapperState, IntervalAnalysisState.class);
    }
}

