/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.redundancyremover;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.sign.SIGN;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemover;

public class RedundantRequirementsRemoverSignStateImplementation
extends RedundantRequirementsRemover.RedundantRequirementsRemoverImplementation<SignState, SIGN> {
    private static final long serialVersionUID = 7689875020110766102L;

    @Override
    public int compare(SIGN pO1, SIGN pO2) {
        if (pO1 == null || pO2 == null) {
            throw new NullPointerException("At least one of the arguments " + pO1 + " or " + pO2 + " is null.");
        }
        if (pO1.equals(pO2)) {
            return 0;
        }
        if (pO2.covers(pO1)) {
            return -1;
        }
        if (pO1.covers(pO2)) {
            return 1;
        }
        if (pO1 == SIGN.MINUS && (pO2 == SIGN.ZERO || pO2 == SIGN.PLUS || pO2 == SIGN.PLUS0)) {
            return -1;
        }
        if (pO1 == SIGN.ZERO && (pO2 == SIGN.PLUS || pO2 == SIGN.PLUSMINUS)) {
            return -1;
        }
        if (pO1 == SIGN.PLUSMINUS && pO2 == SIGN.PLUS0) {
            return -1;
        }
        if (pO1 == SIGN.MINUS0 && (pO2 == SIGN.PLUS || pO2 == SIGN.PLUS0 || pO2 == SIGN.PLUSMINUS)) {
            return -1;
        }
        return 1;
    }

    @Override
    protected boolean covers(SIGN pCovering, SIGN pCovered) {
        return pCovering.covers(pCovered);
    }

    @Override
    protected SIGN getAbstractValue(SignState pAbstractState, String pVarOrConst) {
        try {
            double constant = Double.parseDouble(pVarOrConst);
            if (constant < 0.0) {
                return SIGN.MINUS;
            }
            if (constant == 0.0) {
                return SIGN.ZERO;
            }
            if (constant > 0.0) {
                return SIGN.PLUS;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pAbstractState.getSignForVariable(pVarOrConst);
    }

    protected SIGN[] emptyArrayOfSize(int pSize) {
        return new SIGN[pSize];
    }

    protected SIGN[][] emptyMatrixOfSize(int pSize) {
        return new SIGN[pSize][];
    }

    @Override
    protected SignState extractState(AbstractState pWrapperState) {
        return AbstractStates.extractStateByType(pWrapperState, SignState.class);
    }
}

