/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.redundancyremover;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.ArrayValue;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.EnumConstantValue;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.ci.redundancyremover.RedundantRequirementsRemover;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class RedundantRequirementsValueAnalysisStateImplementation
extends RedundantRequirementsRemover.RedundantRequirementsRemoverImplementation<ValueAnalysisState, Value> {
    private static final long serialVersionUID = 2875464105471673418L;

    @Override
    public int compare(Value pO1, Value pO2) {
        if (pO1 == null || pO2 == null) {
            throw new NullPointerException("At least one of the arguments " + pO1 + " or " + pO2 + " is null.");
        }
        if (pO1 instanceof ArrayValue || pO2 instanceof ArrayValue || pO1 instanceof BooleanValue || pO2 instanceof BooleanValue || pO1 instanceof EnumConstantValue || pO2 instanceof EnumConstantValue || pO1 instanceof NullValue || pO2 instanceof NullValue) {
            throw new ClassCastException("Expected NumericValue.");
        }
        if (pO1.isUnknown() && pO2.isUnknown()) {
            return 0;
        }
        if (pO2.isUnknown()) {
            return -1;
        }
        if (pO1.isUnknown()) {
            return 1;
        }
        return (int)(pO1.asNumericValue().getNumber().doubleValue() - pO2.asNumericValue().getNumber().doubleValue());
    }

    @Override
    protected boolean covers(Value pCovering, Value pCovered) {
        return pCovering.isUnknown() || pCovering.equals(pCovered);
    }

    @Override
    protected Value getAbstractValue(ValueAnalysisState pAbstractState, String pVarOrConst) {
        try {
            int constant = Integer.parseInt(pVarOrConst);
            return new NumericValue(constant);
        }
        catch (NumberFormatException e) {
            MemoryLocation memLoc = MemoryLocation.parseExtendedQualifiedName(pVarOrConst);
            if (pAbstractState.contains(memLoc)) {
                return pAbstractState.getValueFor(memLoc);
            }
            return Value.UnknownValue.getInstance();
        }
    }

    protected Value[] emptyArrayOfSize(int pSize) {
        return new Value[pSize];
    }

    protected Value[][] emptyMatrixOfSize(int pSize) {
        return new Value[pSize][];
    }

    @Override
    protected ValueAnalysisState extractState(AbstractState pWrapperState) {
        return AbstractStates.extractStateByType(pWrapperState, ValueAnalysisState.class);
    }
}

