/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public abstract class AbstractRequirementsTranslator<T extends AbstractState> {
    private final Class<T> abstractStateClass;

    protected AbstractRequirementsTranslator(Class<T> pAbstractStateClass) {
        this.abstractStateClass = pAbstractStateClass;
    }

    protected T extractRequirement(AbstractState pState) {
        return AbstractStates.extractStateByType(pState, this.abstractStateClass);
    }

    protected Collection<T> extractRequirements(Collection<AbstractState> pStates) {
        ArrayList<T> requirements = new ArrayList<T>(pStates.size());
        for (AbstractState state : pStates) {
            requirements.add(this.extractRequirement(state));
        }
        return requirements;
    }

    protected abstract Pair<List<String>, String> convertToFormula(T var1, SSAMap var2, @Nullable Collection<String> var3) throws CPAException;

    public Pair<Pair<List<String>, String>, Pair<List<String>, String>> convertRequirements(AbstractState pre, Collection<? extends AbstractState> post, SSAMap postIndices, @Nullable Collection<String> pInputVariables, @Nullable Collection<String> pOutputVariables) throws CPAException {
        Pair<List<String>, String> formulaPre = this.convertToFormula(this.extractRequirement(pre), SSAMap.emptySSAMap(), pInputVariables);
        formulaPre = Pair.of(formulaPre.getFirst(), AbstractRequirementsTranslator.renameDefine(formulaPre.getSecond(), "pre"));
        if (post.isEmpty()) {
            return Pair.of(formulaPre, Pair.of(ImmutableList.of(), "(define-fun post () Bool false)"));
        }
        ArrayList list = new ArrayList();
        StringBuilder sb = new StringBuilder();
        int BracketCounter = 0;
        int amount = post.size();
        sb.append("(define-fun post () Bool ");
        for (AbstractState abstractState : post) {
            int index;
            Pair<List<String>, String> formula = this.convertToFormula(this.extractRequirement(abstractState), postIndices, pOutputVariables);
            list.addAll(formula.getFirst());
            if (BracketCounter != amount - 1) {
                sb.append("(or ");
                ++BracketCounter;
            }
            String definition = (index = formula.getSecond().indexOf("(", formula.getSecond().indexOf(")"))) > 0 ? formula.getSecond().substring(index, formula.getSecond().length() - 1) : formula.getSecond().substring(formula.getSecond().lastIndexOf(" "), formula.getSecond().length() - 1);
            sb.append(definition);
        }
        for (int i = 0; i < BracketCounter + 1; ++i) {
            sb.append(")");
        }
        return Pair.of(formulaPre, Pair.of(list, sb.toString()));
    }

    public static String renameDefine(String define, String newName) {
        int start = define.indexOf(" ") + 1;
        int end = define.indexOf(" ", start);
        return define.substring(0, start) + newName + define.substring(end);
    }
}

