/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import apron.Coeff;
import apron.DoubleScalar;
import apron.MpfrScalar;
import apron.MpqScalar;
import apron.Scalar;
import apron.Tcons0;
import apron.Texpr0BinNode;
import apron.Texpr0CstNode;
import apron.Texpr0DimNode;
import apron.Texpr0Node;
import apron.Texpr0UnNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.translators.CartesianRequirementsTranslator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ApronRequirementsTranslator
extends CartesianRequirementsTranslator<ApronState> {
    private Pair<ApronState, Collection<String>> stateToRequiredVars;

    public ApronRequirementsTranslator(Class<ApronState> pAbstractStateClass, LogManager pLog) {
        super(pAbstractStateClass, pLog);
    }

    @Override
    protected List<String> getVarsInRequirements(ApronState pRequirement) {
        Collection<String> result = this.getAllVarsUsed(pRequirement);
        this.stateToRequiredVars = Pair.of(pRequirement, result);
        return new ArrayList<String>(result);
    }

    @Override
    protected List<String> getVarsInRequirements(ApronState pRequirement, @Nullable Collection<String> pRequiredVars) {
        if (pRequiredVars == null) {
            return this.getVarsInRequirements(pRequirement);
        }
        Collection<String> result = this.getConvexHullRequiredVars(pRequirement, pRequiredVars);
        this.stateToRequiredVars = Pair.of(pRequirement, result);
        return new ArrayList<String>(result);
    }

    @Override
    protected List<String> getListOfIndependentRequirements(ApronState pRequirement, SSAMap pIndices, @Nullable Collection<String> pRequiredVars) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> varNames = this.getAllVarNames(pRequirement);
        Collection<String> requiredVarNames = null;
        if (pRequiredVars != null) {
            requiredVarNames = this.getConvexHullRequiredVars(pRequirement, pRequiredVars);
        } else {
            if (this.stateToRequiredVars != null) {
                requiredVarNames = this.stateToRequiredVars.getSecond();
                if (this.stateToRequiredVars.getFirst() != pRequirement) {
                    requiredVarNames = null;
                }
            }
            if (requiredVarNames == null) {
                requiredVarNames = this.getAllVarsUsed(pRequirement);
            }
        }
        for (Tcons0 constraint : pRequirement.getApronNativeState().toTcons(pRequirement.getManager().getManager())) {
            String converted = this.convertConstraintToFormula(constraint, varNames, pIndices, requiredVarNames);
            if (converted == null) continue;
            result.add(converted);
        }
        return result;
    }

    private List<String> getAllVarNames(ApronState pRequirement) {
        ArrayList<String> result = new ArrayList<String>(pRequirement.getIntegerVariableToIndexMap().size() + pRequirement.getRealVariableToIndexMap().size());
        for (MemoryLocation mem : pRequirement.getIntegerVariableToIndexMap()) {
            result.add(mem.getExtendedQualifiedName());
        }
        for (MemoryLocation mem : pRequirement.getRealVariableToIndexMap()) {
            result.add(mem.getExtendedQualifiedName());
        }
        return result;
    }

    private Collection<String> getConvexHullRequiredVars(ApronState pRequirement, Collection<String> requiredVars) {
        Preconditions.checkNotNull(requiredVars);
        HashSet<String> required = new HashSet<String>(requiredVars);
        List<String> varNames = this.getAllVarNames(pRequirement);
        Tcons0[] constraints = pRequirement.getApronNativeState().toTcons(pRequirement.getManager().getManager());
        ArrayList<Set<String>> constraintVars = new ArrayList<Set<String>>(constraints.length);
        for (Tcons0 constraint : constraints) {
            constraintVars.add(this.getVarsInConstraint(constraint, varNames));
        }
        Iterator it = constraintVars.iterator();
        while (it.hasNext()) {
            Set intermediate = (Set)it.next();
            if (Sets.intersection(required, (Set)intermediate).isEmpty() || !required.addAll(intermediate)) continue;
            it = constraintVars.iterator();
        }
        return required;
    }

    private Collection<String> getAllVarsUsed(ApronState pRequirement) {
        List<String> varNames = this.getAllVarNames(pRequirement);
        Tcons0[] constraints = pRequirement.getApronNativeState().toTcons(pRequirement.getManager().getManager());
        HashSet<String> constraintVars = new HashSet<String>(constraints.length);
        for (Tcons0 constraint : constraints) {
            constraintVars.addAll(this.getVarsInConstraint(constraint, varNames));
        }
        return new ArrayList<String>(constraintVars);
    }

    private Set<String> getVarsInConstraint(Tcons0 constraint, List<String> varNames) {
        HashSet vars = Sets.newHashSetWithExpectedSize((int)constraint.getSize());
        ArrayDeque<Texpr0Node> stack = new ArrayDeque<Texpr0Node>();
        stack.push(constraint.getExpression().toTexpr0Node());
        while (!stack.isEmpty()) {
            Texpr0Node current = (Texpr0Node)stack.pop();
            if (current instanceof Texpr0BinNode) {
                stack.push(((Texpr0BinNode)current).getLeftArgument());
                stack.push(((Texpr0BinNode)current).getRightArgument());
                continue;
            }
            if (current instanceof Texpr0UnNode) {
                stack.push(((Texpr0UnNode)current).getArgument());
                continue;
            }
            if (!(current instanceof Texpr0DimNode)) continue;
            vars.add(varNames.get(((Texpr0DimNode)current).dim));
        }
        return vars;
    }

    private @Nullable String convertConstraintToFormula(Tcons0 constraint, List<String> varNames, SSAMap map, Collection<String> varsConsidered) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        switch (constraint.kind) {
            case 0: {
                sb.append("=");
                break;
            }
            case 1: {
                sb.append(">=");
                break;
            }
            case 2: {
                sb.append(">");
                break;
            }
            case 4: {
                sb.append("not (=");
                break;
            }
            case 3: {
                sb.append("= (mod");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        String left = this.convertLeftConstraintPartToFormula(constraint, varNames, map, varsConsidered);
        if (left == null) {
            return null;
        }
        sb.append(left);
        if (constraint.kind == 3) {
            sb.append(" ");
            sb.append(this.getIntegerValFromScalar(constraint.getScalar()));
            sb.append(")");
        }
        sb.append(" 0)");
        if (constraint.kind == 4) {
            sb.append(")");
        }
        return sb.toString();
    }

    private String getIntegerValFromScalar(Scalar pCst) {
        double value;
        if (pCst instanceof DoubleScalar) {
            value = ((DoubleScalar)pCst).get();
        } else if (pCst instanceof MpfrScalar) {
            value = ((MpfrScalar)pCst).get().doubleValue(0);
        } else {
            assert (pCst instanceof MpqScalar);
            value = ((MpqScalar)pCst).get().doubleValue();
        }
        if (DoubleMath.isMathematicalInteger((double)value)) {
            return String.valueOf((int)value);
        }
        throw new AssertionError((Object)"Cannot deal with this non-integer scalar");
    }

    private @Nullable String convertLeftConstraintPartToFormula(Tcons0 constraint, List<String> varNames, SSAMap map, Collection<String> varsConsidered) {
        boolean toConsider = false;
        StringBuilder sb = new StringBuilder();
        ArrayDeque<Pair<Texpr0Node, Integer>> stack = new ArrayDeque<Pair<Texpr0Node, Integer>>();
        stack.push(Pair.of(constraint.toTexpr0Node(), 0));
        while (!stack.isEmpty()) {
            Pair currentPair = (Pair)stack.pop();
            Texpr0Node current = (Texpr0Node)currentPair.getFirst();
            if (current instanceof Texpr0BinNode) {
                sb.append(" (");
                switch (((Texpr0BinNode)current).getOperation()) {
                    case 0: {
                        sb.append("+");
                        break;
                    }
                    case 1: {
                        sb.append("-");
                        break;
                    }
                    case 2: {
                        sb.append("*");
                        break;
                    }
                    case 3: {
                        sb.append("/");
                        break;
                    }
                    case 4: {
                        sb.append("mod");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unsupported binary operator.");
                    }
                }
                stack.push(Pair.of(((Texpr0BinNode)current).getRightArgument(), (Integer)currentPair.getSecond() + 1));
                stack.push(Pair.of(((Texpr0BinNode)current).getLeftArgument(), 0));
                continue;
            }
            if (current instanceof Texpr0UnNode) {
                switch (((Texpr0UnNode)current).getOperation()) {
                    case 6: {
                        sb.append(" (-");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unsupported unary operator.");
                    }
                }
                stack.push(Pair.of(((Texpr0UnNode)current).getArgument(), (Integer)currentPair.getSecond() + 1));
                continue;
            }
            if (current instanceof Texpr0DimNode) {
                String variableName = varNames.get(((Texpr0DimNode)current).dim);
                if (varsConsidered.contains(variableName)) {
                    toConsider = true;
                }
                sb.append(" ");
                sb.append(ApronRequirementsTranslator.getVarWithIndex(variableName, map));
            } else if (current instanceof Texpr0CstNode) {
                Coeff cst = ((Texpr0CstNode)current).getConstant();
                if (cst.isScalar()) {
                    sb.append(" ");
                    sb.append(this.getIntegerValFromScalar((Scalar)cst));
                } else {
                    throw new AssertionError((Object)"Cannot handle coefficient");
                }
            }
            this.addClosingRoundBrackets(sb, (Integer)currentPair.getSecond());
        }
        return toConsider ? sb.toString() : null;
    }

    private void addClosingRoundBrackets(StringBuilder sb, int number) {
        for (int i = 0; i < number; ++i) {
            sb.append(")");
        }
    }
}

