/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.CIUtils;
import org.sosy_lab.cpachecker.util.ci.translators.AbstractRequirementsTranslator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public abstract class CartesianRequirementsTranslator<T extends AbstractState>
extends AbstractRequirementsTranslator<T> {
    protected final LogManager logger;

    protected CartesianRequirementsTranslator(Class<T> pAbstractStateClass, LogManager log) {
        super(pAbstractStateClass);
        this.logger = log;
    }

    @VisibleForTesting
    static List<String> writeVarDefinition(List<String> vars, SSAMap ssaMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (String var : vars) {
            String def = "(declare-fun " + CartesianRequirementsTranslator.getVarWithIndex(var, ssaMap);
            def = def + " () Int)";
            list.add(def);
        }
        return list;
    }

    protected abstract List<String> getVarsInRequirements(T var1);

    protected List<String> getVarsInRequirements(T requirement, @Nullable Collection<String> pRequiredVars) {
        ArrayList<String> list = new ArrayList<String>();
        for (String var : this.getVarsInRequirements(requirement)) {
            if (pRequiredVars != null && !pRequiredVars.contains(var)) continue;
            list.add(var);
        }
        return list;
    }

    @Override
    protected Pair<List<String>, String> convertToFormula(T requirement, SSAMap indices, @Nullable Collection<String> pRequiredVars) {
        List<String> firstReturn = CartesianRequirementsTranslator.writeVarDefinition(this.getVarsInRequirements(requirement, pRequiredVars), indices);
        List<String> listOfIndependentRequirements = this.getListOfIndependentRequirements(requirement, indices, pRequiredVars);
        Object secReturn = listOfIndependentRequirements.isEmpty() ? "true" : (listOfIndependentRequirements.size() == 1 ? listOfIndependentRequirements.get(0) : this.computeConjunction(listOfIndependentRequirements));
        secReturn = "(define-fun req () Bool " + (String)secReturn + ")";
        return Pair.of(firstReturn, secReturn);
    }

    private String computeConjunction(List<String> list) {
        StringBuilder sb = new StringBuilder();
        int BracketCounter = 0;
        if (list.isEmpty()) {
            return "true";
        }
        String last = list.get(list.size() - 1);
        for (String var : list) {
            if (var.equals(last)) {
                sb.append(var);
                continue;
            }
            sb.append("(and ");
            sb.append(var);
            ++BracketCounter;
        }
        for (int i = 0; i < BracketCounter; ++i) {
            sb.append(")");
        }
        return sb.toString();
    }

    protected abstract List<String> getListOfIndependentRequirements(T var1, SSAMap var2, @Nullable Collection<String> var3);

    public static String getVarWithIndex(String var, SSAMap indices) {
        assert (indices != null);
        assert (var != null);
        int index = indices.getIndex(var);
        if (index == -1) {
            return CIUtils.getSMTName(var);
        }
        return CIUtils.getSMTName(var + "@" + index);
    }
}

