/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.util.ci.translators.CartesianRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.TranslatorsUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class IntervalRequirementsTranslator
extends CartesianRequirementsTranslator<IntervalAnalysisState> {
    public IntervalRequirementsTranslator(LogManager pLog) {
        super(IntervalAnalysisState.class, pLog);
    }

    @Override
    protected List<String> getVarsInRequirements(IntervalAnalysisState pRequirement) {
        return new ArrayList<String>(pRequirement.getIntervalMap().keySet());
    }

    @Override
    protected List<String> getListOfIndependentRequirements(IntervalAnalysisState pRequirement, SSAMap pIndices, @Nullable Collection<String> pRequiredVars) {
        ArrayList<String> list = new ArrayList<String>();
        for (String var : pRequirement.getIntervalMap().keySet()) {
            if (pRequiredVars != null && !pRequiredVars.contains(var)) continue;
            list.add(this.getRequirement(IntervalRequirementsTranslator.getVarWithIndex(var, pIndices), pRequirement.getInterval(var)));
        }
        return list;
    }

    private String getRequirement(String var, Interval interval) {
        StringBuilder sb = new StringBuilder();
        boolean isMin = interval.getLow() == Long.MIN_VALUE;
        boolean isMax = interval.getHigh() == Long.MAX_VALUE;
        Preconditions.checkArgument((!isMin || !isMax ? 1 : 0) != 0);
        Preconditions.checkArgument((!interval.isEmpty() ? 1 : 0) != 0);
        if (!isMin && !isMax) {
            sb.append(TranslatorsUtils.getVarInBoundsRequirement(var, interval.getLow(), interval.getHigh()));
        } else if (!isMin) {
            sb.append(TranslatorsUtils.getVarGreaterOrEqualValRequirement(var, interval.getLow()));
        } else if (!isMax) {
            sb.append(TranslatorsUtils.getVarLessOrEqualValRequirement(var, interval.getHigh()));
        }
        return sb.toString();
    }
}

