/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonInterval;
import org.sosy_lab.cpachecker.util.ci.translators.CartesianRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.TranslatorsUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class OctagonRequirementsTranslator
extends CartesianRequirementsTranslator<OctagonState> {
    public OctagonRequirementsTranslator(Class<OctagonState> pAbstractStateClass, LogManager pLog) {
        super(pAbstractStateClass, pLog);
    }

    @Override
    protected List<String> getVarsInRequirements(OctagonState pRequirement) {
        ArrayList<String> list = new ArrayList<String>();
        for (MemoryLocation key : pRequirement.getVariablesWithBounds().keySet()) {
            list.add(key.getExtendedQualifiedName());
        }
        return list;
    }

    @Override
    protected List<String> getVarsInRequirements(OctagonState pRequirement, @Nullable Collection<String> pRequiredVars) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<MemoryLocation, OctagonInterval> entry : pRequirement.getVariablesWithBounds().entrySet()) {
            String var = entry.getKey().getExtendedQualifiedName();
            if (entry.getValue().isEmpty() && pRequiredVars != null && !pRequiredVars.contains(var)) continue;
            list.add(var);
        }
        return list;
    }

    @Override
    protected List<String> getListOfIndependentRequirements(OctagonState pRequirement, SSAMap pIndices, @Nullable Collection<String> pRequiredVars) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<MemoryLocation, OctagonInterval> entry : pRequirement.getVariablesWithBounds().entrySet()) {
            String var = entry.getKey().getExtendedQualifiedName();
            if (entry.getValue().isEmpty() && pRequiredVars != null && !pRequiredVars.contains(var)) continue;
            list.add(this.getRequirement(OctagonRequirementsTranslator.getVarWithIndex(var, pIndices), entry.getValue()));
        }
        return list;
    }

    private String getRequirement(String pVar, OctagonInterval pVals) {
        if (pVals.getLow() == null) {
            return TranslatorsUtils.getVarLessOrEqualValRequirement(pVar, pVals.getHigh().getValue());
        }
        if (pVals.getHigh() == null) {
            return TranslatorsUtils.getVarGreaterOrEqualValRequirement(pVar, pVals.getLow().getValue());
        }
        return TranslatorsUtils.getVarInBoundsRequirement(pVar, pVals.getLow().getValue(), pVals.getHigh().getValue());
    }
}

