/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.translators.AbstractRequirementsTranslator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class PredicateRequirementsTranslator
extends AbstractRequirementsTranslator<PredicateAbstractState> {
    private final FormulaManagerView fmgr;
    private int counter;

    public PredicateRequirementsTranslator(FormulaManagerView pFmgr) {
        super(PredicateAbstractState.class);
        this.fmgr = pFmgr;
        this.counter = 0;
    }

    @Override
    protected Pair<List<String>, String> convertToFormula(PredicateAbstractState pRequirement, SSAMap pIndices, @Nullable Collection<String> pRequiredVars) throws CPAException {
        if (!pRequirement.isAbstractionState()) {
            throw new CPAException("The PredicateAbstractState " + pRequirement + " is not an abstractionState. Ensure that property cpa.predicate.blk.alwaysAtExplicitNodes is set to true");
        }
        BooleanFormula formulaBool = pRequiredVars == null ? this.fmgr.instantiate(pRequirement.getAbstractionFormula().asFormula(), pIndices) : this.fmgr.instantiate(this.removeUnnecessaryClauses(pRequirement.getAbstractionFormula().asFormula(), this.getRelevantVariables(pRequirement.getAbstractionFormula().asFormula(), pRequiredVars)), pIndices);
        Pair<String, List<String>> pair = PredicatePersistenceUtils.splitFormula(this.fmgr, formulaBool);
        ArrayList list = new ArrayList(pair.getSecond());
        ArrayList<String> removeFromList = new ArrayList<String>();
        for (String stmt : list) {
            if (stmt.startsWith("(declare") || stmt.startsWith("(define")) continue;
            removeFromList.add(stmt);
        }
        list.removeAll(removeFromList);
        String element = pair.getFirst();
        element = element.substring(element.indexOf(116) + 1, element.length() - 1);
        String secReturn = "(define-fun .defci" + this.counter++ + " () Bool " + element + ")";
        return Pair.of(list, secReturn);
    }

    private Set<String> getRelevantVariables(BooleanFormula f, Collection<String> pRequiredVars) {
        HashMap varDependentOn = new HashMap();
        for (BooleanFormula atom : this.fmgr.extractAtoms(f, false)) {
            Set<String> vars = this.fmgr.extractVariableNames((Formula)atom);
            for (String var : vars) {
                if (!varDependentOn.containsKey(var)) {
                    varDependentOn.put(var, new HashSet());
                }
                ((Collection)varDependentOn.get(var)).addAll(vars);
            }
        }
        HashSet<String> relevantVars = new HashSet<String>(pRequiredVars);
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Map.Entry dep : varDependentOn.entrySet()) {
                if (!relevantVars.contains(dep.getKey()) || !relevantVars.addAll((Collection)dep.getValue())) continue;
                changed = true;
            }
        }
        return relevantVars;
    }

    private BooleanFormula removeUnnecessaryClauses(BooleanFormula fOrigin, Set<String> pRequiredVars) {
        RelevantFormulaDetector relevantFormulaDetector = new RelevantFormulaDetector(pRequiredVars);
        this.fmgr.visitRecursively((Formula)fOrigin, (FormulaVisitor<TraversalProcess>)relevantFormulaDetector);
        if (relevantFormulaDetector.detectionSuccessful()) {
            return relevantFormulaDetector.getRelevantFormula();
        }
        return fOrigin;
    }

    private class RelevantFormulaDetector
    extends DefaultFormulaVisitor<TraversalProcess> {
        private final Set<BooleanFormula> clauses = new HashSet<BooleanFormula>();
        private final Set<String> relevantVars;
        private boolean success = true;

        public RelevantFormulaDetector(Set<String> pRelevantVars) {
            this.relevantVars = pRelevantVars;
        }

        public BooleanFormula getRelevantFormula() {
            Preconditions.checkState((boolean)this.success);
            if (this.clauses.isEmpty()) {
                return PredicateRequirementsTranslator.this.fmgr.getBooleanFormulaManager().makeTrue();
            }
            return PredicateRequirementsTranslator.this.fmgr.getBooleanFormulaManager().and(this.clauses);
        }

        public boolean detectionSuccessful() {
            return this.success;
        }

        protected TraversalProcess visitDefault(Formula pFormula) {
            if (!(pFormula instanceof BooleanFormula)) {
                this.success = false;
                return TraversalProcess.ABORT;
            }
            this.clauses.add((BooleanFormula)pFormula);
            return TraversalProcess.SKIP;
        }

        public TraversalProcess visitFunction(Formula pFormula, List<Formula> args, FunctionDeclaration<?> decl) {
            if (decl.getKind().equals((Object)FunctionDeclarationKind.AND)) {
                return TraversalProcess.CONTINUE;
            }
            if (!Sets.intersection(PredicateRequirementsTranslator.this.fmgr.extractVariableNames(pFormula), this.relevantVars).isEmpty()) {
                if (!(pFormula instanceof BooleanFormula)) {
                    this.success = false;
                    return TraversalProcess.ABORT;
                }
                this.clauses.add((BooleanFormula)pFormula);
            }
            return TraversalProcess.SKIP;
        }
    }
}

