/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.translators.PredicateRequirementsTranslator;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;

@RunWith(value=Parameterized.class)
public class PredicateTranslatorTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverUnderTest;
    private PredicateRequirementsTranslator pReqTrans;
    private PredicateAbstractState ptrueState;
    private PredicateAbstractState pf1State;
    private PredicateAbstractState pf2State;
    private SSAMap ssaTest;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }

    @Before
    public void init() throws Exception {
        FormulaManagerView fmv = this.mgrv;
        PathFormulaManagerImpl pfmgr = new PathFormulaManagerImpl(fmv, this.config, this.logger, this.shutdownNotifierToUse(), MachineModel.LINUX32, Optional.empty(), AnalysisDirection.FORWARD);
        this.pReqTrans = new PredicateRequirementsTranslator(fmv);
        SSAMap.SSAMapBuilder ssaBuilder = SSAMap.emptySSAMap().builder();
        ssaBuilder.setIndex("var1", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("var3", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("fun::varB", CNumericTypes.INT, 1);
        this.ssaTest = ssaBuilder.build();
        SymbolicRegionManager regionManager = new SymbolicRegionManager(this.solver);
        Region region = regionManager.makeTrue();
        BooleanFormulaManagerView bfmgr = fmv.getBooleanFormulaManager();
        BooleanFormula bf = bfmgr.makeTrue();
        PathFormula pathFormula = pfmgr.makeEmptyPathFormula();
        AbstractionFormula aFormula = new AbstractionFormula(fmv, region, bf, bf, pathFormula, (Set<Integer>)ImmutableSet.of());
        this.ptrueState = PredicateAbstractState.mkAbstractionState(pathFormula, aFormula, (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
        IntegerFormulaManagerView ifmgr = fmv.getIntegerFormulaManager();
        BooleanFormula bf11 = ifmgr.greaterThan((NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeVariable("var1")), (NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeNumber(0L)));
        BooleanFormula bf12 = ifmgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeVariable("var3")), (NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeNumber(0L)));
        BooleanFormula bf13 = ifmgr.lessThan((NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeVariable("fun::var1")), (NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeNumber(0L)));
        BooleanFormula bf14 = bfmgr.or(bf11, bf12);
        BooleanFormula bf1 = bfmgr.and(bf14, bf13);
        aFormula = new AbstractionFormula(fmv, region, bf1, bfmgr.makeTrue(), pathFormula, (Set<Integer>)ImmutableSet.of());
        this.pf1State = PredicateAbstractState.mkAbstractionState(pathFormula, aFormula, (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
        BooleanFormula bf21 = ifmgr.greaterThan((NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeVariable("var2")), (NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeVariable("fun::varB")));
        BooleanFormula bf22 = ifmgr.lessThan((NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeVariable("fun::varC")), (NumeralFormula)((NumeralFormula.IntegerFormula)ifmgr.makeNumber(0L)));
        BooleanFormula bf2 = bfmgr.and(bf21, bf22);
        aFormula = new AbstractionFormula(fmv, region, bf2, bfmgr.makeTrue(), pathFormula, (Set<Integer>)ImmutableSet.of());
        this.pf2State = PredicateAbstractState.mkAbstractionState(pathFormula, aFormula, (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
    }

    @Test
    public void testConvertToFormula1() throws Exception {
        Pair<List<String>, String> convertedFormula = this.pReqTrans.convertToFormula(this.ptrueState, this.ssaTest, (Collection<String>)null);
        Truth.assertThat((Iterable)convertedFormula.getFirst()).isEmpty();
        this.assertFormulaIsExpected(convertedFormula, ".defci0", "true");
    }

    @Test
    public void testConvertToFormula2() throws Exception {
        Pair<List<String>, String> convertedFormula = this.pReqTrans.convertToFormula(this.pf1State, this.ssaTest, (Collection<String>)null);
        Truth.assertThat((Iterable)convertedFormula.getFirst()).containsExactly(new Object[]{"(declare-fun |fun::var1| () Int)", "(declare-fun var3@1 () Int)", "(declare-fun var1@1 () Int)"});
        this.assertFormulaIsExpected(convertedFormula, ".defci0", "(and (or (> var1@1 0) (= var3@1 0)) (< |fun::var1| 0))");
    }

    @Test
    public void testConvertRequirements1() throws Exception {
        Pair<Pair<List<String>, String>, Pair<List<String>, String>> convertedRequirements = this.pReqTrans.convertRequirements(this.pf1State, (Collection<AbstractState>)ImmutableList.of(), this.ssaTest, null, null);
        Truth.assertThat((Iterable)convertedRequirements.getFirst().getFirst()).containsExactly(new Object[]{"(declare-fun var1 () Int)", "(declare-fun var3 () Int)", "(declare-fun |fun::var1| () Int)"});
        this.assertFormulaIsExpected(convertedRequirements.getFirst(), "pre", "(and (or (> var1 0) (= var3 0)) (< |fun::var1| 0))");
        Truth.assertThat((Iterable)convertedRequirements.getSecond().getFirst()).isEmpty();
        this.assertFormulaIsExpected(convertedRequirements.getSecond(), "post", "false");
    }

    @Test
    public void testConvertRequirements2() throws Exception {
        ImmutableList pAbstrStates = ImmutableList.of((Object)this.ptrueState);
        Pair<Pair<List<String>, String>, Pair<List<String>, String>> convertedRequirements = this.pReqTrans.convertRequirements(this.pf2State, (Collection<AbstractState>)pAbstrStates, this.ssaTest, null, null);
        Truth.assertThat((Iterable)convertedRequirements.getFirst().getFirst()).containsExactly(new Object[]{"(declare-fun var2 () Int)", "(declare-fun |fun::varB| () Int)", "(declare-fun |fun::varC| () Int)"});
        this.assertFormulaIsExpected(convertedRequirements.getFirst(), "pre", "(and (> var2 |fun::varB|) (< |fun::varC| 0))");
        Truth.assertThat((Iterable)convertedRequirements.getSecond().getFirst()).isEmpty();
        this.assertFormulaIsExpected(convertedRequirements.getSecond(), "post", "true");
    }

    @Test
    public void testConvertRequirements3() throws Exception {
        ImmutableList pAbstrStates = ImmutableList.of((Object)this.pf1State, (Object)this.pf2State);
        Pair<Pair<List<String>, String>, Pair<List<String>, String>> convertedRequirements = this.pReqTrans.convertRequirements(this.ptrueState, (Collection<AbstractState>)pAbstrStates, this.ssaTest, null, null);
        Truth.assertThat((Iterable)convertedRequirements.getFirst().getFirst()).isEmpty();
        this.assertFormulaIsExpected(convertedRequirements.getFirst(), "pre", "true");
        Truth.assertThat((Iterable)convertedRequirements.getSecond().getFirst()).containsExactly(new Object[]{"(declare-fun var1@1 () Int)", "(declare-fun var3@1 () Int)", "(declare-fun |fun::var1| () Int)", "(declare-fun var2 () Int)", "(declare-fun |fun::varB@1| () Int)", "(declare-fun |fun::varC| () Int)"});
        this.assertFormulaIsExpected(convertedRequirements.getSecond(), "post", "(or (and (or (> var1@1 0) (= var3@1 0)) (< |fun::var1| 0))(and (> var2 |fun::varB@1|) (< |fun::varC| 0)))");
    }

    private void assertFormulaIsExpected(Pair<List<String>, String> convertedFormula, String termName, String expectedFormula) throws SolverException, InterruptedException {
        this.requireParser();
        String defs = Joiner.on((String)"\n").join((Iterable)convertedFormula.getFirst());
        BooleanFormula f = this.mgr.parse(defs + "\n" + convertedFormula.getSecond() + "\n(assert " + termName + ")");
        BooleanFormula expected = this.mgr.parse(defs + "\n(assert " + expectedFormula + ")");
        this.assertThatFormula(f).isEquivalentTo(expected);
    }
}

