/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.sign.SIGN;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.util.ci.translators.CartesianRequirementsTranslator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class SignRequirementsTranslator
extends CartesianRequirementsTranslator<SignState> {
    public SignRequirementsTranslator(LogManager pLog) {
        super(SignState.class, pLog);
    }

    @Override
    protected List<String> getVarsInRequirements(SignState pRequirement) {
        return new ArrayList<String>(pRequirement.getSignMapView().keySet());
    }

    @Override
    protected List<String> getListOfIndependentRequirements(SignState pRequirement, SSAMap pIndices, @Nullable Collection<String> pRequiredVars) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, SIGN> entry : pRequirement.getSignMapView().entrySet()) {
            String var = entry.getKey();
            if (pRequiredVars != null && !pRequiredVars.contains(var)) continue;
            list.add(this.getRequirement(SignRequirementsTranslator.getVarWithIndex(var, pIndices), entry.getValue()));
        }
        return list;
    }

    private String getRequirement(String var, SIGN sign) {
        StringBuilder sb = new StringBuilder();
        Preconditions.checkArgument((sign != SIGN.EMPTY ? 1 : 0) != 0);
        Preconditions.checkArgument((sign != SIGN.ALL ? 1 : 0) != 0);
        switch (sign) {
            case PLUS: {
                sb.append("(> ");
                sb.append(var);
                sb.append(" 0)");
                break;
            }
            case MINUS: {
                sb.append("(< ");
                sb.append(var);
                sb.append(" 0)");
                break;
            }
            case ZERO: {
                sb.append("(= ");
                sb.append(var);
                sb.append(" 0)");
                break;
            }
            case PLUSMINUS: {
                sb.append("(or (> ");
                sb.append(var);
                sb.append(" 0) (< ");
                sb.append(var);
                sb.append(" 0))");
                break;
            }
            case PLUS0: {
                sb.append("(>= ");
                sb.append(var);
                sb.append(" 0)");
                break;
            }
            case MINUS0: {
                sb.append("(<= ");
                sb.append(var);
                sb.append(" 0)");
                break;
            }
            default: {
                throw new AssertionError((Object)"should never happen");
            }
        }
        return sb.toString();
    }
}

