/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.cpa.sign.SIGN;
import org.sosy_lab.cpachecker.cpa.sign.SignState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.ci.translators.CartesianRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.IntervalRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.SignRequirementsTranslator;
import org.sosy_lab.cpachecker.util.ci.translators.ValueRequirementsTranslator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class TranslatorTest {
    private final MachineModel machineModel = MachineModel.LINUX32;
    private String[] varNames = new String[]{"var1", "var2", "var3", "fun::var1", "fun::varB", "fun::varC"};
    private CSimpleType integervariable = CNumericTypes.INT;
    private SSAMap ssaTest;

    @Before
    public void init() {
        SSAMap.SSAMapBuilder ssaBuilder = SSAMap.emptySSAMap().builder();
        ssaBuilder.setIndex("var1", this.integervariable, 1);
        ssaBuilder.setIndex("var3", this.integervariable, 1);
        ssaBuilder.setIndex("fun::varB", this.integervariable, 1);
        this.ssaTest = ssaBuilder.build();
    }

    @Test
    public void testValueTranslator() {
        PersistentSortedMap constantsMap = PathCopyingPersistentTreeMap.of();
        constantsMap = constantsMap.putAndCopy((Object)MemoryLocation.forIdentifier("var1"), (Object)new ValueAnalysisState.ValueAndType(new NumericValue(3), null));
        constantsMap = constantsMap.putAndCopy((Object)MemoryLocation.forIdentifier("var3"), (Object)new ValueAnalysisState.ValueAndType(NullValue.getInstance(), null));
        constantsMap = constantsMap.putAndCopy((Object)MemoryLocation.forLocalVariable("fun", "var1"), (Object)new ValueAnalysisState.ValueAndType(new NumericValue(1.5), null));
        constantsMap = constantsMap.putAndCopy((Object)MemoryLocation.forLocalVariable("fun", "varC"), (Object)new ValueAnalysisState.ValueAndType(new NumericValue(-5), null));
        Truth.assertThat((Map)constantsMap).hasSize(4);
        ValueAnalysisState vStateTest = new ValueAnalysisState(Optional.of(this.machineModel), (PersistentMap<MemoryLocation, ValueAnalysisState.ValueAndType>)constantsMap);
        Truth.assertThat(vStateTest.getConstants()).isNotEmpty();
        ValueRequirementsTranslator vReqTransTest = new ValueRequirementsTranslator(LogManager.createTestLogManager());
        List<String> varsInRequirements = vReqTransTest.getVarsInRequirements(vStateTest);
        Truth.assertThat(varsInRequirements).containsExactly(new Object[]{"var1", "var3", "fun::var1", "fun::varC"});
        List<String> listOfIndependentRequirements = vReqTransTest.getListOfIndependentRequirements(vStateTest, this.ssaTest, (Collection<String>)null);
        Truth.assertThat(listOfIndependentRequirements).containsExactly(new Object[]{"(= var1@1 3)", "(= |fun::varC| -5)"});
        listOfIndependentRequirements = vReqTransTest.getListOfIndependentRequirements(vStateTest, this.ssaTest, (Collection<String>)ImmutableList.of());
        Truth.assertThat(listOfIndependentRequirements).isEmpty();
        ArrayList<String> requiredVars = new ArrayList<String>();
        requiredVars.add("var3");
        requiredVars.add("fun::varC");
        requiredVars.add("main::x");
        listOfIndependentRequirements = vReqTransTest.getListOfIndependentRequirements(vStateTest, this.ssaTest, (Collection<String>)requiredVars);
        Truth.assertThat(listOfIndependentRequirements).containsExactly(new Object[]{"(= |fun::varC| -5)"});
    }

    @Test
    public void testSignTranslator() {
        SignState sStateTest = SignState.TOP;
        sStateTest = sStateTest.assignSignToVariable("var1", SIGN.PLUS);
        sStateTest = sStateTest.assignSignToVariable("var2", SIGN.MINUS);
        sStateTest = sStateTest.assignSignToVariable("var3", SIGN.ZERO);
        sStateTest = sStateTest.assignSignToVariable("fun::var1", SIGN.PLUSMINUS);
        sStateTest = sStateTest.assignSignToVariable("fun::varB", SIGN.PLUS0);
        sStateTest = sStateTest.assignSignToVariable("fun::varC", SIGN.MINUS0);
        SignRequirementsTranslator sReqTransTest = new SignRequirementsTranslator(LogManager.createTestLogManager());
        List<String> varsInReq = sReqTransTest.getVarsInRequirements(sStateTest);
        Truth.assertThat(varsInReq).containsExactlyElementsIn(Arrays.asList(this.varNames));
        List<String> listOfIndepententReq = sReqTransTest.getListOfIndependentRequirements(sStateTest, this.ssaTest, (Collection<String>)ImmutableList.of());
        Truth.assertThat(listOfIndepententReq).isEmpty();
        listOfIndepententReq = sReqTransTest.getListOfIndependentRequirements(sStateTest, this.ssaTest, (Collection<String>)null);
        ArrayList<String> content = new ArrayList<String>();
        content.add("(> var1@1 0)");
        content.add("(< var2 0)");
        content.add("(= var3@1 0)");
        content.add("(or (> |fun::var1| 0) (< |fun::var1| 0))");
        content.add("(>= |fun::varB@1| 0)");
        content.add("(<= |fun::varC| 0)");
        Truth.assertThat(listOfIndepententReq).containsExactlyElementsIn(content);
        ArrayList<String> requiredVars = new ArrayList<String>();
        requiredVars.add("var1");
        requiredVars.add("var3");
        requiredVars.add("varB");
        requiredVars.add("fun::varC");
        listOfIndepententReq = sReqTransTest.getListOfIndependentRequirements(sStateTest, this.ssaTest, (Collection<String>)requiredVars);
        content = new ArrayList();
        content.add("(> var1@1 0)");
        content.add("(= var3@1 0)");
        content.add("(<= |fun::varC| 0)");
        Truth.assertThat(listOfIndepententReq).containsExactlyElementsIn(content);
    }

    @Test
    public void testIntervalAndCartesianTranslator() {
        PersistentSortedMap intervals = PathCopyingPersistentTreeMap.of();
        PersistentSortedMap referenceMap = PathCopyingPersistentTreeMap.of();
        intervals = intervals.putAndCopy((Object)"var1", (Object)new Interval(Long.MIN_VALUE, 5L));
        intervals = intervals.putAndCopy((Object)"var2", (Object)new Interval(-7L, Long.MAX_VALUE));
        intervals = intervals.putAndCopy((Object)"var3", (Object)new Interval(Long.MIN_VALUE, -2L));
        intervals = intervals.putAndCopy((Object)"fun::var1", (Object)new Interval(0L, 10L));
        intervals = intervals.putAndCopy((Object)"fun::varB", (Object)new Interval(8L, Long.MAX_VALUE));
        intervals = intervals.putAndCopy((Object)"fun::varC", (Object)new Interval(-15L, -3L));
        IntervalAnalysisState iStateTest = new IntervalAnalysisState((PersistentMap<String, Interval>)intervals, (PersistentMap<String, Integer>)referenceMap);
        IntervalRequirementsTranslator iReqTransTest = new IntervalRequirementsTranslator(LogManager.createTestLogManager());
        List<String> varsInRequirements = iReqTransTest.getVarsInRequirements(iStateTest);
        Truth.assertThat(varsInRequirements).containsExactlyElementsIn(Arrays.asList(this.varNames));
        List<String> listOfIndependentRequirements = iReqTransTest.getListOfIndependentRequirements(iStateTest, this.ssaTest, (Collection<String>)null);
        ArrayList<String> content = new ArrayList<String>();
        content.add("(<= var1@1 5)");
        content.add("(>= var2 -7)");
        content.add("(<= var3@1 -2)");
        content.add("(and (>= |fun::var1| 0) (<= |fun::var1| 10))");
        content.add("(>= |fun::varB@1| 8)");
        content.add("(and (>= |fun::varC| -15) (<= |fun::varC| -3))");
        Truth.assertThat(listOfIndependentRequirements).containsExactlyElementsIn(content);
        listOfIndependentRequirements = iReqTransTest.getListOfIndependentRequirements(iStateTest, this.ssaTest, (Collection<String>)ImmutableList.of());
        Truth.assertThat(listOfIndependentRequirements).isEmpty();
        ArrayList<String> requiredVars = new ArrayList<String>();
        requiredVars.add("var1");
        requiredVars.add("var3");
        requiredVars.add("fun::varB");
        listOfIndependentRequirements = iReqTransTest.getListOfIndependentRequirements(iStateTest, this.ssaTest, (Collection<String>)requiredVars);
        content = new ArrayList();
        content.add("(<= var1@1 5)");
        content.add("(<= var3@1 -2)");
        content.add("(>= |fun::varB@1| 8)");
        Truth.assertThat(listOfIndependentRequirements).containsExactlyElementsIn(content);
        List<String> varDefinition = CartesianRequirementsTranslator.writeVarDefinition(Arrays.asList(this.varNames), this.ssaTest);
        content = new ArrayList();
        content.add("(declare-fun var1@1 () Int)");
        content.add("(declare-fun var2 () Int)");
        content.add("(declare-fun var3@1 () Int)");
        content.add("(declare-fun |fun::var1| () Int)");
        content.add("(declare-fun |fun::varB@1| () Int)");
        content.add("(declare-fun |fun::varC| () Int)");
        Truth.assertThat(varDefinition).containsExactlyElementsIn(content);
        Pair<List<String>, String> convertedToFormula = iReqTransTest.convertToFormula(iStateTest, this.ssaTest, (Collection<String>)ImmutableList.of());
        Truth.assertThat((Iterable)convertedToFormula.getFirst()).isEmpty();
        String s = "(define-fun req () Bool true)";
        Truth.assertThat((String)convertedToFormula.getSecond()).isEqualTo((Object)s);
        convertedToFormula = iReqTransTest.convertToFormula(iStateTest, this.ssaTest, null);
        Truth.assertThat((Iterable)convertedToFormula.getFirst()).containsExactlyElementsIn(content);
        s = "(define-fun req () Bool (and (and (>= |fun::var1| 0) (<= |fun::var1| 10))(and (>= |fun::varB@1| 8)(and (and (>= |fun::varC| -15) (<= |fun::varC| -3))(and (<= var1@1 5)(and (>= var2 -7)(<= var3@1 -2)))))))";
        Truth.assertThat((String)convertedToFormula.getSecond()).isEqualTo((Object)s);
        convertedToFormula = iReqTransTest.convertToFormula(iStateTest, this.ssaTest, requiredVars);
        ArrayList<String> content2 = new ArrayList<String>();
        content2.add("(declare-fun var1@1 () Int)");
        content2.add("(declare-fun var3@1 () Int)");
        content2.add("(declare-fun |fun::varB@1| () Int)");
        Truth.assertThat((Iterable)convertedToFormula.getFirst()).containsExactlyElementsIn(content2);
        s = "(define-fun req () Bool (and (>= |fun::varB@1| 8)(and (<= var1@1 5)(<= var3@1 -2))))";
        Truth.assertThat((String)convertedToFormula.getSecond()).isEqualTo((Object)s);
        convertedToFormula = iReqTransTest.convertToFormula(new IntervalAnalysisState(), this.ssaTest, null);
        Truth.assertThat((Iterable)convertedToFormula.getFirst()).isEmpty();
        s = "(define-fun req () Bool true)";
        Truth.assertThat((String)convertedToFormula.getSecond()).isEqualTo((Object)s);
        intervals = PathCopyingPersistentTreeMap.of();
        referenceMap = PathCopyingPersistentTreeMap.of();
        intervals = intervals.putAndCopy((Object)"var1", (Object)new Interval(0L, Long.MAX_VALUE));
        IntervalAnalysisState anotherIStateTest = new IntervalAnalysisState((PersistentMap<String, Interval>)intervals, (PersistentMap<String, Integer>)referenceMap);
        convertedToFormula = iReqTransTest.convertToFormula(anotherIStateTest, this.ssaTest, null);
        content = new ArrayList();
        content.add("(declare-fun var1@1 () Int)");
        Truth.assertThat((Iterable)convertedToFormula.getFirst()).containsExactlyElementsIn(content);
        s = "(define-fun req () Bool (>= var1@1 0))";
        Truth.assertThat((String)convertedToFormula.getSecond()).isEqualTo((Object)s);
    }

    @Test
    public void testOctagonTranslator() {
    }

    @Test
    public void testApronTranslator() {
    }
}

