/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ci.translators;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.ci.translators.CartesianRequirementsTranslator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ValueRequirementsTranslator
extends CartesianRequirementsTranslator<ValueAnalysisState> {
    public ValueRequirementsTranslator(LogManager pLog) {
        super(ValueAnalysisState.class, pLog);
    }

    @Override
    protected List<String> getVarsInRequirements(ValueAnalysisState pRequirement) {
        ArrayList<String> list = new ArrayList<String>(pRequirement.getConstants().size());
        for (MemoryLocation memLoc : pRequirement.getTrackedMemoryLocations()) {
            list.add(memLoc.getExtendedQualifiedName());
        }
        return list;
    }

    @Override
    protected List<String> getListOfIndependentRequirements(ValueAnalysisState pRequirement, SSAMap pIndices, @Nullable Collection<String> pRequiredVars) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType> e : pRequirement.getConstants()) {
            MemoryLocation memLoc = e.getKey();
            Value integerValue = e.getValue().getValue();
            if (!integerValue.isNumericValue() || !(integerValue.asNumericValue().getNumber() instanceof Integer) && !(integerValue.asNumericValue().getNumber() instanceof Long) && !(integerValue.asNumericValue().getNumber() instanceof BigInteger)) {
                this.logger.log(Level.SEVERE, new Object[]{"The value " + integerValue + " of the MemoryLocation " + memLoc + " is not an Integer."});
                continue;
            }
            if (pRequiredVars != null && !pRequiredVars.contains(memLoc.getExtendedQualifiedName())) continue;
            list.add("(= " + ValueRequirementsTranslator.getVarWithIndex(memLoc.getExtendedQualifiedName(), pIndices) + " " + integerValue.asNumericValue().getNumber() + ")");
        }
        return list;
    }
}

