/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;

class CounterexampleCoverageCollector {
    CounterexampleCoverageCollector() {
    }

    CoverageData collectFromCounterexample(ARGPath cexPath) {
        CoverageData cov = new CoverageData();
        this.collectCoveredEdges(cexPath, cov);
        return cov;
    }

    private boolean isOutsideAssumptionAutomaton(ARGState s) {
        boolean foundAssumptionAutomaton = false;
        for (AutomatonState aState : AbstractStates.asIterable(s).filter(AutomatonState.class)) {
            if (!aState.getOwningAutomatonName().equals("AssumptionAutomaton")) continue;
            foundAssumptionAutomaton = true;
            if (!aState.getInternalStateName().equals("__FALSE")) continue;
            return true;
        }
        Preconditions.checkArgument((boolean)foundAssumptionAutomaton, (Object)"This method should only be called when an Assumption Automaton is used as part of the specification.");
        return false;
    }

    private void collectCoveredEdges(ARGPath cexPath, CoverageData cov) {
        PathIterator pathIterator = cexPath.fullPathIterator();
        while (pathIterator.hasNext()) {
            CFAEdge edge = pathIterator.getOutgoingEdge();
            if (this.isOutsideAssumptionAutomaton(pathIterator.getNextAbstractState())) break;
            cov.addVisitedEdge(edge);
            pathIterator.advance();
        }
    }
}

