/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.coverage.FileCoverageInformation;

public final class CoverageData {
    private final Map<String, FileCoverageInformation> infosPerFile = new LinkedHashMap<String, FileCoverageInformation>();

    public static boolean coversLine(CFAEdge pEdge) {
        FileLocation loc = pEdge.getFileLocation();
        if (loc.getStartingLineNumber() == 0) {
            return false;
        }
        return !(pEdge instanceof ADeclarationEdge) || !(((ADeclarationEdge)pEdge).getDeclaration() instanceof AFunctionDeclaration);
    }

    private FileCoverageInformation getFileInfoTarget(FileLocation pLoc, Map<String, FileCoverageInformation> pTargets) {
        assert (pLoc.getStartingLineNumber() != 0);
        String file = pLoc.getFileName().toString();
        FileCoverageInformation fileInfos = pTargets.get(file);
        if (fileInfos == null) {
            fileInfos = new FileCoverageInformation();
            pTargets.put(file, fileInfos);
        }
        return fileInfos;
    }

    public void putCFA(CFA pCFA) {
        for (CFANode node : pCFA.getAllNodes()) {
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                this.putExistingEdge(edge);
            }
        }
        for (FunctionEntryNode entryNode : pCFA.getAllFunctionHeads()) {
            this.putExistingFunction(entryNode);
        }
    }

    private void putExistingFunction(FunctionEntryNode pNode) {
        String functionName = pNode.getFunctionName();
        FileLocation loc = pNode.getFileLocation();
        if (loc.getStartingLineNumber() == 0) {
            return;
        }
        FileCoverageInformation infos = this.getFileInfoTarget(loc, this.infosPerFile);
        int startingLine = loc.getStartingLineInOrigin();
        int endingLine = loc.getEndingLineInOrigin();
        infos.addExistingFunction(functionName, startingLine, endingLine);
    }

    private void putExistingEdge(CFAEdge pEdge) {
        if (!CoverageData.coversLine(pEdge)) {
            return;
        }
        FileLocation loc = pEdge.getFileLocation();
        FileCoverageInformation collector = this.getFileInfoTarget(loc, this.infosPerFile);
        int startingLine = loc.getStartingLineInOrigin();
        int endingLine = loc.getEndingLineInOrigin();
        for (int line = startingLine; line <= endingLine; ++line) {
            collector.addExistingLine(line);
        }
        if (pEdge instanceof AssumeEdge) {
            collector.addExistingAssume((AssumeEdge)pEdge);
        }
    }

    public void addVisitedEdge(CFAEdge pEdge) {
        if (!CoverageData.coversLine(pEdge)) {
            return;
        }
        this.putExistingEdge(pEdge);
        FileLocation loc = pEdge.getFileLocation();
        FileCoverageInformation collector = this.getFileInfoTarget(loc, this.infosPerFile);
        int startingLine = loc.getStartingLineInOrigin();
        int endingLine = loc.getEndingLineInOrigin();
        if (pEdge instanceof AssumeEdge) {
            collector.addVisitedAssume((AssumeEdge)pEdge);
        }
        for (int line = startingLine; line <= endingLine; ++line) {
            collector.addVisitedLine(line);
        }
    }

    public void addVisitedFunction(FunctionEntryNode pEntryNode) {
        FileCoverageInformation infos = this.getFileInfoTarget(pEntryNode.getFileLocation(), this.infosPerFile);
        infos.addVisitedFunction(pEntryNode.getFunctionName());
    }

    Map<String, FileCoverageInformation> getInfosPerFile() {
        return this.infosPerFile;
    }
}

