/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import com.google.common.collect.Multiset;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Map;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;
import org.sosy_lab.cpachecker.util.coverage.FileCoverageInformation;

public class CoverageReportGcov {
    private static final String TEXTNAME = "TN:";
    private static final String SOURCEFILE = "SF:";
    private static final String FUNCTION = "FN:";
    private static final String FUNCTIONDATA = "FNDA:";
    private static final String LINEDATA = "DA:";

    public static void write(CoverageData pCoverage, Writer w) throws IOException {
        for (Map.Entry<String, FileCoverageInformation> entry : pCoverage.getInfosPerFile().entrySet()) {
            String sourcefile = entry.getKey();
            FileCoverageInformation fileInfos = entry.getValue();
            w.append("TN:\n");
            w.append(SOURCEFILE + Path.of(sourcefile, new String[0]).toAbsolutePath() + "\n");
            for (FileCoverageInformation.FunctionInfo info : fileInfos.allFunctions) {
                w.append(FUNCTION + info.firstLine + "," + info.name + "\n");
                w.append("#FN:" + info.lastLine + "\n");
            }
            for (Multiset.Entry functionEntry : fileInfos.visitedFunctions.entrySet()) {
                w.append(FUNCTIONDATA + functionEntry.getCount() + "," + (String)functionEntry.getElement() + "\n");
            }
            for (Integer line : fileInfos.allLines) {
                w.append(LINEDATA + line + "," + fileInfos.getVisitedLine(line) + "\n");
            }
            w.append("end_of_record\n");
        }
    }
}

