/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import java.io.PrintStream;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;
import org.sosy_lab.cpachecker.util.coverage.FileCoverageInformation;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

public class CoverageReportStdoutSummary {
    public static void write(CoverageData pCoverage, PrintStream pStdOut) {
        long numTotalConditions = 0L;
        long numTotalFunctions = 0L;
        long numTotalLines = 0L;
        long numVisitedConditions = 0L;
        long numVisitedFunctions = 0L;
        long numVisitedLines = 0L;
        for (FileCoverageInformation info : pCoverage.getInfosPerFile().values()) {
            numTotalFunctions += (long)info.allFunctions.size();
            numVisitedFunctions += (long)info.visitedFunctions.entrySet().size();
            numTotalConditions += (long)info.allAssumes.size();
            numVisitedConditions += (long)info.visitedAssumes.size();
            numTotalLines += (long)info.allLines.size();
            numVisitedLines += (long)info.visitedLines.entrySet().size();
        }
        if (numTotalFunctions > 0L) {
            double functionCoverage = (double)numVisitedFunctions / (double)numTotalFunctions;
            StatisticsUtils.write(pStdOut, 1, 25, "Function coverage", String.format("%.3f", functionCoverage));
        }
        if (numTotalLines > 0L) {
            double lineCoverage = (double)numVisitedLines / (double)numTotalLines;
            StatisticsUtils.write(pStdOut, 1, 25, "Visited lines", numVisitedLines);
            StatisticsUtils.write(pStdOut, 1, 25, "Total lines", numTotalLines);
            StatisticsUtils.write(pStdOut, 1, 25, "Line coverage", String.format("%.3f", lineCoverage));
        }
        if (numTotalConditions > 0L) {
            double conditionCoverage = (double)numVisitedConditions / (double)numTotalConditions;
            StatisticsUtils.write(pStdOut, 1, 25, "Visited conditions", numVisitedConditions);
            StatisticsUtils.write(pStdOut, 1, 25, "Total conditions", numTotalConditions);
            StatisticsUtils.write(pStdOut, 1, 25, "Condition coverage", String.format("%.3f", conditionCoverage));
        }
    }
}

