/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;

class FileCoverageInformation {
    final Multiset<Integer> visitedLines = LinkedHashMultiset.create();
    final Set<Integer> allLines = new LinkedHashSet<Integer>();
    final Multiset<String> visitedFunctions = LinkedHashMultiset.create();
    final Set<FunctionInfo> allFunctions = new LinkedHashSet<FunctionInfo>();
    final Set<AssumeEdge> allAssumes = new LinkedHashSet<AssumeEdge>();
    final Set<AssumeEdge> visitedAssumes = new LinkedHashSet<AssumeEdge>();

    FileCoverageInformation() {
    }

    void addVisitedAssume(AssumeEdge pEdge) {
        this.visitedAssumes.add(pEdge);
    }

    void addExistingAssume(AssumeEdge pEdge) {
        this.allAssumes.add(pEdge);
    }

    void addVisitedFunction(String pName) {
        this.visitedFunctions.add((Object)pName);
    }

    void addExistingFunction(String pName, int pFirstLine, int pLastLine) {
        this.allFunctions.add(new FunctionInfo(pName, pFirstLine, pLastLine));
    }

    void addVisitedLine(int pLine) {
        Preconditions.checkArgument((pLine > 0 ? 1 : 0) != 0);
        this.visitedLines.add((Object)pLine);
    }

    int getVisitedLine(int pLine) {
        Preconditions.checkArgument((pLine > 0 ? 1 : 0) != 0);
        return this.visitedLines.count((Object)pLine);
    }

    void addExistingLine(int pLine) {
        Preconditions.checkArgument((pLine > 0 ? 1 : 0) != 0);
        this.allLines.add(pLine);
    }

    static class FunctionInfo {
        final String name;
        final int firstLine;
        final int lastLine;

        FunctionInfo(String pName, int pFirstLine, int pLastLine) {
            this.name = pName;
            this.firstLine = pFirstLine;
            this.lastLine = pLastLine;
        }
    }
}

