/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.coverage;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;

class ReachedSetCoverageCollector {
    ReachedSetCoverageCollector() {
    }

    CoverageData collectFromReachedSet(Iterable<AbstractState> reached, CFA cfa) {
        CoverageData cov = new CoverageData();
        cov.putCFA(cfa);
        for (FunctionEntryNode entryNode : AbstractStates.extractLocations(reached).filter(Predicates.notNull()).filter(FunctionEntryNode.class)) {
            FileLocation loc = entryNode.getFileLocation();
            if (loc.getStartingLineNumber() == 0) continue;
            cov.addVisitedFunction(entryNode);
        }
        this.collectCoveredEdges(reached, cov);
        return cov;
    }

    private void collectCoveredEdges(Iterable<AbstractState> reached, CoverageData cov) {
        ImmutableSet reachedNodes = FluentIterable.from(reached).transform(AbstractStates::extractLocation).filter(Predicates.notNull()).toSet();
        for (AbstractState state : reached) {
            ARGState argState = AbstractStates.extractStateByType(state, ARGState.class);
            if (argState != null) {
                for (ARGState child : argState.getChildren()) {
                    List<CFAEdge> edges = argState.getEdgesToChild(child);
                    if (edges.size() > 1) {
                        for (CFAEdge innerEdge : edges) {
                            cov.addVisitedEdge(innerEdge);
                        }
                        continue;
                    }
                    if (edges.isEmpty()) continue;
                    cov.addVisitedEdge((CFAEdge)Iterables.getOnlyElement(edges));
                }
                continue;
            }
            CFANode node = AbstractStates.extractLocation(state);
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                if (!reachedNodes.contains(edge.getSuccessor())) continue;
                cov.addVisitedEdge(edge);
            }
        }
    }
}

