/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.cwriter.Statement;
import org.sosy_lab.cpachecker.util.cwriter.StatementWriter;
import org.sosy_lab.cpachecker.util.cwriter.TranslatorConfig;

public class ARGToCTranslator {
    private static final String ASSERTFAIL = "__assert_fail";
    private static final String DEFAULTRETURN = "default return";
    private static final String TMPVARPREFIX = "__tmp_";
    private static final AbstractState BOTTOM = new AbstractState(){};
    private TranslatorConfig config;
    private final LogManager logger;
    private final CBinaryExpressionBuilder cBinaryExpressionBuilder;
    private final List<String> globalDefinitionsList = new ArrayList<String>();
    private final Set<ARGState> discoveredElements = new HashSet<ARGState>();
    private final Set<ARGState> mergeElements = new HashSet<ARGState>();
    private Statement.FunctionDefinition mainFunction;
    private String mainReturnVar;
    private boolean isVoidMain;
    private boolean deleteAssertFail;
    private @Nullable Set<ARGState> addPragmaAfter;
    private Map<ARGState, List<CDeclaration>> copyValuesForGoto;
    private int freshIndex = 0;

    public ARGToCTranslator(LogManager pLogger, Configuration pConfig, MachineModel pMachineModel) throws InvalidConfigurationException {
        this.config = new TranslatorConfig(pConfig);
        this.logger = pLogger;
        this.deleteAssertFail = this.config.getTargetStrategy() == TargetTreatment.FRAMACPRAGMA;
        this.cBinaryExpressionBuilder = new CBinaryExpressionBuilder(pMachineModel, pLogger);
    }

    public boolean addsIncludeDirectives() {
        return this.config.doIncludeHeader() || this.config.getTargetStrategy() == TargetTreatment.ASSERTFALSE;
    }

    public String translateARG(ARGState argRoot, boolean hasGotoDecProblem) throws CPAException, IOException {
        return this.translateARG(argRoot, null, hasGotoDecProblem);
    }

    public String translateARG(ARGState argRoot, @Nullable Set<ARGState> pAddPragma, boolean hasGotoDecProblem) throws CPAException, IOException {
        this.addPragmaAfter = pAddPragma == null ? ImmutableSet.of() : pAddPragma;
        this.copyValuesForGoto = hasGotoDecProblem ? this.identifyDeclarationProblems(argRoot) : ImmutableMap.of();
        this.translate(argRoot);
        return this.generateCCode();
    }

    private String generateCCode() throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (StatementWriter writer = StatementWriter.getWriter(buffer, this.config);){
            for (String globalDef : this.globalDefinitionsList) {
                writer.write(globalDef);
            }
            this.mainFunction.accept(writer);
        }
        return buffer.toString();
    }

    private void translate(ARGState rootElement) throws CPAException {
        ArrayDeque<ARGEdge> waitlist = new ArrayDeque<ARGEdge>();
        this.startMainFunction(rootElement);
        this.getRelevantChildrenOfElement(rootElement, waitlist, this.mainFunction.getFunctionBody());
        while (!waitlist.isEmpty()) {
            ARGEdge nextEdge = (ARGEdge)waitlist.pop();
            this.handleEdge(nextEdge, waitlist);
        }
    }

    private void startMainFunction(ARGState firstFunctionElement) {
        CFunctionEntryNode functionStartNode = (CFunctionEntryNode)AbstractStates.extractStateByType(firstFunctionElement, LocationState.class).getLocationNode();
        String lFunctionHeader = functionStartNode.getFunctionDefinition().toQualifiedASTString().replace(";", "");
        this.mainFunction = new Statement.FunctionDefinition(lFunctionHeader, new Statement.CompoundStatement());
        CType returnType = functionStartNode.getFunctionDefinition().getType().getReturnType();
        this.isVoidMain = returnType instanceof CVoidType;
        if (!this.isVoidMain) {
            this.mainReturnVar = "__return_main";
            if (returnType instanceof CArrayType) {
                this.globalDefinitionsList.add(((CArrayType)returnType).toQualifiedASTString(this.mainReturnVar) + ";");
            } else {
                this.globalDefinitionsList.add(returnType.toASTString(this.mainReturnVar) + ";");
            }
        }
    }

    private void getRelevantChildrenOfElement(ARGState currentElement, Deque<ARGEdge> waitlist, Statement.CompoundStatement currentBlock) {
        this.discoveredElements.add(currentElement);
        this.generateLabel(currentElement, currentBlock);
        Collection<ARGState> childrenOfElement = currentElement.getChildren();
        if (childrenOfElement.isEmpty()) {
            if (currentElement.isCovered()) {
                if (this.copyValuesForGoto.containsKey(currentElement.getCoveringState())) {
                    this.addTmpAssignments(currentBlock, this.copyValuesForGoto.get(currentElement.getCoveringState()), currentElement.getCoveringState().getStateId(), false);
                }
                currentBlock.addStatement(new Statement.SimpleStatement("goto label_" + currentElement.getCoveringState().getStateId() + ";"));
            } else {
                CFANode loc = AbstractStates.extractLocation(currentElement);
                if (!this.isVoidMain && currentElement.getWrappedState() != BOTTOM && loc.getNumLeavingEdges() == 0 && loc.getEnteringEdge(0).getEdgeType() == CFAEdgeType.ReturnStatementEdge) {
                    currentBlock.addStatement(new Statement.SimpleStatement("return __return_" + currentElement.getStateId() + ";"));
                } else if (this.isVoidMain) {
                    currentBlock.addStatement(new Statement.SimpleStatement("return;"));
                } else {
                    currentBlock.addStatement(new Statement.SimpleStatement("return " + this.mainReturnVar + ";"));
                }
            }
        } else if (childrenOfElement.size() == 1) {
            ARGState child = (ARGState)Iterables.getOnlyElement(childrenOfElement);
            CFAEdge edgeToChild = currentElement.getEdgeToChild(child);
            if (edgeToChild instanceof CAssumeEdge) {
                ARGEdge e;
                CAssumeEdge assumeEdge = (CAssumeEdge)edgeToChild;
                boolean truthAssumption = this.getRealTruthAssumption(assumeEdge);
                String cond = truthAssumption == assumeEdge.getTruthAssumption() ? "if (" + assumeEdge.getExpression().toQualifiedASTString() + ")" : "if (!(" + assumeEdge.getExpression().toQualifiedASTString() + "))";
                Statement.CompoundStatement newBlock = this.addIfStatement(currentBlock, cond, edgeToChild);
                if (truthAssumption) {
                    e = new ARGEdge(currentElement, child, edgeToChild, newBlock);
                    this.pushToWaitlist(waitlist, e.getParentElement(), e.getChildElement(), e.getCfaEdge(), e.getCurrentBlock());
                } else {
                    this.pushToWaitlist(waitlist, currentElement, new ARGState(BOTTOM, null), edgeToChild.getPredecessor().getLeavingEdge(0) == edgeToChild ? edgeToChild.getPredecessor().getLeavingEdge(1) : edgeToChild.getPredecessor().getLeavingEdge(0), newBlock);
                }
                newBlock = this.addIfStatement(currentBlock, "else ", edgeToChild);
                if (truthAssumption) {
                    this.pushToWaitlist(waitlist, currentElement, new ARGState(BOTTOM, null), edgeToChild.getPredecessor().getLeavingEdge(0) == edgeToChild ? edgeToChild.getPredecessor().getLeavingEdge(1) : edgeToChild.getPredecessor().getLeavingEdge(0), newBlock);
                } else {
                    e = new ARGEdge(currentElement, child, edgeToChild, newBlock);
                    this.pushToWaitlist(waitlist, e.getParentElement(), e.getChildElement(), e.getCfaEdge(), e.getCurrentBlock());
                }
            } else {
                this.pushToWaitlist(waitlist, currentElement, child, edgeToChild, currentBlock);
            }
        } else if (childrenOfElement.size() == 2 && childrenOfElement.stream().allMatch(x -> currentElement.getEdgeToChild((ARGState)x) instanceof CAssumeEdge)) {
            ArrayList<ARGEdge> result = new ArrayList<ARGEdge>(2);
            int ind = 0;
            boolean previousTruthAssumption = false;
            Object elseCond = null;
            for (ARGState child : childrenOfElement) {
                Statement.CompoundStatement newBlock;
                CFAEdge edgeToChild = currentElement.getEdgeToChild(child);
                assert (edgeToChild instanceof CAssumeEdge) : "something wrong: branch in ARG without condition: " + edgeToChild;
                CAssumeEdge assumeEdge = (CAssumeEdge)edgeToChild;
                boolean truthAssumption = this.getRealTruthAssumption(assumeEdge);
                Object cond = "";
                cond = truthAssumption ? (assumeEdge.getTruthAssumption() ? "if (" + assumeEdge.getExpression().toQualifiedASTString() + ")" : "if (!(" + assumeEdge.getExpression().toQualifiedASTString() + "))") : "else ";
                if (ind > 0 && truthAssumption == previousTruthAssumption) {
                    throw new AssertionError((Object)"Two assume edges with same truth value, thus, cannot generated C program from ARG.");
                }
                if (++ind == 1 && !truthAssumption) {
                    newBlock = new Statement.CompoundStatement(currentBlock);
                    elseCond = cond;
                } else {
                    newBlock = this.addIfStatement(currentBlock, (String)cond, edgeToChild);
                }
                if (truthAssumption && elseCond != null) {
                    currentBlock.addStatement(new Statement.SimpleStatement(edgeToChild, (String)elseCond));
                    currentBlock.addStatement(((ARGEdge)result.get(0)).getCurrentBlock());
                }
                ARGEdge newEdge = new ARGEdge(currentElement, child, edgeToChild, newBlock);
                if (truthAssumption) {
                    result.add(0, newEdge);
                } else {
                    result.add(newEdge);
                }
                previousTruthAssumption = truthAssumption;
            }
            for (int i = result.size() - 1; i >= 0; --i) {
                ARGEdge e = (ARGEdge)result.get(i);
                this.pushToWaitlist(waitlist, e.getParentElement(), e.getChildElement(), e.getCfaEdge(), e.getCurrentBlock());
            }
        } else {
            this.handleMultiBranching(currentElement, waitlist, currentBlock, childrenOfElement);
        }
    }

    private void handleMultiBranching(ARGState currentElement, Deque<ARGEdge> waitlist, Statement.CompoundStatement currentBlock, Collection<ARGState> childrenOfElement) {
        int count = 0;
        for (ARGState child : childrenOfElement) {
            CFAEdge edgeToChild = currentElement.getEdgeToChild(child);
            LinkedHashSet<CExpression> conditions = new LinkedHashSet<CExpression>();
            if (edgeToChild instanceof CAssumeEdge) {
                CAssumeEdge assumeEdge = (CAssumeEdge)edgeToChild;
                if (assumeEdge.getTruthAssumption()) {
                    conditions.add(assumeEdge.getExpression());
                } else {
                    try {
                        conditions.add(this.cBinaryExpressionBuilder.negateExpressionAndSimplify(assumeEdge.getExpression()));
                    }
                    catch (UnrecognizedCodeException e) {
                        throw new AssertionError("negating an expression should never throw an exception", e);
                    }
                }
            }
            String cond = count == 0 ? "if (__VERIFIER_nondet_bool())" : (count != childrenOfElement.size() ? "else if (__VERIFIER_nondet_bool())" : " else ");
            Statement.CompoundStatement newBlock = this.addIfStatement(currentBlock, cond, edgeToChild);
            if (!conditions.isEmpty()) {
                StringJoiner joiner = new StringJoiner(" && ", "__VERIFIER_assume(", ");");
                conditions.stream().map(x -> x.toQualifiedASTString()).forEach(joiner::add);
                newBlock.addStatement(new Statement.SimpleStatement(edgeToChild, joiner.toString()));
            }
            this.pushToWaitlist(waitlist, currentElement, child, edgeToChild, newBlock);
            ++count;
        }
    }

    private boolean getRealTruthAssumption(CAssumeEdge assumption) {
        return assumption.isSwapped() != assumption.getTruthAssumption();
    }

    private void pushToWaitlist(Deque<ARGEdge> pWaitlist, ARGState pCurrentElement, ARGState pChild, CFAEdge pEdgeToChild, Statement.CompoundStatement pCurrentBlock) {
        assert (!pChild.isDestroyed());
        pWaitlist.push(new ARGEdge(pCurrentElement, pChild, pEdgeToChild, pCurrentBlock));
    }

    private Statement.CompoundStatement addIfStatement(Statement.CompoundStatement block, String conditionCode, CFAEdge pOrigin) {
        block.addStatement(new Statement.SimpleStatement(pOrigin, conditionCode));
        Statement.CompoundStatement newBlock = new Statement.CompoundStatement(block);
        block.addStatement(newBlock);
        return newBlock;
    }

    private void generateLabel(ARGState currentElement, Statement.CompoundStatement block) {
        if (!currentElement.getCoveredByThis().isEmpty() || this.mergeElements.contains(currentElement)) {
            if (this.copyValuesForGoto.containsKey(currentElement)) {
                this.addTmpAssignments(block, this.copyValuesForGoto.get(currentElement), currentElement.getStateId(), true);
                this.addLabel(block, currentElement);
                this.reassignTmpValues(block, this.copyValuesForGoto.get(currentElement), currentElement.getStateId());
            } else {
                this.addLabel(block, currentElement);
            }
        }
    }

    private void reassignTmpValues(Statement.CompoundStatement block, List<CDeclaration> varDecList, int pId) {
        for (int i = 0; i < varDecList.size(); ++i) {
            CVariableDeclaration varDec = (CVariableDeclaration)varDecList.get(i);
            String tmpVarName = TMPVARPREFIX + pId + "_" + i;
            block.addStatement(new Statement.SimpleStatement(varDec.getQualifiedName().replace("::", "__") + " = " + tmpVarName + ";"));
        }
    }

    private void addLabel(Statement.CompoundStatement pBlock, ARGState pCurrentElement) {
        pBlock.addStatement(new Statement.SimpleStatement("label_" + pCurrentElement.getStateId() + ":; "));
    }

    private void addTmpAssignments(Statement.CompoundStatement block, List<CDeclaration> varDecList, int pId, boolean addToGlobalList) {
        for (int i = 0; i < varDecList.size(); ++i) {
            CVariableDeclaration varDec = (CVariableDeclaration)varDecList.get(i);
            String tmpVarName = TMPVARPREFIX + pId + "_" + i;
            if (addToGlobalList) {
                this.globalDefinitionsList.add(varDec.getType().toASTString(tmpVarName) + ";");
            }
            block.addStatement(new Statement.SimpleStatement(tmpVarName + " = " + varDec.getQualifiedName().replace("::", "__") + ";"));
        }
    }

    private void handleEdge(ARGEdge nextEdge, Deque<ARGEdge> waitlist) throws CPAException {
        ARGState parentElement = nextEdge.getParentElement();
        ARGState childElement = nextEdge.getChildElement();
        CFAEdge edge = nextEdge.getCfaEdge();
        Statement.CompoundStatement currentBlock = nextEdge.getCurrentBlock();
        currentBlock = this.processEdge(parentElement, childElement, edge, currentBlock);
        if (childElement.getParents().size() > 1) {
            this.mergeElements.add(childElement);
        }
        if (!this.discoveredElements.contains(childElement)) {
            this.getRelevantChildrenOfElement(childElement, waitlist, currentBlock);
        } else {
            if (this.copyValuesForGoto.containsKey(childElement)) {
                this.addTmpAssignments(currentBlock, this.copyValuesForGoto.get(childElement), childElement.getStateId(), false);
            }
            currentBlock.addStatement(new Statement.SimpleStatement(nextEdge.getCfaEdge(), "goto label_" + childElement.getStateId() + ";"));
        }
    }

    private Statement.CompoundStatement processEdge(ARGState currentElement, ARGState childElement, CFAEdge edge, Statement.CompoundStatement currentBlock) throws CPAException {
        Statement afterTarget;
        AbstractCFAEdge returnEdge;
        if (edge instanceof CFunctionCallEdge) {
            currentBlock = this.processFunctionCall(edge, currentBlock);
        } else if (edge instanceof CReturnStatementEdge) {
            returnEdge = (CReturnStatementEdge)edge;
            if (((CReturnStatementEdge)returnEdge).getExpression() != null && ((CReturnStatementEdge)returnEdge).getExpression().isPresent()) {
                String returnVar;
                String retval = ((CReturnStatementEdge)returnEdge).getExpression().orElseThrow().toQualifiedASTString();
                if (childElement.isCovered()) {
                    returnVar = " __return_" + this.getCovering(childElement).getStateId();
                } else {
                    returnVar = " __return_" + childElement.getStateId();
                    this.addGlobalReturnValueDecl((CReturnStatementEdge)returnEdge, childElement.getStateId());
                }
                currentBlock.addStatement(new Statement.SimpleStatement(edge, returnVar + " = " + retval + ";"));
            }
        } else if (edge instanceof CFunctionReturnEdge) {
            returnEdge = (CFunctionReturnEdge)edge;
            currentBlock = this.processReturnStatementCall(((CFunctionReturnEdge)returnEdge).getSummaryEdge(), currentBlock, currentElement.getStateId());
        } else if (edge == null) {
            List<CFAEdge> innerEdges = currentElement.getEdgesToChild(childElement);
            StringBuilder edgeStatementCodes = new StringBuilder();
            for (CFAEdge innerEdge : innerEdges) {
                assert (innerEdge.getEdgeType() != CFAEdgeType.AssumeEdge) : "Unexpected assume edge in dynamic multi edge " + innerEdge;
                assert (!(innerEdge instanceof CFunctionCallEdge) && !(innerEdge instanceof CFunctionReturnEdge)) : "Unexpected edge " + innerEdge + " in dynmaic multi edge";
                if (innerEdge instanceof CReturnStatementEdge) {
                    String returnVar;
                    assert (innerEdges.get(innerEdges.size() - 1) == innerEdge);
                    CReturnStatementEdge returnEdge2 = (CReturnStatementEdge)innerEdge;
                    String retval = returnEdge2.getExpression().orElseThrow().toQualifiedASTString();
                    if (childElement.isCovered()) {
                        returnVar = " __return_" + this.getCovering(childElement).getStateId();
                    } else {
                        returnVar = " __return_" + childElement.getStateId();
                        this.addGlobalReturnValueDecl(returnEdge2, childElement.getStateId());
                    }
                    edgeStatementCodes.append(returnVar + " = " + retval + ";");
                } else {
                    edgeStatementCodes.append(this.processSimpleEdge(innerEdge));
                }
                edgeStatementCodes.append("\n");
            }
            currentBlock.addStatement(new Statement.SimpleStatement(edge, edgeStatementCodes.toString()));
        } else if (this.mustHandleDefaultReturn(edge)) {
            this.processDefaultReturn((CFunctionDeclaration)((FunctionExitNode)edge.getSuccessor()).getEntryNode().getFunctionDefinition(), childElement.getStateId());
        } else {
            String statement = this.processSimpleEdge(edge);
            if (!statement.isEmpty()) {
                currentBlock.addStatement(new Statement.SimpleStatement(edge, statement));
            }
        }
        this.handleAssumptions(childElement, currentBlock);
        if (childElement.isTarget() && (afterTarget = this.processTargetState(childElement, edge)) != null) {
            currentBlock.addStatement(afterTarget);
        }
        return currentBlock;
    }

    private void handleAssumptions(ARGState childElement, Statement.CompoundStatement currentBlock) {
        if (this.config.doAddAssumptions()) {
            ArrayList assumptions = new ArrayList();
            AbstractStates.asIterable(childElement).filter(AbstractStateWithAssumptions.class).transform(x -> x.getAssumptions()).forEach(x -> assumptions.addAll(x));
            if (!assumptions.isEmpty()) {
                StringJoiner joiner = new StringJoiner(" && ", "__VERIFIER_assume(", ");");
                assumptions.stream().map(x -> x.toQualifiedASTString()).forEach(joiner::add);
                String statement = joiner.toString();
                currentBlock.addStatement(new Statement.SimpleStatement(statement));
            }
        }
    }

    private boolean mustHandleDefaultReturn(CFAEdge pEdge) {
        return pEdge.getSuccessor() instanceof FunctionExitNode && pEdge.getDescription().equals(DEFAULTRETURN);
    }

    private ARGState getCovering(ARGState pCovered) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ARGState current = pCovered;
        while (current.isCovered()) {
            current = current.getCoveringState();
            Preconditions.checkState((boolean)seen.add(current), (Object)"Covering relation in ARG contains circles");
        }
        return current;
    }

    private void addGlobalReturnValueDecl(CReturnStatementEdge pReturnEdge, int pElementId) {
        String varName = "__return_" + pElementId;
        if (pReturnEdge.getSuccessor().getNumLeavingEdges() == 0) {
            this.globalDefinitionsList.add("int " + varName + ";");
        } else {
            CFunctionReturnEdge functionReturnEdge = (CFunctionReturnEdge)pReturnEdge.getSuccessor().getLeavingEdge(0);
            CFANode functionDefNode = functionReturnEdge.getSummaryEdge().getPredecessor();
            assert (functionDefNode.getNumLeavingEdges() == 1);
            assert (functionDefNode.getLeavingEdge(0) instanceof CFunctionCallEdge);
            CFunctionCallEdge callEdge = (CFunctionCallEdge)functionDefNode.getLeavingEdge(0);
            CFunctionEntryNode fn = callEdge.getSuccessor();
            CType retType = fn.getFunctionDefinition().getType().getReturnType();
            String returnType = retType instanceof CArrayType ? ((CArrayType)retType).toQualifiedASTString(varName) : retType.toASTString(varName);
            this.globalDefinitionsList.add(returnType + ";");
        }
    }

    private void processDefaultReturn(CFunctionDeclaration pFunDecl, int pElementId) {
        CType returnType = pFunDecl.getType().getReturnType();
        if (!(returnType instanceof CVoidType)) {
            String varName = "__return_" + pElementId;
            if (returnType instanceof CArrayType) {
                this.globalDefinitionsList.add(((CArrayType)returnType).toQualifiedASTString(varName) + ";");
            } else {
                this.globalDefinitionsList.add(returnType.toASTString(varName) + ";");
            }
        }
    }

    private String processSimpleEdge(CFAEdge pCFAEdge) throws CPAException {
        if (pCFAEdge == null) {
            return "";
        }
        switch (pCFAEdge.getEdgeType()) {
            case BlankEdge: {
                break;
            }
            case AssumeEdge: {
                break;
            }
            case StatementEdge: {
                CStatementEdge lStatementEdge = (CStatementEdge)pCFAEdge;
                String statementText = lStatementEdge.getStatement().toQualifiedASTString();
                if (this.deleteAssertFail && statementText.startsWith(ASSERTFAIL)) {
                    return "";
                }
                return statementText + (statementText.endsWith(";") ? "" : ";");
            }
            case DeclarationEdge: {
                Object declaration;
                CDeclarationEdge lDeclarationEdge = (CDeclarationEdge)pCFAEdge;
                if (lDeclarationEdge.getDeclaration().toQualifiedASTString().contains("__CPAchecker_TMP_")) {
                    declaration = lDeclarationEdge.getDeclaration().toQualifiedASTString();
                } else {
                    CVariableDeclaration varDecl;
                    declaration = lDeclarationEdge.getDeclaration().toQualifiedASTString();
                    if (lDeclarationEdge.getDeclaration() instanceof CVariableDeclaration && (varDecl = (CVariableDeclaration)lDeclarationEdge.getDeclaration()).getType() instanceof CArrayType && varDecl.getInitializer() instanceof CInitializerExpression) {
                        int assignAfterPos = ((String)declaration).indexOf("=") + 1;
                        declaration = ((String)declaration).substring(0, assignAfterPos) + "{" + ((String)declaration).substring(assignAfterPos, ((String)declaration).lastIndexOf(";")) + "};";
                    }
                    if (((String)declaration).contains(",")) {
                        for (CFAEdge predEdge : CFAUtils.enteringEdges(pCFAEdge.getPredecessor())) {
                            if (!predEdge.getRawStatement().equals(lDeclarationEdge.getDeclaration().toASTString())) continue;
                            declaration = "";
                            break;
                        }
                    }
                    if (this.config.doIncludeHeader() && ((String)declaration).contains("assert") && lDeclarationEdge.getDeclaration() instanceof CFunctionDeclaration) {
                        declaration = "";
                    }
                }
                if (((String)declaration).contains("org.eclipse.cdt.internal.core.dom.parser.ProblemType@")) {
                    throw new CPAException("Failed to translate ARG into program because a type could not be properly resolved.");
                }
                if (lDeclarationEdge.getDeclaration().isGlobal()) {
                    this.globalDefinitionsList.add((String)declaration + (((String)declaration).endsWith(";") ? "" : ";"));
                    break;
                }
                return declaration;
            }
            case CallToReturnEdge: {
                throw new AssertionError((Object)("CallToReturnEdge in counterexample path: " + pCFAEdge));
            }
            default: {
                throw new AssertionError((Object)("Unexpected edge " + pCFAEdge + " of type " + pCFAEdge.getEdgeType()));
            }
        }
        return "";
    }

    private Statement.CompoundStatement processFunctionCall(CFAEdge pCFAEdge, Statement.CompoundStatement currentBlock) {
        Statement.InlinedFunction newBlock = new Statement.InlinedFunction(currentBlock);
        currentBlock.addStatement(newBlock);
        CFunctionCallEdge lFunctionCallEdge = (CFunctionCallEdge)pCFAEdge;
        List<CExpression> actualParams = lFunctionCallEdge.getArguments();
        CFunctionEntryNode fn = lFunctionCallEdge.getSuccessor();
        List<CParameterDeclaration> formalParams = fn.getFunctionParameters();
        ArrayList<Statement.SimpleStatement> actualParamAssignStatements = new ArrayList<Statement.SimpleStatement>();
        ArrayList<Statement.SimpleStatement> formalParamAssignStatements = new ArrayList<Statement.SimpleStatement>();
        int i = 0;
        for (CParameterDeclaration cParameterDeclaration : formalParams) {
            String formalParamSignature = cParameterDeclaration.toQualifiedASTString();
            String actualParamSignature = actualParams.get(i++).toQualifiedASTString();
            String tempVariableName = TMPVARPREFIX + this.getFreshIndex();
            String tempVariableType = cParameterDeclaration.getType().toASTString(tempVariableName);
            actualParamAssignStatements.add(new Statement.SimpleStatement(pCFAEdge, tempVariableType + ";"));
            actualParamAssignStatements.add(new Statement.SimpleStatement(pCFAEdge, tempVariableName + " = " + actualParamSignature + ";"));
            formalParamAssignStatements.add(new Statement.SimpleStatement(pCFAEdge, formalParamSignature + ";"));
            formalParamAssignStatements.add(new Statement.SimpleStatement(pCFAEdge, cParameterDeclaration.getQualifiedName().replace("::", "__") + " = " + tempVariableName + ";"));
        }
        for (Statement statement : actualParamAssignStatements) {
            newBlock.addStatement(statement);
        }
        for (Statement statement : formalParamAssignStatements) {
            newBlock.addStatement(statement);
        }
        return newBlock;
    }

    private Statement.CompoundStatement processReturnStatementCall(CFunctionSummaryEdge pEdge, Statement.CompoundStatement pCurrentBlock, int id) {
        CFunctionCall retExp = pEdge.getExpression();
        if (retExp instanceof CFunctionCallStatement) {
            return this.getBlockAfterEndOfFunction(pCurrentBlock);
        }
        if (retExp instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement exp = (CFunctionCallAssignmentStatement)retExp;
            String returnVar = "__return_" + id;
            String leftHandSide = exp.getLeftHandSide().toQualifiedASTString();
            pCurrentBlock = this.getBlockAfterEndOfFunction(pCurrentBlock);
            pCurrentBlock.addStatement(new Statement.SimpleStatement(pEdge, leftHandSide + " = " + returnVar + ";"));
            return pCurrentBlock;
        }
        throw new AssertionError((Object)"unknown function exit expression");
    }

    private Statement.CompoundStatement getBlockAfterEndOfFunction(Statement.CompoundStatement currentBlock) {
        switch (this.config.doHandleCompoundStatementAtEndOfFunction()) {
            case CLOSEFUNCTIONBLOCK: {
                while (!(currentBlock instanceof Statement.InlinedFunction)) {
                    currentBlock = currentBlock.getSurroundingBlock();
                }
                return currentBlock.getSurroundingBlock();
            }
            case ADDNEWBLOCK: {
                currentBlock = new Statement.CompoundStatement(currentBlock);
                currentBlock.getSurroundingBlock().addStatement(currentBlock);
                return currentBlock;
            }
        }
        return currentBlock;
    }

    private @Nullable Statement processTargetState(ARGState pTargetState, CFAEdge pEdgeToTarget) {
        switch (this.config.getTargetStrategy()) {
            case RUNTIMEVERIFICATION: {
                this.logger.log(Level.ALL, new Object[]{"HALT for line no ", pEdgeToTarget.getLineNumber()});
                return new Statement.SimpleStatement(pEdgeToTarget, "HALT" + pTargetState.getStateId() + ": goto HALT" + pTargetState.getStateId() + ";");
            }
            case ASSERTFALSE: {
                return new Statement.SimpleStatement(pEdgeToTarget, "assert(0);");
            }
            case FRAMACPRAGMA: {
                if (this.addPragmaAfter.contains(pTargetState)) {
                    return new Statement.SimpleStatement(pEdgeToTarget, "/*@ slice pragma ctrl; */");
                }
                return null;
            }
            case VERIFIERERROR: {
                return new Statement.SimpleStatement(pEdgeToTarget, "reach_error();");
            }
            case REACHASMEMSAFETY: {
                return new Statement.SimpleStatement("{int i =  *(int *)0;}");
            }
            case REACHASOVERFLOW: {
                return new Statement.SimpleStatement(pEdgeToTarget, "-INT_MIN;");
            }
            case REACHASTERMINATION: {
                return new Statement.SimpleStatement(pEdgeToTarget, "while (1) {}");
            }
        }
        return null;
    }

    private int getFreshIndex() {
        return ++this.freshIndex;
    }

    private Map<ARGState, List<CDeclaration>> identifyDeclarationProblems(ARGState root) {
        HashSet<ARGState> visited = new HashSet<ARGState>();
        ArrayDeque<Pair<ARGState, DeclarationInfo>> waitlist = new ArrayDeque<Pair<ARGState, DeclarationInfo>>();
        HashMultimap decProblems = HashMultimap.create();
        waitlist.push(Pair.of(root, new DeclarationInfo((ImmutableMap<CDeclaration, String>)ImmutableMap.of(), (ImmutableList<ImmutableMap<CDeclaration, String>>)ImmutableList.of())));
        while (!waitlist.isEmpty()) {
            Pair current = (Pair)waitlist.pop();
            ARGState parent = (ARGState)current.getFirst();
            ArrayList<Pair<ARGState, DeclarationInfo>> assumeInfo = new ArrayList<Pair<ARGState, DeclarationInfo>>(2);
            if (!visited.add(parent)) continue;
            for (ARGState child : parent.getChildren()) {
                DeclarationInfo decInfo;
                CFAEdge edge = parent.getEdgeToChild(child);
                if (edge == null) {
                    decInfo = (DeclarationInfo)current.getSecond();
                    for (CFAEdge edgeM : parent.getEdgesToChild(child)) {
                        decInfo = this.handleDecInfoForEdge(edgeM, parent, child, decInfo);
                    }
                } else {
                    decInfo = this.handleDecInfoForEdge(edge, parent, child, (DeclarationInfo)current.getSecond());
                }
                if (edge instanceof CAssumeEdge) {
                    if (this.getRealTruthAssumption((CAssumeEdge)edge)) {
                        assumeInfo.add(Pair.of(child, decInfo));
                    } else {
                        assumeInfo.add(0, Pair.of(child, decInfo));
                    }
                } else {
                    waitlist.push(Pair.of(child, decInfo));
                }
                if (!child.isCovered() && child.getParents().isEmpty()) continue;
                decProblems.put((Object)this.getCovering(child), decInfo.currentFuncDecInfo);
            }
            waitlist.addAll(assumeInfo);
        }
        HashMap probVarDec = Maps.newHashMapWithExpectedSize((int)decProblems.keySet().size());
        for (ARGState key : decProblems.keySet()) {
            ArrayList probs = new ArrayList(decProblems.get((Object)key));
            ArrayList<CDeclaration> probVars = new ArrayList<CDeclaration>();
            for (Map.Entry prob : ((Map)probs.get(0)).entrySet()) {
                boolean containAll = true;
                boolean different = false;
                for (int i = 1; i < probs.size(); ++i) {
                    if (!((Map)probs.get(i)).containsKey(prob.getKey())) {
                        containAll = false;
                        break;
                    }
                    if (((String)((Map)probs.get(i)).get(prob.getKey())).equals(prob.getValue())) continue;
                    different = true;
                }
                if (!containAll || !different) continue;
                probVars.add((CDeclaration)prob.getKey());
            }
            if (probVars.isEmpty()) continue;
            probVarDec.put(key, probVars);
        }
        return probVarDec;
    }

    private DeclarationInfo handleDecInfoForEdge(CFAEdge edge, ARGState pred, ARGState succ, DeclarationInfo decInfo) {
        if (edge instanceof CFunctionCallEdge) {
            return decInfo.fromFunctionCall((CFunctionCallEdge)edge, pred.getStateId() + ":" + succ.getStateId());
        }
        if (edge instanceof CFunctionReturnEdge) {
            return decInfo.fromFunctionReturn();
        }
        if (edge instanceof CDeclarationEdge && ((CDeclarationEdge)edge).getDeclaration() instanceof CVariableDeclaration && !((CDeclarationEdge)edge).getDeclaration().isGlobal()) {
            return decInfo.addNewDeclarationInfo(((CDeclarationEdge)edge).getDeclaration(), pred.getStateId() + ":" + succ.getStateId());
        }
        return decInfo;
    }

    private static class DeclarationInfo {
        private final ImmutableMap<CDeclaration, String> currentFuncDecInfo;
        private final ImmutableList<ImmutableMap<CDeclaration, String>> calleeFunDecInfos;

        public DeclarationInfo(ImmutableMap<CDeclaration, String> funDec, ImmutableList<ImmutableMap<CDeclaration, String>> calleesFunInfo) {
            this.currentFuncDecInfo = funDec;
            this.calleeFunDecInfos = calleesFunInfo;
        }

        public DeclarationInfo addNewDeclarationInfo(CDeclaration dec, String decId) {
            ImmutableMap newFunDecInfo;
            if (this.currentFuncDecInfo.containsKey((Object)dec)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)dec, (Object)decId);
                for (Map.Entry entry : this.currentFuncDecInfo.entrySet()) {
                    if (((CDeclaration)entry.getKey()).equals(dec)) continue;
                    builder.put(entry);
                }
                newFunDecInfo = builder.buildOrThrow();
            } else {
                newFunDecInfo = ImmutableMap.builder().putAll(this.currentFuncDecInfo).put((Object)dec, (Object)decId).buildOrThrow();
            }
            return new DeclarationInfo((ImmutableMap<CDeclaration, String>)newFunDecInfo, this.calleeFunDecInfos);
        }

        public DeclarationInfo fromFunctionCall(CFunctionCallEdge callEdge, String decId) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (CParameterDeclaration paramDecl : callEdge.getSummaryEdge().getExpression().getFunctionCallExpression().getDeclaration().getParameters()) {
                builder.put((Object)paramDecl.asVariableDeclaration(), (Object)decId);
            }
            return new DeclarationInfo((ImmutableMap<CDeclaration, String>)builder.buildOrThrow(), (ImmutableList<ImmutableMap<CDeclaration, String>>)ImmutableList.builder().addAll(this.calleeFunDecInfos).add(this.currentFuncDecInfo).build());
        }

        public DeclarationInfo fromFunctionReturn() {
            Preconditions.checkState((!this.calleeFunDecInfos.isEmpty() ? 1 : 0) != 0);
            return new DeclarationInfo((ImmutableMap<CDeclaration, String>)((ImmutableMap)this.calleeFunDecInfos.get(this.calleeFunDecInfos.size() - 1)), (ImmutableList<ImmutableMap<CDeclaration, String>>)this.calleeFunDecInfos.subList(0, this.calleeFunDecInfos.size() - 1));
        }
    }

    public static enum BlockTreatmentAtFunctionEnd {
        CLOSEFUNCTIONBLOCK,
        ADDNEWBLOCK,
        KEEPBLOCK;

    }

    public static enum TargetTreatment {
        NONE,
        RUNTIMEVERIFICATION,
        ASSERTFALSE,
        FRAMACPRAGMA,
        VERIFIERERROR,
        REACHASMEMSAFETY,
        REACHASOVERFLOW,
        REACHASTERMINATION;

    }

    private static class ARGEdge {
        private final ARGState parent;
        private final ARGState child;
        private final CFAEdge cfaEdge;
        private final Statement.CompoundStatement currentBlock;

        public ARGEdge(ARGState pParent, ARGState pChild, CFAEdge pCfaEdge, Statement.CompoundStatement pCurrentBlock) {
            this.parent = pParent;
            this.child = pChild;
            this.cfaEdge = pCfaEdge;
            this.currentBlock = pCurrentBlock;
        }

        public ARGState getParentElement() {
            return this.parent;
        }

        public ARGState getChildElement() {
            return this.child;
        }

        public CFAEdge getCfaEdge() {
            return this.cfaEdge;
        }

        public Statement.CompoundStatement getCurrentBlock() {
            return this.currentBlock;
        }
    }
}

