/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;

class BasicBlock {
    private static final String SINGLE_INDENT = "  ";
    private final int stateId;
    private boolean condition;
    private boolean isClosedBefore = false;
    private Set<ADeclarationEdge> declarations = new HashSet<ADeclarationEdge>();
    private final String firstCodeLine;
    private final List<Object> codeList;

    public BasicBlock(int pElementId, String pFunctionName) {
        this.stateId = pElementId;
        this.codeList = new ArrayList<Object>();
        this.firstCodeLine = pFunctionName;
    }

    public BasicBlock(int pElementId, CAssumeEdge pEdge, String pConditionString) {
        this.stateId = pElementId;
        this.codeList = new ArrayList<Object>();
        this.condition = pEdge.getTruthAssumption();
        this.firstCodeLine = pConditionString;
    }

    public int getStateId() {
        return this.stateId;
    }

    public boolean isCondition() {
        return this.condition;
    }

    public boolean isClosedBefore() {
        return this.isClosedBefore;
    }

    public void setClosedBefore(boolean pIsClosedBefore) {
        this.isClosedBefore = pIsClosedBefore;
    }

    public void write(Object pStatement) {
        if (!(pStatement instanceof String) || !((String)pStatement).isEmpty()) {
            this.codeList.add(pStatement);
        }
    }

    void addDeclaration(ADeclarationEdge declarationEdge) {
        this.declarations.add(declarationEdge);
    }

    boolean hasDeclaration(ADeclarationEdge declarationEdge) {
        return this.declarations.contains(declarationEdge);
    }

    public String getCode() {
        return this.getCode("").toString();
    }

    private StringBuilder getCode(String pIndent) {
        StringBuilder ret = new StringBuilder();
        ret.append(pIndent);
        ret.append(this.firstCodeLine);
        ret.append(" {\n");
        String indent = pIndent + SINGLE_INDENT;
        for (Object obj : this.codeList) {
            if (obj instanceof String) {
                ret.append(indent);
                ret.append((String)obj);
            } else if (obj instanceof BasicBlock) {
                ret.append((CharSequence)((BasicBlock)obj).getCode(indent));
            } else {
                throw new AssertionError();
            }
            ret.append("\n");
        }
        ret.append(pIndent);
        ret.append("}\n");
        return ret;
    }

    public String toString() {
        return "Element id: " + this.stateId + " Condition: " + this.condition + " .. is closed " + this.isClosedBefore;
    }
}

