/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.cwriter.FormulaToCExpressionConverter;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cinvariants")
public class CExpressionInvariantExporter {
    @Option(secure=true, description="Attempt to simplify the invariant before exporting [may be very expensive].")
    private boolean simplify = false;
    @Option(secure=true, description="If enabled only export invariants for specified lines.")
    private boolean onlyForSpecifiedLines = false;
    @Option(secure=true, name="forLines", description="Specify lines for which an invariant should be written. Lines are specified as comma separated list of individual lines x and line ranges x-y.")
    private String exportInvariantsForLines = "";
    @Option(secure=true, name="external.file", description="File name for exporting invariants. Only supported if invariant export for specified lines is enabled.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path externalInvariantFile = null;
    private final PathTemplate prefix;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final FormulaToCExpressionConverter formulaToCExpressionConverter;
    private final InductiveWeakeningManager inductiveWeakeningManager;
    private final LogManager logger;

    public CExpressionInvariantExporter(Configuration pConfiguration, LogManager pLogManager, ShutdownNotifier pShutdownNotifier, PathTemplate pPrefix) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this);
        this.logger = pLogManager;
        this.prefix = pPrefix;
        Solver solver = Solver.create(pConfiguration, pLogManager, pShutdownNotifier);
        this.fmgr = solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.formulaToCExpressionConverter = new FormulaToCExpressionConverter(this.fmgr);
        this.inductiveWeakeningManager = new InductiveWeakeningManager(new WeakeningOptions(pConfiguration), solver, pLogManager, pShutdownNotifier);
    }

    public void exportInvariant(CFA pCfa, UnmodifiableReachedSet pReachedSet) throws IOException, InterruptedException, SolverException {
        if (this.onlyForSpecifiedLines) {
            if (this.exportInvariantsForLines != null && !pReachedSet.hasWaitingState()) {
                if (this.externalInvariantFile == null) {
                    this.exportInvariantsForRequestedLinesToSourceFileCopies(pReachedSet, pCfa.getFileNames());
                } else {
                    this.exportInvariantsForRequestedLinesToFile(pReachedSet, pCfa.getFileNames().size() == 1);
                }
            }
        } else {
            for (Path program : pCfa.getFileNames()) {
                Path trimmedFilename = program.getFileName();
                if (trimmedFilename == null) continue;
                Writer output = IO.openOutputFile((Path)this.prefix.getPath(new Object[]{trimmedFilename.toString()}), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try {
                    this.writeProgramWithInvariants(output, program, pReachedSet);
                }
                finally {
                    if (output == null) continue;
                    output.close();
                }
            }
        }
    }

    private void writeProgramWithInvariants(Appendable out, Path filename, UnmodifiableReachedSet pReachedSet) throws IOException, InterruptedException, SolverException {
        Map<Integer, BooleanFormula> reporting = this.getInvariantsForFile(pReachedSet, filename);
        int lineNo = 0;
        try (BufferedReader reader = Files.newBufferedReader(filename);){
            String line;
            while ((line = reader.readLine()) != null) {
                Optional<String> invariant = this.getInvariantForLine(lineNo, reporting);
                if (invariant.isPresent()) {
                    out.append("__VERIFIER_assume(").append(invariant.orElseThrow()).append(");\n");
                }
                out.append(line).append('\n');
                ++lineNo;
            }
        }
    }

    private Optional<String> getInvariantForLine(int lineNo, Map<Integer, BooleanFormula> reporting) throws InterruptedException, SolverException {
        BooleanFormula formula = reporting.get(lineNo);
        if (formula == null) {
            return Optional.empty();
        }
        if (this.simplify) {
            formula = this.simplifyInvariant(formula);
        }
        return Optional.of(this.formulaToCExpressionConverter.formulaToCExpression(formula));
    }

    private Map<Integer, BooleanFormula> getInvariantsForFile(UnmodifiableReachedSet pReachedSet, Path filename) {
        HashMultimap byState = HashMultimap.create();
        for (AbstractState state : pReachedSet) {
            BooleanFormula reported;
            CFAEdge edge;
            FileLocation location;
            CFANode loc = AbstractStates.extractLocation(state);
            if (loc == null || loc.getNumEnteringEdges() <= 0 || !(location = (edge = loc.getEnteringEdge(0)).getFileLocation()).getFileName().equals(filename) || this.bfmgr.isTrue(reported = AbstractStates.extractReportedFormulas(this.fmgr, state))) continue;
            byState.put((Object)location.getStartingLineInOrigin(), (Object)reported);
        }
        return Maps.transformValues((Map)byState.asMap(), invariants -> this.bfmgr.or(invariants));
    }

    private BooleanFormula simplifyInvariant(BooleanFormula pInvariant) throws InterruptedException, SolverException {
        return this.inductiveWeakeningManager.removeRedundancies(pInvariant);
    }

    private void exportInvariantsForRequestedLinesToSourceFileCopies(UnmodifiableReachedSet pReachedSet, List<Path> sourceFiles) throws IOException, InterruptedException, SolverException {
        if (sourceFiles != null) {
            boolean withoutPrefix = sourceFiles.size() == 1;
            Set<Integer> requestedLines = this.parseRequestedLines();
            Map<Pair<String, Integer>, BooleanFormula> invariantsPerLine = this.extractInvariants(pReachedSet, requestedLines, withoutPrefix);
            String fileName = "";
            for (Path sourceFile : sourceFiles) {
                if (!withoutPrefix) {
                    fileName = sourceFile.getFileName().toString();
                }
                Writer output = IO.openOutputFile((Path)this.prefix.getPath(new Object[]{sourceFile.getFileName()}), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try (BufferedReader reader = Files.newBufferedReader(sourceFile);){
                    String line;
                    int counter = 1;
                    output.append("extern void __VERIFIER_assume(int expression);");
                    while ((line = reader.readLine()) != null) {
                        Pair<String, Integer> invariantKey;
                        if (invariantsPerLine.containsKey(invariantKey = Pair.of(fileName, counter++))) {
                            output.append("__VERIFIER_assume(").append(this.convertInvariantToSingleLineString(invariantsPerLine.get(invariantKey))).append(");\n");
                        }
                        output.append(line).append('\n');
                    }
                }
                finally {
                    if (output == null) continue;
                    output.close();
                }
            }
        }
    }

    private void exportInvariantsForRequestedLinesToFile(UnmodifiableReachedSet pReachedSet, boolean withoutPrefix) throws IOException, InterruptedException, SolverException {
        if (this.externalInvariantFile != null && this.exportInvariantsForLines != null && !pReachedSet.hasWaitingState()) {
            Set<Integer> requestedLines = this.parseRequestedLines();
            Map<Pair<String, Integer>, BooleanFormula> invariantsPerLine = this.extractInvariants(pReachedSet, requestedLines, withoutPrefix);
            try (Writer output = IO.openOutputFile((Path)this.externalInvariantFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                for (Map.Entry mapEntry : FluentIterable.from(invariantsPerLine.entrySet()).toSortedSet((entry1, entry2) -> this.compareInvariantKeys((Pair)entry1.getKey(), (Pair)entry2.getKey()))) {
                    this.writetExternalEntry(output, mapEntry);
                }
            }
        }
    }

    private Set<Integer> parseRequestedLines() {
        HashSet<Integer> requestedLines = new HashSet<Integer>();
        for (String line : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)this.exportInvariantsForLines)) {
            try {
                int posRangeSeparator = line.indexOf(45);
                if (0 < posRangeSeparator) {
                    int max = Integer.parseInt(line.substring(posRangeSeparator + 1));
                    for (int i = Integer.parseInt(line.substring(0, posRangeSeparator)); i <= max; ++i) {
                        requestedLines.add(i);
                    }
                    continue;
                }
                requestedLines.add(Integer.parseInt(line));
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARNING, new Object[]{"could not parse line number " + line + ", skipping!"});
            }
        }
        return requestedLines;
    }

    private Map<Pair<String, Integer>, BooleanFormula> extractInvariants(UnmodifiableReachedSet pReachedSet, Set<Integer> pRequestedLines, boolean withoutPrefix) {
        HashMultimap byState = HashMultimap.create();
        for (AbstractState state : pReachedSet) {
            BooleanFormula reported;
            CFAEdge edge;
            CFANode loc = AbstractStates.extractLocation(state);
            if (loc == null || loc.getNumLeavingEdges() <= 0 || !((edge = loc.getLeavingEdge(0)) instanceof AbstractCFAEdge) || edge instanceof BlankEdge || edge instanceof FunctionReturnEdge || edge instanceof FunctionSummaryEdge || edge instanceof ADeclarationEdge && ((ADeclarationEdge)edge).getDeclaration().isGlobal()) continue;
            int lineNumber = edge.getFileLocation().getStartingLineInOrigin();
            String sourceFileName = edge.getFileLocation().getNiceFileName() + ":";
            if (!pRequestedLines.contains(lineNumber) || this.bfmgr.isTrue(reported = AbstractStates.extractReportedFormulas(this.fmgr, state))) continue;
            byState.put(Pair.of(withoutPrefix ? "" : sourceFileName, lineNumber), (Object)reported);
        }
        return Maps.transformValues((Map)byState.asMap(), invariants -> this.bfmgr.or(invariants));
    }

    private int compareInvariantKeys(Pair<String, Integer> key1, Pair<String, Integer> key2) {
        if (key1.getFirst().equals(key2.getFirst())) {
            return Comparator.comparingInt(key -> (Integer)key.getSecond()).compare(key1, key2);
        }
        return key1.getFirst().compareTo(key2.getFirst());
    }

    private void writetExternalEntry(Writer output, Map.Entry<Pair<String, Integer>, BooleanFormula> pEntry) throws IOException, InterruptedException, SolverException {
        String BEFORE_TOKEN = "-";
        output.append('[');
        output.append(pEntry.getKey().getFirst());
        output.append(pEntry.getKey().getSecond().toString());
        output.append("-");
        output.append(',');
        output.append(this.convertInvariantToSingleLineString(pEntry.getValue()));
        output.append("]\n");
    }

    private String convertInvariantToSingleLineString(BooleanFormula pInvariant) throws InterruptedException, SolverException {
        if (this.simplify) {
            pInvariant = this.simplifyInvariant(pInvariant);
        }
        return this.formulaToCExpressionConverter.formulaToCExpression(pInvariant).replaceAll("\n", " ");
    }
}

