/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.cwriter.Statement;
import org.sosy_lab.cpachecker.util.cwriter.StatementWriter;
import org.sosy_lab.cpachecker.util.cwriter.TranslatorConfig;

public class CFAToCTranslator {
    private static final boolean NAMES_QUALIFIED = false;
    private final List<String> globalDefinitionsList = new ArrayList<String>();
    private final ListMultimap<CFANode, Statement> createdStatements = ArrayListMultimap.create();
    private Collection<Statement.FunctionDefinition> functions;
    private final TranslatorConfig config;

    public CFAToCTranslator(Configuration pConfig) throws InvalidConfigurationException {
        this.config = new TranslatorConfig(pConfig);
    }

    public String translateCfa(CFA pCfa) throws CPAException, InvalidConfigurationException, IOException {
        this.functions = new ArrayList<Statement.FunctionDefinition>(pCfa.getNumberOfFunctions());
        if (pCfa.getLanguage() != Language.C) {
            throw new InvalidConfigurationException("CFA can only be written to C for C programs, at the moment");
        }
        this.globalDefinitionsList.add("extern void abort();");
        for (FunctionEntryNode func : pCfa.getAllFunctionHeads()) {
            this.translate((CFunctionEntryNode)func);
        }
        return this.generateCCode();
    }

    private String generateCCode() throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (StatementWriter writer = StatementWriter.getWriter(buffer, this.config);){
            for (String globalDef : this.globalDefinitionsList) {
                writer.write(globalDef);
            }
            for (Statement.FunctionDefinition f : this.functions) {
                f.accept(writer);
            }
            String string = buffer.toString();
            return string;
        }
    }

    private void translate(CFunctionEntryNode pEntry) throws CPAException {
        ArrayDeque<NodeAndBlock> waitlist = new ArrayDeque<NodeAndBlock>();
        HashMultimap ingoingBlocks = HashMultimap.create();
        Statement.FunctionDefinition f = this.startFunction(pEntry);
        this.functions.add(f);
        for (CFAEdge relevant : this.getRelevantLeavingEdges(pEntry)) {
            CFANode succ = relevant.getSuccessor();
            this.pushToWaitlist(waitlist, new NodeAndBlock(succ, f.getFunctionBody()));
        }
        while (!waitlist.isEmpty()) {
            NodeAndBlock current = this.getNextElement(waitlist);
            CFANode currentNode = current.getNode();
            if (this.createdStatements.containsKey((Object)currentNode)) {
                current.getCurrentBlock().addStatement(this.createGoto(currentNode, currentNode));
                continue;
            }
            Statement.CompoundStatement originalBlock = current.getCurrentBlock();
            Statement.CompoundStatement currentBlock = this.getBlockToContinueWith(currentNode, originalBlock, ingoingBlocks.get((Object)currentNode));
            if (currentBlock != originalBlock) {
                current = new NodeAndBlock(currentNode, currentBlock);
            }
            ImmutableCollection<NodeAndBlock> nextNodes = this.handleNode(currentNode, currentBlock);
            for (NodeAndBlock next : nextNodes) {
                CFANode nextNode = next.getNode();
                ingoingBlocks.put((Object)nextNode, (Object)current);
                this.pushToWaitlist(waitlist, next);
            }
        }
    }

    private Statement createLabel(CFALabelNode pNode) {
        Statement.Label s = new Statement.Label(pNode.getLabel());
        this.createdStatements.put((Object)pNode, (Object)s);
        return s;
    }

    private Statement.CompoundStatement getBlockToContinueWith(CFANode pCurrentNode, Statement.CompoundStatement pCurrentBlock, Collection<NodeAndBlock> pEnteringBlocks) {
        boolean isEmptyElseAtEndOfBlock;
        if (CFAUtils.enteringEdges(pCurrentNode).size() <= 1 || pEnteringBlocks == null || pEnteringBlocks.size() <= 1) {
            return pCurrentBlock;
        }
        boolean bl = isEmptyElseAtEndOfBlock = pCurrentBlock.isEmpty() && pEnteringBlocks.stream().anyMatch(n -> this.isLastStatementOfBlock(pCurrentBlock, n.getCurrentBlock()));
        if (isEmptyElseAtEndOfBlock) {
            return pCurrentBlock.getSurroundingBlock();
        }
        if (this.isSameOuterBlockForAll(pEnteringBlocks)) {
            return ((NodeAndBlock)Iterables.getFirst(pEnteringBlocks, null)).getCurrentBlock().getSurroundingBlock();
        }
        return pCurrentBlock;
    }

    private boolean isSameOuterBlockForAll(Collection<NodeAndBlock> pBlocks) {
        return Collections3.allElementsEqual(pBlocks.stream().map(n -> n.getCurrentBlock().getSurroundingBlock()));
    }

    private boolean isLastStatementOfBlock(Statement.CompoundStatement pStatement, Statement.CompoundStatement pBlock) {
        return pBlock.equals(pStatement.getSurroundingBlock()) && pBlock.getLast().equals(pStatement);
    }

    private NodeAndBlock getNextElement(Deque<NodeAndBlock> pWaitlist) {
        NodeAndBlock current;
        NodeAndBlock lastElement = pWaitlist.peekLast();
        do {
            if ((current = pWaitlist.pollFirst()) == lastElement) {
                return current;
            }
            boolean allPredecessorsHandled = this.getPredecessorNodes(current.getNode()).stream().anyMatch(n -> !this.createdStatements.containsKey(n));
            if (allPredecessorsHandled) {
                return current;
            }
            pWaitlist.offer(current);
        } while (current != lastElement);
        return current;
    }

    private Statement createGoto(CFANode pCurrentNode, CFANode pTarget) {
        String go = "goto " + ((Statement)this.createdStatements.get((Object)pTarget).get(0)).getLabel() + ";";
        return this.createSimpleStatement(pCurrentNode, go);
    }

    private ImmutableCollection<NodeAndBlock> handleNode(CFANode pNode, Statement.CompoundStatement pBlock) throws CPAException {
        ImmutableList.Builder nextOnes = ImmutableList.builder();
        if (pNode instanceof CFATerminationNode || pNode.getNumLeavingEdges() == 0) {
            pBlock.addStatement(this.createSimpleStatement(pNode, "abort();"));
            return ImmutableList.of();
        }
        if (pNode instanceof CFALabelNode) {
            pBlock.addStatement(this.createLabel((CFALabelNode)pNode));
        }
        ImmutableCollection<Pair<CFAEdge, Statement.CompoundStatement>> outgoingEdges = this.handlePotentialBranching(pNode, pBlock);
        for (Pair p : outgoingEdges) {
            CFAEdge currentEdge = (CFAEdge)p.getFirst();
            Statement.CompoundStatement currentBlock = (Statement.CompoundStatement)p.getSecond();
            String statement = this.translateSimpleEdge(currentEdge);
            if (!statement.isEmpty()) {
                pBlock.addStatement(this.createSimpleStatement(pNode, statement, currentEdge));
            }
            CFANode successor = this.getSuccessorNode(currentEdge);
            nextOnes.add((Object)new NodeAndBlock(successor, currentBlock));
        }
        if (!this.createdStatements.containsKey((Object)pNode)) {
            pBlock.addStatement(this.createEmptyStatement(pNode));
        }
        return nextOnes.build();
    }

    private CFANode getSuccessorNode(CFAEdge pE) {
        if (pE.getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge)) {
            return ((CFunctionCallEdge)pE).getSummaryEdge().getSuccessor();
        }
        return pE.getSuccessor();
    }

    private FluentIterable<CFANode> getPredecessorNodes(CFANode pN) {
        FluentIterable predecessors = this.getRelevantEnteringEdges(pN).transform(e -> e.getPredecessor());
        if (pN.getEnteringSummaryEdge() != null) {
            predecessors = predecessors.append((Object[])new CFANode[]{pN.getEnteringSummaryEdge().getPredecessor()});
        }
        return predecessors;
    }

    private Statement.FunctionDefinition startFunction(CFunctionEntryNode pFunctionStartNode) {
        String lFunctionHeader = pFunctionStartNode.getFunctionDefinition().toASTString(false).replace(";", "");
        return new Statement.FunctionDefinition(lFunctionHeader, this.createCompoundStatement(pFunctionStartNode, null));
    }

    private FluentIterable<CFAEdge> getRelevantLeavingEdges(CFANode pNode) {
        return CFAUtils.leavingEdges(pNode).filter(e -> !(e instanceof FunctionReturnEdge)).filter(e -> !(e instanceof CFunctionSummaryStatementEdge));
    }

    private FluentIterable<CFAEdge> getRelevantEnteringEdges(CFANode pNode) {
        return CFAUtils.enteringEdges(pNode).filter(e -> !(e instanceof FunctionReturnEdge)).filter(e -> !(e instanceof CFunctionSummaryStatementEdge));
    }

    private ImmutableCollection<Pair<CFAEdge, Statement.CompoundStatement>> handlePotentialBranching(CFANode pNode, Statement.CompoundStatement pStartingBlock) {
        ImmutableList outgoingEdges = this.getRelevantLeavingEdges(pNode).toList();
        if (outgoingEdges.size() == 1) {
            CFAEdge edgeToChild = (CFAEdge)Iterables.getOnlyElement((Iterable)outgoingEdges);
            if (edgeToChild instanceof CAssumeEdge) {
                throw new IllegalStateException("Assume-edge without counterpart in CFA: " + edgeToChild);
            }
            return ImmutableSet.of(Pair.of(edgeToChild, pStartingBlock));
        }
        if (outgoingEdges.size() > 1) {
            assert (outgoingEdges.size() == 2) : "branches with more than two options not supported (was the program prepocessed with CIL?)";
            for (CFAEdge edgeToChild : outgoingEdges) {
                assert (edgeToChild instanceof CAssumeEdge) : "something wrong: branch in CFA without condition: " + edgeToChild;
            }
            ImmutableList.Builder branches = ImmutableList.builder();
            List<CFAEdge> ifAndElseEdge = new ArrayList<CFAEdge>((Collection<CFAEdge>)outgoingEdges);
            if (!this.getRealTruthAssumption((CAssumeEdge)ifAndElseEdge.get(0))) {
                ifAndElseEdge = this.swapElements(ifAndElseEdge);
            }
            for (CFAEdge currentEdge : ifAndElseEdge) {
                Object cond;
                CAssumeEdge assumeEdge = (CAssumeEdge)currentEdge;
                boolean truthAssumption = this.getRealTruthAssumption(assumeEdge);
                if (truthAssumption) {
                    assert (ifAndElseEdge.get(0) == currentEdge);
                    cond = assumeEdge.getTruthAssumption() ? "if (" + assumeEdge.getExpression().toASTString(false) + ")" : "if (!(" + assumeEdge.getExpression().toASTString(false) + "))";
                } else {
                    assert (ifAndElseEdge.get(1) == currentEdge);
                    cond = "else";
                }
                Statement.CompoundStatement newBlock = this.addIfStatementToBlock(pNode, pStartingBlock, (String)cond, currentEdge);
                branches.add(Pair.of(currentEdge, newBlock));
            }
            return branches.build();
        }
        return ImmutableSet.of();
    }

    private List<CFAEdge> swapElements(List<CFAEdge> pListWithTwoElements) {
        Preconditions.checkArgument((pListWithTwoElements.size() == 2 ? 1 : 0) != 0, (Object)"List must have exactly two arguments");
        ArrayList<CFAEdge> swapped = new ArrayList<CFAEdge>(2);
        swapped.add(pListWithTwoElements.get(1));
        swapped.add(pListWithTwoElements.get(0));
        return swapped;
    }

    private Statement.SimpleStatement createSimpleStatement(CFANode pNode, String pStatement, @Nullable CFAEdge pOrigin) {
        Statement.SimpleStatement st = new Statement.SimpleStatement(pOrigin, pStatement);
        this.createdStatements.put((Object)pNode, (Object)st);
        return st;
    }

    private Statement.SimpleStatement createSimpleStatement(CFANode pNode, String pStatement) {
        return this.createSimpleStatement(pNode, pStatement, null);
    }

    private Statement.CompoundStatement createCompoundStatement(CFANode pNode, Statement.CompoundStatement pOuterBlock) {
        Statement.CompoundStatement st = new Statement.CompoundStatement(pOuterBlock);
        this.createdStatements.put((Object)pNode, (Object)st);
        return st;
    }

    private Statement createEmptyStatement(CFANode pNode) {
        Statement.EmptyStatement s = new Statement.EmptyStatement();
        this.createdStatements.put((Object)pNode, (Object)s);
        return s;
    }

    private boolean getRealTruthAssumption(CAssumeEdge assumption) {
        return assumption.isSwapped() != assumption.getTruthAssumption();
    }

    private boolean hasMoreThanOneElement(FluentIterable<?> pIterable) {
        int count = 0;
        for (Object ignored : pIterable) {
            if (++count <= 1) continue;
            return false;
        }
        return true;
    }

    private void pushToWaitlist(Deque<NodeAndBlock> pWaitlist, NodeAndBlock pNodeAndBlock) {
        if (this.hasMoreThanOneElement(this.getPredecessorNodes(pNodeAndBlock.getNode()))) {
            assert (this.getPredecessorNodes(pNodeAndBlock.getNode()).stream().allMatch(arg_0 -> this.createdStatements.containsKey(arg_0)));
            pWaitlist.push(pNodeAndBlock);
        } else {
            pWaitlist.offer(pNodeAndBlock);
        }
    }

    private Statement.CompoundStatement addIfStatementToBlock(CFANode pNode, Statement.CompoundStatement block, String conditionCode, CFAEdge pOrigin) {
        block.addStatement(this.createSimpleStatement(pNode, conditionCode, pOrigin));
        Statement.CompoundStatement newBlock = this.createCompoundStatement(pNode, block);
        block.addStatement(newBlock);
        return newBlock;
    }

    private String translateSimpleEdge(CFAEdge pCFAEdge) throws CPAException {
        if (pCFAEdge == null) {
            return "";
        }
        switch (pCFAEdge.getEdgeType()) {
            case BlankEdge: 
            case AssumeEdge: {
                break;
            }
            case StatementEdge: 
            case ReturnStatementEdge: {
                String statementText = pCFAEdge.getCode();
                if (statementText.matches("^__CPAchecker_TMP_[0-9]+;?$")) {
                    return "";
                }
                return statementText + (statementText.endsWith(";") ? "" : ";");
            }
            case FunctionCallEdge: {
                String statement = ((CFunctionCallEdge)pCFAEdge).getSummaryEdge().getCode();
                return statement + (statement.endsWith(";") ? "" : ";");
            }
            case DeclarationEdge: {
                Object declaration;
                CDeclarationEdge lDeclarationEdge = (CDeclarationEdge)pCFAEdge;
                if (lDeclarationEdge.getDeclaration().toASTString(false).contains("__CPAchecker_TMP_")) {
                    declaration = lDeclarationEdge.getDeclaration().toASTString(false);
                } else {
                    CVariableDeclaration varDecl;
                    declaration = lDeclarationEdge.getDeclaration().toASTString(false);
                    if (lDeclarationEdge.getDeclaration() instanceof CVariableDeclaration && (varDecl = (CVariableDeclaration)lDeclarationEdge.getDeclaration()).getType() instanceof CArrayType && varDecl.getInitializer() instanceof CInitializerExpression) {
                        int assignAfterPos = ((String)declaration).indexOf("=") + 1;
                        declaration = ((String)declaration).substring(0, assignAfterPos) + "{" + ((String)declaration).substring(assignAfterPos, ((String)declaration).lastIndexOf(";")) + "};";
                    }
                    if (((String)declaration).contains(",")) {
                        for (CFAEdge predEdge : CFAUtils.enteringEdges(pCFAEdge.getPredecessor())) {
                            if (!predEdge.getRawStatement().equals(lDeclarationEdge.getDeclaration().toASTString())) continue;
                            declaration = "";
                            break;
                        }
                    }
                }
                if (((String)declaration).contains("org.eclipse.cdt.internal.core.dom.parser.ProblemType@")) {
                    throw new CPAException("Failed to translate CFA into program because a type could not be properly resolved.");
                }
                if (lDeclarationEdge.getDeclaration().isGlobal()) {
                    this.globalDefinitionsList.add((String)declaration + (((String)declaration).endsWith(";") ? "" : ";"));
                    break;
                }
                return declaration;
            }
            case CallToReturnEdge: {
                throw new AssertionError((Object)("CallToReturnEdge in path: " + pCFAEdge));
            }
            default: {
                throw new AssertionError((Object)("Unexpected edge " + pCFAEdge + " of type " + pCFAEdge.getEdgeType()));
            }
        }
        return "";
    }

    private static class NodeAndBlock {
        private final CFANode node;
        private final Statement.CompoundStatement currentBlock;

        public NodeAndBlock(CFANode pNode, Statement.CompoundStatement pCurrentBlock) {
            this.node = pNode;
            this.currentBlock = pCurrentBlock;
        }

        public CFANode getNode() {
            return this.node;
        }

        public Statement.CompoundStatement getCurrentBlock() {
            return this.currentBlock;
        }
    }
}

