/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.io.IOException;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.export.CWriter;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CfaToCExporter {
    private final CWriter cWriter;

    public CfaToCExporter(LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        CParser.ParserOptions options = CParser.Factory.getOptions(pConfig);
        this.cWriter = CWriter.createInstance(pLogger, options, pShutdownNotifier);
    }

    public String exportCfa(CFA pCfa) throws InvalidConfigurationException, IOException, CPAException, InterruptedException {
        if (pCfa.getLanguage() != Language.C) {
            throw new InvalidConfigurationException("CFA can only be exported to C for C input programs, at the moment.");
        }
        return this.cWriter.exportCfa(pCfa);
    }
}

