/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Deque;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.cwriter.DefaultEdgeVisitor;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;
import org.sosy_lab.cpachecker.util.cwriter.PathTranslator;

public class ConcreteProgramEdgeVisitor
extends DefaultEdgeVisitor {
    private final CFAPathWithAssumptions exactValuePath;

    public ConcreteProgramEdgeVisitor(PathTranslator t, CFAPathWithAssumptions exactValues) {
        super(t);
        this.exactValuePath = exactValues;
    }

    @Override
    public void visit(ARGState pChildElement, CFAEdge pEdge, Deque<FunctionBody> pFunctionStack) {
        this.translator.processEdge(pChildElement, pEdge, pFunctionStack);
        this.createAssumedAssigmentString(pFunctionStack, pEdge);
    }

    private void createAssumedAssigmentString(Deque<FunctionBody> functionStack, CFAEdge currentCFAEdge) {
        CFAEdgeWithAssumptions e = this.findMatchingEdge(currentCFAEdge);
        if (e != null && e.getCFAEdge() instanceof CStatementEdge) {
            CStatementEdge cse = (CStatementEdge)e.getCFAEdge();
            if (!(cse.getStatement() instanceof CFunctionCallAssignmentStatement)) {
                return;
            }
            for (AExpressionStatement exp : e.getExpStmts()) {
                CBinaryExpression cexp;
                if (!(exp instanceof CExpressionStatement) || !(exp.getExpression() instanceof CBinaryExpression) || !(cexp = (CBinaryExpression)exp.getExpression()).getOperator().equals(CBinaryExpression.BinaryOperator.EQUALS)) continue;
                assert (cexp.getOperand1() instanceof CLeftHandSide) : "model-refined element is not a lefthandside expression";
                CLeftHandSide lho = (CLeftHandSide)cexp.getOperand1();
                if (lho.getExpressionType() instanceof CPointerType) continue;
                CExpressionAssignmentStatement cass = new CExpressionAssignmentStatement(cexp.getFileLocation(), lho, cexp.getOperand2());
                functionStack.peek().write(cass.toASTString());
            }
        }
    }

    private CFAEdgeWithAssumptions findMatchingEdge(CFAEdge e) {
        for (CFAEdgeWithAssumptions edgeWithAssignments : FluentIterable.from((Iterable)((Object)this.exactValuePath)).filter(Predicates.notNull())) {
            if (!e.equals(edgeWithAssignments.getCFAEdge())) continue;
            return edgeWithAssignments;
        }
        return null;
    }
}

