/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.Deque;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;

class Edge
implements Comparable<Edge> {
    private final ARGState parentState;
    private final ARGState childState;
    private final CFAEdge edge;
    private final Deque<FunctionBody> stack;

    public Edge(ARGState pChildElement, ARGState pParentElement, CFAEdge pEdge, Deque<FunctionBody> pStack) {
        this.childState = pChildElement;
        this.parentState = pParentElement;
        this.edge = pEdge;
        this.stack = pStack;
    }

    public ARGState getChildState() {
        return this.childState;
    }

    public ARGState getParentState() {
        return this.parentState;
    }

    public CFAEdge getEdge() {
        return this.edge;
    }

    public Deque<FunctionBody> getStack() {
        return this.stack;
    }

    @Override
    public int compareTo(Edge pO) {
        return Integer.compare(this.getChildState().getStateId(), pO.getChildState().getStateId());
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (pObj instanceof Edge) {
            int otherElementId = ((Edge)pObj).getChildState().getStateId();
            int thisElementId = this.getChildState().getStateId();
            return thisElementId == otherElementId;
        }
        return false;
    }

    public int hashCode() {
        return this.getChildState().getStateId();
    }
}

