/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;

public class FormulaToCExpressionVisitor
extends FormulaManagerView.FormulaTransformationVisitor {
    private static final String FUNCTION_NAME_SEPARATOR = "::";
    private static final ImmutableSet<FunctionDeclarationKind> COMMUTATIVE_OPERATIONS = ImmutableSet.of((Object)FunctionDeclarationKind.EQ, (Object)FunctionDeclarationKind.BV_EQ, (Object)FunctionDeclarationKind.FP_EQ);
    private final Map<Formula, String> cache = new HashMap<Formula, String>();

    FormulaToCExpressionVisitor(FormulaManagerView fmgr) {
        super(fmgr);
    }

    public Formula visitFreeVariable(Formula f, String name) {
        List parts = Splitter.on((String)FUNCTION_NAME_SEPARATOR).splitToList((CharSequence)name);
        String variableName = parts.size() == 2 ? (String)parts.get(1) : name;
        this.cache.put(f, variableName);
        return f;
    }

    public Formula visitConstant(Formula f, Object value) {
        this.cache.put(f, value.toString());
        return f;
    }

    public Formula visitFunction(Formula f, List<Formula> newArgs, FunctionDeclaration<?> functionDeclaration) {
        Object result = null;
        switch (functionDeclaration.getKind()) {
            case NOT: 
            case UMINUS: 
            case BV_NEG: 
            case FP_NEG: 
            case BV_NOT: {
                result = this.operatorFromFunctionDeclaration(functionDeclaration) + this.cache.get(newArgs.get(0));
                break;
            }
            case EQ_ZERO: 
            case GTE_ZERO: {
                result = this.cache.get(newArgs.get(0)) + this.operatorFromFunctionDeclaration(functionDeclaration);
                break;
            }
            case FP_ROUND_EVEN: 
            case FP_ROUND_AWAY: 
            case FP_ROUND_POSITIVE: 
            case FP_ROUND_NEGATIVE: 
            case FP_ROUND_ZERO: 
            case FP_ROUND_TO_INTEGRAL: {
                break;
            }
            case FP_ADD: 
            case FP_SUB: 
            case FP_DIV: 
            case FP_MUL: {
                ImmutableList expressions = FluentIterable.from(newArgs).skip(1).transform(arg -> (String)Preconditions.checkNotNull((Object)this.cache.get(arg))).toList();
                result = String.join((CharSequence)this.operatorFromFunctionDeclaration(functionDeclaration), (Iterable<? extends CharSequence>)expressions);
                break;
            }
            case ITE: {
                result = String.format("%s ? %s : %s", this.cache.get(newArgs.get(0)), this.cache.get(newArgs.get(1)), this.cache.get(newArgs.get(2)));
                break;
            }
            default: {
                ArrayList<String> expressions = new ArrayList<String>(newArgs.size());
                for (Formula arg2 : newArgs) {
                    if (!this.cache.containsKey(arg2)) continue;
                    expressions.add((String)Preconditions.checkNotNull((Object)this.cache.get(arg2)));
                }
                if (COMMUTATIVE_OPERATIONS.contains((Object)functionDeclaration.getKind())) {
                    Collections.sort(expressions);
                }
                result = String.join((CharSequence)this.operatorFromFunctionDeclaration(functionDeclaration), expressions);
            }
        }
        if (result != null) {
            this.cache.put(f, "(" + result + ")");
        }
        return f;
    }

    private String operatorFromFunctionDeclaration(FunctionDeclaration<?> pDeclaration) {
        switch (pDeclaration.getKind()) {
            case NOT: {
                return "!";
            }
            case UMINUS: 
            case BV_NEG: 
            case FP_NEG: {
                return "-";
            }
            case AND: {
                return " && ";
            }
            case BV_AND: {
                return " & ";
            }
            case OR: {
                return "\n|| ";
            }
            case BV_OR: {
                return " | ";
            }
            case BV_XOR: {
                return " ^ ";
            }
            case FP_SUB: 
            case SUB: 
            case BV_SUB: {
                return " - ";
            }
            case FP_ADD: 
            case ADD: 
            case BV_ADD: {
                return " + ";
            }
            case FP_DIV: 
            case DIV: 
            case BV_SDIV: 
            case BV_UDIV: {
                return " / ";
            }
            case FP_MUL: 
            case MUL: 
            case BV_MUL: {
                return " * ";
            }
            case MODULO: 
            case BV_SREM: 
            case BV_UREM: {
                return " % ";
            }
            case LT: 
            case BV_SLT: 
            case BV_ULT: 
            case FP_LT: {
                return " < ";
            }
            case LTE: 
            case BV_SLE: 
            case BV_ULE: 
            case FP_LE: {
                return " <= ";
            }
            case GT: 
            case BV_SGT: 
            case BV_UGT: 
            case FP_GT: {
                return " > ";
            }
            case GTE: 
            case BV_SGE: 
            case BV_UGE: 
            case FP_GE: {
                return " >= ";
            }
            case EQ: 
            case BV_EQ: 
            case FP_EQ: {
                return " == ";
            }
            case EQ_ZERO: {
                return " == 0";
            }
            case GTE_ZERO: {
                return " >= 0";
            }
            case BV_NOT: {
                return "~";
            }
            case BV_SHL: {
                return " << ";
            }
            case UF: {
                switch (pDeclaration.getName()) {
                    case "_&_": {
                        return " & ";
                    }
                    case "_!!_": {
                        return " | ";
                    }
                    case "_^_": {
                        return " ^ ";
                    }
                    case "_~_": {
                        return "~";
                    }
                    case "_<<_": {
                        return " << ";
                    }
                    case "_>>_": {
                        return " >> ";
                    }
                    case "_%_": {
                        return " % ";
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Unexpected operand " + pDeclaration.getKind() + "(" + pDeclaration.getName() + ")");
    }

    public String getCExpressionForFormula(Formula f) {
        return this.cache.get(f);
    }
}

