/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;

class FunctionBody
implements Iterable<BasicBlock> {
    private final Deque<BasicBlock> stack = new ArrayDeque<BasicBlock>();

    public FunctionBody(int pElementId, String pFunctionName) {
        this.stack.push(new BasicBlock(pElementId, pFunctionName));
    }

    public FunctionBody(FunctionBody oldStack) {
        this.stack.addAll(oldStack.stack);
    }

    public void enterBlock(int pElementId, CAssumeEdge pEdge, String pConditionString) {
        BasicBlock block = new BasicBlock(pElementId, pEdge, pConditionString);
        this.stack.getLast().write(block);
        this.stack.addLast(block);
    }

    public void leaveBlock() {
        this.stack.removeLast();
    }

    public BasicBlock getCurrentBlock() {
        return this.stack.getLast();
    }

    public int size() {
        return this.stack.size();
    }

    @Override
    public Iterator<BasicBlock> iterator() {
        return this.stack.iterator();
    }

    public void write(String s) {
        this.stack.getLast().write(s);
    }

    public String toString() {
        return this.stack.getFirst().getCode();
    }
}

