/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.collect.FluentIterable;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;

public class FunctionBodyTest {
    private static CAssumeEdge createAssumeEdge() {
        return new CAssumeEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.ZERO), true);
    }

    @Test
    public void test_enter_leave_iterationOrder() {
        FunctionBody body = new FunctionBody(0, "dummy");
        body.enterBlock(1, FunctionBodyTest.createAssumeEdge(), "if (0)");
        body.enterBlock(2, FunctionBodyTest.createAssumeEdge(), "if (0)");
        Truth.assertThat((Integer)body.getCurrentBlock().getStateId()).isEqualTo((Object)2);
        Truth.assertThat((Iterable)FluentIterable.from((Iterable)body).transform(BasicBlock::getStateId)).containsExactly(new Object[]{0, 1, 2}).inOrder();
        body.leaveBlock();
        body.enterBlock(3, FunctionBodyTest.createAssumeEdge(), "if (0");
        Truth.assertThat((Integer)body.getCurrentBlock().getStateId()).isEqualTo((Object)3);
        Truth.assertThat((Iterable)FluentIterable.from((Iterable)body).transform(BasicBlock::getStateId)).containsExactly(new Object[]{0, 1, 3}).inOrder();
        body.leaveBlock();
        body.leaveBlock();
        body.leaveBlock();
        Truth.assertThat((Iterable)body).isEmpty();
    }
}

