/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.collect.FluentIterable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.cwriter.EdgeVisitor;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;

@Options(prefix="cwriter.withLoops")
public class LoopCollectingEdgeVisitor
implements EdgeVisitor {
    @Option(toUppercase=true, description="Option to change the behaviour of the loop detection for generating the Counterexample-C-Code that will probably be used to generate invariants. Note that last loop means the first loop encountered when backwards traversing the given ARGPath, thus, the last loop may contain other loops, which are in turn also counted to the last loop.", secure=true)
    private LoopDetectionStrategy loopDetectionStrategy = LoopDetectionStrategy.ALL_LOOPS;
    private final LoopStructure loopStructure;
    private final List<Pair<CFAEdge, ARGState>> cfaPath = new ArrayList<Pair<CFAEdge, ARGState>>();
    private final Deque<LoopStructure.Loop> loopStack = new ArrayDeque<LoopStructure.Loop>();
    private final Map<LoopStructure.Loop, Set<ARGState>> relevantLoops = new LinkedHashMap<LoopStructure.Loop, Set<ARGState>>();
    private final List<LoopStructure.Loop> finishedLoops = new ArrayList<LoopStructure.Loop>();
    private boolean lastLoopFound = false;

    public LoopCollectingEdgeVisitor(LoopStructure pLoopStructure, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.loopStructure = pLoopStructure;
    }

    public void reset() {
        this.cfaPath.clear();
        this.loopStack.clear();
        this.relevantLoops.clear();
        this.finishedLoops.clear();
        this.lastLoopFound = false;
    }

    @Override
    public void visit(ARGState childElement, CFAEdge edge, Deque<FunctionBody> functionStack) {
        this.cfaPath.add(Pair.of(edge, childElement));
    }

    public Map<LoopStructure.Loop, Set<ARGState>> getRelevantLoops() {
        ListIterator<Pair<CFAEdge, ARGState>> cfaIterator = this.cfaPath.listIterator(this.cfaPath.size());
        CFAEdge edge = this.cfaPath.get(this.cfaPath.size() - 1).getFirst();
        ARGState state = this.cfaPath.get(this.cfaPath.size() - 2).getSecond();
        this.handleLoopStack(edge, state);
        while (cfaIterator.hasPrevious()) {
            Pair<CFAEdge, ARGState> tmp = cfaIterator.previous();
            edge = tmp.getFirst();
            if (!cfaIterator.hasPrevious()) break;
            state = cfaIterator.previous().getSecond();
            cfaIterator.next();
            if (edge instanceof CFunctionReturnEdge) {
                CFANode beforeFunctionCall = ((CFunctionReturnEdge)edge).getSummaryEdge().getPredecessor();
                while (cfaIterator.hasPrevious()) {
                    tmp = cfaIterator.previous();
                    if (!Objects.equals(tmp.getFirst().getPredecessor(), beforeFunctionCall)) continue;
                    edge = tmp.getFirst();
                    if (!cfaIterator.hasPrevious()) break;
                    state = cfaIterator.previous().getSecond();
                    cfaIterator.next();
                    break;
                }
            }
            this.handleLoopStack(edge, state);
            if (this.loopDetectionStrategy != LoopDetectionStrategy.ONLY_LAST_LOOP || !this.lastLoopFound || !this.loopStack.isEmpty()) continue;
            break;
        }
        return this.relevantLoops;
    }

    private void handleLoopStack(CFAEdge edge, ARGState state) {
        if (edge == null) {
            if (!this.loopStack.isEmpty()) {
                List<LoopStructure.Loop> loops = LoopCollectingEdgeVisitor.getLoopsOfNode(this.loopStructure, AbstractStates.extractLocation(state));
                assert (loops.size() == this.loopStack.size());
                for (LoopStructure.Loop loop : loops) {
                    this.relevantLoops.get(loop).add(state);
                }
            }
            return;
        }
        CFANode predecessor = edge.getPredecessor();
        while (!this.loopStack.isEmpty() && !this.loopStack.peek().getLoopNodes().contains((Object)predecessor)) {
            this.finishedLoops.add(this.loopStack.pop());
        }
        boolean isInLoop = LoopCollectingEdgeVisitor.isInAnyLoop(this.loopStructure, predecessor);
        List<LoopStructure.Loop> loops = LoopCollectingEdgeVisitor.getLoopsOfNode(this.loopStructure, predecessor);
        if (!this.loopStack.isEmpty()) {
            this.relevantLoops.get(this.loopStack.peek()).add(state);
            int startPushingIndex = loops.size();
            while (loops.get(startPushingIndex - 1) != this.loopStack.peek()) {
                --startPushingIndex;
            }
            for (int i = startPushingIndex; i < loops.size(); ++i) {
                LoopStructure.Loop actLoop = loops.get(i);
                this.loopStack.push(actLoop);
                HashSet<ARGState> states = new HashSet<ARGState>();
                states.add(state);
                this.relevantLoops.put(actLoop, states);
            }
        } else {
            if (this.lastLoopFound && this.loopDetectionStrategy == LoopDetectionStrategy.ONLY_LAST_LOOP) {
                return;
            }
            for (LoopStructure.Loop actLoop : loops) {
                this.loopStack.push(actLoop);
                HashSet<ARGState> states = new HashSet<ARGState>();
                states.add(state);
                this.relevantLoops.put(actLoop, states);
            }
        }
        if (!this.lastLoopFound && isInLoop) {
            this.lastLoopFound = true;
        }
    }

    static boolean isInAnyLoop(LoopStructure loopStructure, CFANode node) {
        return FluentIterable.from(loopStructure.getAllLoops()).anyMatch(pInput -> pInput.getLoopNodes().contains((Object)node));
    }

    static List<LoopStructure.Loop> getLoopsOfNode(LoopStructure loopStructure, CFANode node) {
        return FluentIterable.from(loopStructure.getAllLoops()).filter(pInput -> pInput.getLoopNodes().contains((Object)node)).toSortedList((loop1, loop2) -> LoopCollectingEdgeVisitor.isOuterLoopOf(loop1, loop2) ? -1 : 1);
    }

    static boolean isOuterLoopOf(LoopStructure.Loop outer, LoopStructure.Loop inner) {
        return outer.getLoopNodes().containsAll(inner.getLoopNodes());
    }

    static enum LoopDetectionStrategy {
        ALL_LOOPS,
        ONLY_LAST_LOOP;

    }
}

