/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;
import org.sosy_lab.cpachecker.util.cwriter.DefaultEdgeVisitor;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;
import org.sosy_lab.cpachecker.util.cwriter.LoopCollectingEdgeVisitor;
import org.sosy_lab.cpachecker.util.cwriter.PathToCTranslator;
import org.sosy_lab.cpachecker.util.cwriter.PathTranslator;

public class PathToCWithLoopsTranslator
extends PathTranslator {
    private static final Pattern uniqueFunction = Pattern.compile(".*_[0-9]+(.*)");
    private final LoopStructure loopStructure;
    private final Map<LoopStructure.Loop, Set<ARGState>> loopsInPathToRecreate;
    private Deque<String> callStack = new ArrayDeque<String>();
    private Map<String, Pair<CFunctionEntryNode, FunctionBody>> nonUniqueFunctions = new HashMap<String, Pair<CFunctionEntryNode, FunctionBody>>();
    private int labelCounter = 0;
    private Map<LoopStructure.Loop, String> loopInLabels = new HashMap<LoopStructure.Loop, String>();
    private Map<LoopStructure.Loop, CFANode> loopToHead = new HashMap<LoopStructure.Loop, CFANode>();
    private Map<LoopStructure.Loop, String> loopOutLabels = new HashMap<LoopStructure.Loop, String>();
    private Set<CFAEdge> handledEdges = new HashSet<CFAEdge>();
    private Set<String> handledFunctions = new HashSet<String>();
    private Map<CFAEdge, String> ifOutLabels = new HashMap<CFAEdge, String>();
    private Deque<Map<CFANode, String>> ifOutLabelEnd = new ArrayDeque<Map<CFANode, String>>();
    private Set<CFANode> ifThenHandled = new HashSet<CFANode>();
    private Map<CFAEdge, String> ifElseLabels = new HashMap<CFAEdge, String>();
    private String currentFunctionName = "";

    private PathToCWithLoopsTranslator(CFA pCFA, Map<LoopStructure.Loop, Set<ARGState>> pLoopsInPathToRecreate) {
        this.loopStructure = pCFA.getLoopStructure().orElseThrow();
        this.loopsInPathToRecreate = pLoopsInPathToRecreate;
    }

    public static Appender translateSinglePath(ARGPath pPath, CFA cfa, Configuration config) throws InvalidConfigurationException {
        PathToCTranslator translator = new PathToCTranslator();
        LoopCollectingEdgeVisitor loopCollectingVisitor = new LoopCollectingEdgeVisitor(cfa.getLoopStructure().orElseThrow(), config);
        translator.translateSinglePath0(pPath, loopCollectingVisitor);
        Map<LoopStructure.Loop, Set<ARGState>> loopsInPathToRecreate = loopCollectingVisitor.getRelevantLoops();
        PathToCWithLoopsTranslator loopTranslator = new PathToCWithLoopsTranslator(cfa, loopsInPathToRecreate);
        loopTranslator.translateSinglePath0(pPath, new DefaultEdgeVisitor(loopTranslator));
        return loopTranslator.generateCCode();
    }

    @Override
    protected Appender generateCCode() {
        this.mGlobalDefinitionsList.add(0, "#include <stdlib.h>\n");
        this.mGlobalDefinitionsList.add(1, "#include <time.h>\n");
        this.mGlobalDefinitionsList.add(2, "#define __VERIFIER_nondet_int() rand()");
        this.mGlobalDefinitionsList.remove("int __VERIFIER_nondet_int()");
        this.mFunctionDecls.add("int main() {\n  srand(time(NULL));\n  return main_0();\n}");
        Appender app = super.generateCCode();
        return this.createNonUniqueFunctions(app);
    }

    private Appender createNonUniqueFunctions(Appender app) {
        ArrayList<FunctionBody> finishedBodies = new ArrayList<FunctionBody>();
        for (Pair<CFunctionEntryNode, FunctionBody> p : this.nonUniqueFunctions.values()) {
            FunctionBody body = p.getSecond();
            body.write(this.recreateFunction(p.getFirst(), p.getFirst(), p.getFirst().getExitNode(), body.getCurrentBlock()));
            finishedBodies.add(body);
        }
        return Appenders.concat((Appender[])new Appender[]{app, Appenders.forIterable((Joiner)Joiner.on((char)'\n'), finishedBodies)});
    }

    @Override
    protected String startFunction(ARGState firstFunctionElement, Deque<FunctionBody> functionStack, CFANode predecessor) {
        CFunctionEntryNode functionStartNode = PathToCWithLoopsTranslator.extractFunctionCallLocation(firstFunctionElement);
        String functionName = functionStartNode.getFunctionName();
        if (this.loopsInPathToRecreate.isEmpty() || this.loopsInPathToRecreate.keySet().stream().noneMatch(loop -> loop.getLoopNodes().contains((Object)predecessor))) {
            functionName = this.getFreshFunctionName(functionStartNode);
        }
        String lFunctionHeader = functionStartNode.getFunctionDefinition().getType().toASTString(functionName);
        FunctionBody newFunction = new FunctionBody(firstFunctionElement.getStateId(), lFunctionHeader);
        if (!this.mFunctionDecls.contains(lFunctionHeader + ";")) {
            this.mFunctionDecls.add(lFunctionHeader + ";");
            if (uniqueFunction.matcher(lFunctionHeader).matches()) {
                this.mFunctionBodies.add(newFunction);
                functionStack.push(newFunction);
            } else {
                this.nonUniqueFunctions.put(lFunctionHeader, Pair.of(functionStartNode, newFunction));
            }
        }
        this.callStack.push(lFunctionHeader);
        assert (this.callStack.size() == new HashSet<String>(this.callStack).size()) : "Recursive function call found";
        return functionName;
    }

    @Override
    protected void processEdge(ARGState childElement, CFAEdge edge, Deque<FunctionBody> functionStack) {
        if (this.handledFunctions.contains(this.callStack.peek()) && edge instanceof CFunctionReturnEdge) {
            this.callStack.pop();
            return;
        }
        if (this.handledEdges.contains(edge) || this.handledFunctions.contains(this.callStack.peek())) {
            return;
        }
        if (this.loopsInPathToRecreate == null) {
            super.processEdge(childElement, edge, functionStack);
        } else {
            this.processEdge0(childElement, edge, functionStack);
        }
    }

    private void processEdge0(ARGState childElement, CFAEdge edge, Deque<FunctionBody> functionStack) {
        FunctionBody currentFunction = functionStack.peek();
        if (childElement.isTarget()) {
            currentFunction.write(this.getTargetState());
        }
        if (edge instanceof CFunctionCallEdge) {
            String freshFunctionName;
            if (this.handledFunctions.contains(edge.getSuccessor().getFunctionName())) {
                this.callStack.push(edge.getSuccessor().getFunctionName());
                this.currentFunctionName = edge.getSuccessor().getFunctionName();
                return;
            }
            this.currentFunctionName = freshFunctionName = this.startFunction(childElement, functionStack, edge.getPredecessor());
            currentFunction.write(this.processFunctionCall(edge, freshFunctionName));
        } else if (edge instanceof CFunctionReturnEdge) {
            if (this.callStack.peek().contains(((CFunctionReturnEdge)edge).getFunctionEntry().getFunctionName())) {
                if (uniqueFunction.matcher(this.callStack.peek()).matches()) {
                    functionStack.pop();
                }
                this.callStack.pop();
            }
            this.currentFunctionName = this.callStack.peek();
        } else if (uniqueFunction.matcher(this.callStack.peek()).matches()) {
            currentFunction.write(this.processSimpleEdge0(edge, currentFunction.getCurrentBlock(), childElement));
        }
    }

    private String processSimpleEdge0(CFAEdge pCFAEdge, BasicBlock currentBlock, ARGState state) {
        CFANode succ = pCFAEdge.getSuccessor();
        ImmutableList loopsAfter = FluentIterable.from(LoopCollectingEdgeVisitor.getLoopsOfNode(this.loopStructure, succ)).filter(this.loopsInPathToRecreate::containsKey).toList();
        if (loopsAfter.isEmpty() || !this.loopsInPathToRecreate.get(loopsAfter.get(loopsAfter.size() - 1)).contains(state)) {
            return this.processSimpleWithLoop(pCFAEdge, currentBlock, "").trim();
        }
        return this.recreateLoop(pCFAEdge, currentBlock, (List<LoopStructure.Loop>)loopsAfter).getFirst();
    }

    private String recreateFunction(FunctionEntryNode functionEntryNode, CFANode currentStartNode, CFANode untilNode, BasicBlock block) {
        StringBuilder wholeFunction = new StringBuilder();
        ArrayDeque<CFAEdge> nextEdge = new ArrayDeque<CFAEdge>();
        nextEdge.offer(currentStartNode.getLeavingEdge(0));
        while (!nextEdge.isEmpty()) {
            Pair<String, CFAEdge> tmp;
            CFAEdge currentEdge = (CFAEdge)nextEdge.poll();
            wholeFunction.append(this.processSimpleWithLoop(currentEdge, block, ""));
            if (Objects.equals(currentEdge.getSuccessor(), untilNode)) {
                return wholeFunction.toString();
            }
            if (currentEdge instanceof AReturnStatementEdge) continue;
            CFANode successor = currentEdge.getSuccessor();
            if (this.handledEdges.contains(currentEdge)) continue;
            FluentIterable currentLoops = FluentIterable.from(LoopCollectingEdgeVisitor.getLoopsOfNode(this.loopStructure, successor));
            if (!currentLoops.isEmpty()) {
                tmp = this.recreateLoop(currentEdge, block, (List<LoopStructure.Loop>)currentLoops.toList());
                assert (tmp.getSecond().getSuccessor().getNumLeavingEdges() == 1);
                nextEdge.offer(tmp.getSecond().getSuccessor().getLeavingEdge(0));
                wholeFunction.append(tmp.getFirst());
                continue;
            }
            if (successor.getNumLeavingEdges() > 1) {
                tmp = this.recreateIf(currentEdge, block, functionEntryNode);
                nextEdge.offer(tmp.getSecond());
                wholeFunction.append(tmp.getFirst());
                continue;
            }
            CFAEdge leavingEdge = successor.getLeavingEdge(0);
            if (leavingEdge instanceof CFunctionCallEdge) {
                leavingEdge = successor.getLeavingSummaryEdge();
            }
            nextEdge.offer(leavingEdge);
        }
        return wholeFunction.toString();
    }

    private Pair<String, CFAEdge> recreateIf(CFAEdge pCFAEdge, BasicBlock currentBlock, FunctionEntryNode entryNode) {
        StringBuilder ifString = new StringBuilder();
        CFAEdge branch1 = pCFAEdge.getSuccessor().getLeavingEdge(0);
        CFAEdge branch2 = pCFAEdge.getSuccessor().getLeavingEdge(1);
        CFANode ifEnd = this.findEndOfBranches(Collections.singletonList(entryNode.getExitNode()), pCFAEdge.getPredecessor(), branch1.getSuccessor(), branch2.getSuccessor());
        String elseLabel = this.createFreshLabelForIf(branch2, ifEnd);
        String outLabel = this.ifOutLabelEnd.peek().get(ifEnd);
        ifString.append(this.processSimpleWithLoop(branch1, currentBlock, elseLabel)).append(this.recreateFunction(entryNode, branch1.getSuccessor(), ifEnd, currentBlock)).append("goto ").append(outLabel).append(";\n").append(elseLabel).append(": ;\n").append(this.recreateFunction(entryNode, branch2.getSuccessor(), ifEnd, currentBlock)).append(outLabel).append(": ;\n");
        assert (ifEnd.getNumLeavingEdges() == 1);
        return Pair.of(ifString.toString(), ifEnd.getLeavingEdge(0));
    }

    private Pair<String, CFAEdge> recreateLoop(CFAEdge pCFAEdge, BasicBlock currentBlock, List<LoopStructure.Loop> loopsAfter) {
        this.resetLoopAndIfMaps();
        CFAEdge lastEdge = null;
        StringBuilder wholeLoopString = new StringBuilder();
        assert (loopsAfter.get(loopsAfter.size() - 1).getIncomingEdges().contains((Object)pCFAEdge));
        LoopStructure.Loop loop = loopsAfter.get(loopsAfter.size() - 1);
        String labelStayInLoop = this.createFreshLabelForLoop(pCFAEdge, loop);
        wholeLoopString.append(labelStayInLoop).append(": ;\n");
        ArrayDeque<CFAEdge> edgesToHandle = new ArrayDeque<CFAEdge>();
        edgesToHandle.offer(pCFAEdge);
        ArrayDeque<LoopStructure.Loop> loopStack = new ArrayDeque<LoopStructure.Loop>();
        loopStack.push(loop);
        ArrayDeque<CFAEdge> ifStack = new ArrayDeque<CFAEdge>();
        ArrayDeque<CFAEdge> outOfLoopEdgesStack = new ArrayDeque<CFAEdge>();
        while (!(edgesToHandle.isEmpty() && outOfLoopEdgesStack.isEmpty() && ifStack.isEmpty())) {
            if (edgesToHandle.isEmpty()) {
                if (!ifStack.isEmpty()) {
                    edgesToHandle.offer((CFAEdge)ifStack.pop());
                    wholeLoopString.append("goto ").append(this.ifOutLabels.get(edgesToHandle.peek())).append(";\n").append(this.ifElseLabels.get(edgesToHandle.peek())).append(": ;\n");
                } else {
                    edgesToHandle.offer((CFAEdge)outOfLoopEdgesStack.pop());
                    LoopStructure.Loop oldLoop = (LoopStructure.Loop)loopStack.pop();
                    wholeLoopString.append("goto ").append(this.loopInLabels.get(oldLoop)).append(";\n").append(this.loopOutLabels.get(oldLoop)).append(": ;\n");
                }
            }
            CFANode currentEdgePredecessor = ((CFAEdge)edgesToHandle.peek()).getPredecessor();
            this.handleIfOutLabels(wholeLoopString, currentEdgePredecessor);
            if (this.handledEdges.contains(edgesToHandle.peek())) {
                edgesToHandle.pop();
                continue;
            }
            CFAEdge currentEdge = (CFAEdge)edgesToHandle.pop();
            this.handledEdges.add(currentEdge);
            FluentIterable leaving = CFAUtils.leavingEdges(currentEdge.getSuccessor()).filter(Predicates.not((Predicate)Predicates.instanceOf(FunctionCallEdge.class)));
            if (leaving.isEmpty()) {
                CFAEdge realLeavingEdge = currentEdge.getSuccessor().getLeavingEdge(0);
                FunctionSummaryEdge leavingSummaryEdge = currentEdge.getSuccessor().getLeavingSummaryEdge();
                wholeLoopString.append(this.processSimpleWithLoop(realLeavingEdge, currentBlock, ""));
                this.handledFunctions.add(realLeavingEdge.getSuccessor().getFunctionName());
                leaving = leaving.append((Object[])new CFAEdge[]{leavingSummaryEdge});
            } else if (leaving.size() == 1) {
                wholeLoopString.append(this.processSimpleWithLoop((CFAEdge)leaving.get(0), currentBlock, ""));
            }
            if (leaving.size() == 1) {
                CFAEdge onlyEdge = (CFAEdge)leaving.get(0);
                if (Objects.equals(this.loopToHead.get(loopStack.peek()), onlyEdge.getSuccessor()) && !((LoopStructure.Loop)loopStack.peek()).getIncomingEdges().contains((Object)onlyEdge)) {
                    this.handledEdges.add(onlyEdge);
                    this.handleIfOutLabels(wholeLoopString, onlyEdge.getPredecessor());
                    continue;
                }
                edgesToHandle.offer(onlyEdge);
                this.updateLoopStack(wholeLoopString, loopStack, onlyEdge);
                continue;
            }
            assert (leaving.size() == 2) : leaving.toString();
            CFAEdge leaving1 = (CFAEdge)leaving.get(0);
            CFAEdge leaving2 = (CFAEdge)leaving.get(1);
            ImmutableSet<CFAEdge> outOfCurrentLoop = ((LoopStructure.Loop)loopStack.peek()).getOutgoingEdges();
            boolean isOutOfLoopContained = false;
            CFAEdge leavingLoopEdge = null;
            if (outOfCurrentLoop.contains((Object)leaving1)) {
                this.handleOutOfLoopEdge(currentBlock, wholeLoopString, edgesToHandle, loopStack, leaving1, leaving2);
                leavingLoopEdge = leaving1;
                isOutOfLoopContained = true;
            } else if (outOfCurrentLoop.contains((Object)leaving2)) {
                this.handleOutOfLoopEdge(currentBlock, wholeLoopString, edgesToHandle, loopStack, leaving2, leaving1);
                leavingLoopEdge = leaving2;
                isOutOfLoopContained = true;
            }
            if (isOutOfLoopContained) {
                if (loopStack.size() == 1) {
                    lastEdge = leavingLoopEdge;
                    this.handledEdges.add(leavingLoopEdge);
                    continue;
                }
                outOfLoopEdgesStack.push(leavingLoopEdge);
                continue;
            }
            if (this.handledEdges.contains(leaving1)) continue;
            wholeLoopString.append(this.processSimpleWithLoop(leaving1, currentBlock, this.createFreshLabelForIf(leaving2, this.findEndOfBranches(Collections.singletonList(this.loopToHead.get(loopStack.peek())), currentEdgePredecessor, leaving1.getSuccessor(), leaving2.getSuccessor()))));
            edgesToHandle.push(leaving1);
            ifStack.push(leaving2);
        }
        wholeLoopString.append("goto ").append(this.loopInLabels.get(loop)).append(";\n").append(this.loopOutLabels.get(loop)).append(": ;\n");
        return Pair.of(wholeLoopString.toString(), lastEdge);
    }

    private void handleIfOutLabels(StringBuilder wholeLoopString, CFANode predecessor) {
        if (!this.ifOutLabelEnd.isEmpty() && this.ifOutLabelEnd.peek().containsKey(predecessor) && !this.ifThenHandled.add(predecessor)) {
            wholeLoopString.append(this.ifOutLabelEnd.pop().get(predecessor)).append(": ;\n");
        }
    }

    private void handleOutOfLoopEdge(BasicBlock currentBlock, StringBuilder wholeLoopString, Deque<CFAEdge> edgesToHandle, Deque<LoopStructure.Loop> loopStack, CFAEdge leavingEdge, CFAEdge stayingEdge) {
        this.updateLoopStack(wholeLoopString, loopStack, stayingEdge);
        wholeLoopString.append(this.processSimpleWithLoop(leavingEdge, currentBlock, this.loopOutLabels.get(loopStack.peek())));
        edgesToHandle.push(stayingEdge);
    }

    private void resetLoopAndIfMaps() {
        this.loopInLabels = new HashMap<LoopStructure.Loop, String>();
        this.loopToHead = new HashMap<LoopStructure.Loop, CFANode>();
        this.loopOutLabels = new HashMap<LoopStructure.Loop, String>();
        this.ifOutLabels = new HashMap<CFAEdge, String>();
        this.ifOutLabelEnd = new ArrayDeque<Map<CFANode, String>>();
        this.ifThenHandled = new HashSet<CFANode>();
        this.ifElseLabels = new HashMap<CFAEdge, String>();
    }

    private void updateLoopStack(StringBuilder wholeLoopString, Deque<LoopStructure.Loop> loopStack, CFAEdge onlyEdge) {
        List<LoopStructure.Loop> newLoops = LoopCollectingEdgeVisitor.getLoopsOfNode(this.loopStructure, onlyEdge.getSuccessor());
        if (newLoops.isEmpty()) {
            return;
        }
        LoopStructure.Loop newInnerLoop = newLoops.get(newLoops.size() - 1);
        if (newInnerLoop.getIncomingEdges().contains((Object)onlyEdge)) {
            String newLabel = this.createFreshLabelForLoop(onlyEdge, newInnerLoop);
            wholeLoopString.append(newLabel + ": ;\n");
            loopStack.push(newInnerLoop);
        }
    }

    private String createFreshLabelForLoop(CFAEdge pCFAEdge, LoopStructure.Loop loop) {
        assert (!this.loopInLabels.containsKey(loop));
        String labelStayInLoop = this.getFreshLabel();
        this.loopInLabels.put(loop, labelStayInLoop);
        assert (!this.loopToHead.containsKey(loop));
        this.loopToHead.put(loop, pCFAEdge.getSuccessor());
        assert (!this.loopOutLabels.containsKey(loop));
        String labelGetOutOfLoop = this.getFreshLabel();
        this.loopOutLabels.put(loop, labelGetOutOfLoop);
        return labelStayInLoop;
    }

    private String createFreshLabelForIf(CFAEdge elseEdge, CFANode meetingPoint) {
        assert (!this.ifElseLabels.containsKey(elseEdge));
        String labelElse = this.getFreshLabel();
        this.ifElseLabels.put(elseEdge, labelElse);
        assert (!this.ifOutLabels.containsKey(elseEdge));
        String labelOut = this.getFreshLabel();
        this.ifOutLabels.put(elseEdge, labelOut);
        HashMap<CFANode, String> outMap = new HashMap<CFANode, String>();
        outMap.put(meetingPoint, labelOut);
        this.ifOutLabelEnd.push(outMap);
        return labelElse;
    }

    private String processSimpleWithLoop(CFAEdge edge, BasicBlock currentBlock, String suffix) {
        switch (edge.getEdgeType()) {
            case BlankEdge: 
            case StatementEdge: 
            case ReturnStatementEdge: 
            case DeclarationEdge: {
                return super.processSimpleEdge(edge, currentBlock) + "\n";
            }
            case AssumeEdge: {
                CAssumeEdge lAssumeEdge = (CAssumeEdge)edge;
                if (suffix.isEmpty()) {
                    if (this.currentFunctionName.equals("int main_0()")) {
                        return "if(! (" + lAssumeEdge.getCode() + ")) { return 0; }\n";
                    }
                    return "";
                }
                return "if(" + lAssumeEdge.getCode() + ") { goto " + suffix + "; }\n";
            }
            case FunctionCallEdge: {
                CFunctionEntryNode entryNode = ((CFunctionSummaryEdge)((FunctionCallEdge)edge).getSummaryEdge()).getFunctionEntry();
                String functionName = entryNode.getFunctionName();
                String functionHeader = entryNode.getFunctionDefinition().getType().toASTString(functionName);
                if (!this.nonUniqueFunctions.containsKey(functionHeader)) {
                    this.nonUniqueFunctions.put(functionHeader, Pair.of(entryNode, new FunctionBody(-1, functionHeader)));
                }
                return this.processFunctionCall(edge, functionName) + "\n";
            }
        }
        throw new AssertionError((Object)("Unexpected edge " + edge + " of type " + edge.getEdgeType()));
    }

    @Override
    protected String getTargetState() {
        return "return 1;";
    }

    private CFANode findEndOfBranches(List<CFANode> intermediateFunctionEnds, CFANode functionStart, CFANode thenNode, CFANode elseNode) {
        return this.findEndOfBranchesNonRecursive(elseNode, thenNode, functionStart, intermediateFunctionEnds.get(0));
    }

    private CFANode findEndOfBranchesNonRecursive(CFANode branch1, CFANode branch2, CFANode head, CFANode bottom) {
        Set<CFANode> foundNodes = CFATraversal.dfs().backwards().ignoreFunctionCalls().collectNodesReachableFromTo(bottom, head);
        if (foundNodes.contains(branch1) && foundNodes.contains(branch2)) {
            ArrayDeque<CFANode> branchStack = new ArrayDeque<CFANode>();
            branchStack.push(branch1);
            while (!branchStack.isEmpty()) {
                CFANode tmpSucc;
                branch1 = (CFANode)branchStack.pop();
                if (CFATraversal.dfs().backwards().ignoreFunctionCalls().collectNodesReachableFromTo(branch1, head).contains(branch2)) {
                    return branch1;
                }
                if (branch1.getNumLeavingEdges() == 2) {
                    branchStack.push(branch1.getLeavingEdge(1).getSuccessor());
                }
                if (Objects.equals(tmpSucc = branch1.getLeavingEdge(0).getSuccessor(), bottom)) continue;
                branchStack.push(tmpSucc);
            }
            throw new AssertionError((Object)"We did not find a merging point although there should be one, this is a BUG!");
        }
        return bottom;
    }

    private String getFreshLabel() {
        return "CPAchecker_label_" + this.labelCounter++;
    }
}

