/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.defaults.AbstractSerializableSingleWrapperState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;
import org.sosy_lab.cpachecker.util.cwriter.Edge;
import org.sosy_lab.cpachecker.util.cwriter.EdgeVisitor;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;
import org.sosy_lab.cpachecker.util.cwriter.MergeNode;

public abstract class PathTranslator {
    protected final List<String> mGlobalDefinitionsList = new ArrayList<String>();
    protected final List<String> mFunctionDecls = new ArrayList<String>();
    private int mFunctionIndex = 0;
    protected final List<FunctionBody> mFunctionBodies = new ArrayList<FunctionBody>();

    protected static CFunctionEntryNode extractFunctionCallLocation(ARGState state) {
        return (CFunctionEntryNode)FluentIterable.from(AbstractStates.extractLocations(state)).filter(CFunctionEntryNode.class).first().orNull();
    }

    protected PathTranslator() {
    }

    protected abstract String getTargetState();

    protected Appender generateCCode() {
        return Appenders.forIterable((Joiner)Joiner.on((char)'\n'), (Iterable)Iterables.concat(this.mGlobalDefinitionsList, this.mFunctionDecls, this.mFunctionBodies));
    }

    protected void translateSinglePath0(ARGPath pPath, EdgeVisitor callback) {
        assert (pPath.size() >= 1);
        PathIterator pathIt = pPath.fullPathIterator();
        ARGState firstElement = pathIt.getAbstractState();
        ArrayDeque<FunctionBody> functionStack = new ArrayDeque<FunctionBody>();
        this.startFunction(firstElement, functionStack, PathTranslator.extractFunctionCallLocation(firstElement));
        while (pathIt.hasNext()) {
            pathIt.advance();
            CFAEdge currentCFAEdge = pathIt.getIncomingEdge();
            ARGState childElement = pathIt.isPositionWithState() ? pathIt.getAbstractState() : pathIt.getPreviousAbstractState();
            callback.visit(childElement, currentCFAEdge, functionStack);
        }
    }

    protected final void translatePaths0(ARGState firstElement, Set<ARGState> elementsOnPath, EdgeVisitor callback) {
        ArrayList<Edge> waitlist = new ArrayList<Edge>();
        HashMap<Integer, MergeNode> mergeNodes = new HashMap<Integer, MergeNode>();
        ArrayDeque<FunctionBody> newStack = new ArrayDeque<FunctionBody>();
        this.startFunction(firstElement, newStack, PathTranslator.extractFunctionCallLocation(firstElement));
        waitlist.addAll(this.getRelevantChildrenOfState(firstElement, newStack, elementsOnPath));
        while (!waitlist.isEmpty()) {
            Collections.sort(waitlist);
            Edge nextEdge = (Edge)waitlist.remove(0);
            waitlist.addAll(this.handleEdge(nextEdge, mergeNodes, elementsOnPath, callback));
        }
    }

    protected String startFunction(ARGState firstFunctionElement, Deque<FunctionBody> functionStack, CFANode predecessor) {
        CFunctionEntryNode functionStartNode = PathTranslator.extractFunctionCallLocation(firstFunctionElement);
        String freshFunctionName = this.getFreshFunctionName(functionStartNode);
        String lFunctionHeader = functionStartNode.getFunctionDefinition().getType().toASTString(freshFunctionName);
        FunctionBody newFunction = new FunctionBody(firstFunctionElement.getStateId(), lFunctionHeader);
        this.mFunctionDecls.add(lFunctionHeader + ";");
        this.mFunctionBodies.add(newFunction);
        functionStack.push(newFunction);
        return freshFunctionName;
    }

    void processEdge(ARGState childElement, CFAEdge edge, Deque<FunctionBody> functionStack) {
        FunctionBody currentFunction = functionStack.peek();
        if (childElement.isTarget()) {
            currentFunction.write(this.getTargetState());
        }
        if (edge instanceof CFunctionCallEdge) {
            String freshFunctionName = this.startFunction(childElement, functionStack, edge.getPredecessor());
            currentFunction.write(this.processFunctionCall(edge, freshFunctionName));
        } else if (edge instanceof CFunctionReturnEdge) {
            functionStack.pop();
        } else {
            currentFunction.write(this.processSimpleEdge(edge, currentFunction.getCurrentBlock()));
        }
    }

    private Collection<Edge> handleEdge(Edge nextEdge, Map<Integer, MergeNode> mergeNodes, Set<ARGState> elementsOnPath, EdgeVisitor callback) {
        ARGState childElement = nextEdge.getChildState();
        CFAEdge edge = nextEdge.getEdge();
        Deque<FunctionBody> functionStack = nextEdge.getStack();
        functionStack = this.cloneStack(functionStack);
        if (edge == null) {
            List<CFAEdge> edges = nextEdge.getParentState().getEdgesToChild(childElement);
            for (CFAEdge inner : edges) {
                callback.visit(childElement, inner, functionStack);
            }
        } else {
            callback.visit(childElement, edge, functionStack);
        }
        int noOfParents = FluentIterable.from(childElement.getParents()).filter(Predicates.in(elementsOnPath)).size();
        assert (noOfParents >= 1);
        if (noOfParents > 1) {
            int noOfProcessedBranches;
            assert (!(edge instanceof CFunctionCallEdge) && !childElement.isTarget());
            int elemId = childElement.getStateId();
            FunctionBody currentFunction = functionStack.peek();
            currentFunction.write("goto label_" + elemId + ";");
            MergeNode mergeNode = mergeNodes.get(elemId);
            if (mergeNode == null) {
                mergeNode = new MergeNode(elemId);
                mergeNodes.put(elemId, mergeNode);
            }
            if (noOfParents == (noOfProcessedBranches = mergeNode.addBranch(currentFunction))) {
                List<FunctionBody> incomingStacks = mergeNode.getIncomingStates();
                FunctionBody newFunction = PathTranslator.processIncomingStacks(incomingStacks);
                functionStack.pop();
                functionStack.push(newFunction);
                newFunction.write("label_" + elemId + ": ;");
            } else {
                return ImmutableSet.of();
            }
        }
        return this.getRelevantChildrenOfState(childElement, functionStack, elementsOnPath);
    }

    private Collection<Edge> getRelevantChildrenOfState(ARGState currentElement, Deque<FunctionBody> functionStack, Set<ARGState> elementsOnPath) {
        Object relevantChildrenOfElement = FluentIterable.from(currentElement.getChildren()).filter(Predicates.in(elementsOnPath)).toList();
        relevantChildrenOfElement = this.chooseIfArbitrary(currentElement, (List<ARGState>)relevantChildrenOfElement);
        switch (relevantChildrenOfElement.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                ARGState elem = (ARGState)Iterables.getOnlyElement((Iterable)relevantChildrenOfElement);
                CFAEdge e = currentElement.getEdgeToChild(elem);
                return ImmutableList.of((Object)new Edge(elem, currentElement, e, functionStack));
            }
            case 2: {
                ARGState child1 = (ARGState)relevantChildrenOfElement.get(0);
                ARGState child2 = (ARGState)relevantChildrenOfElement.get(1);
                CAssumeEdge edge1 = (CAssumeEdge)currentElement.getEdgeToChild(child1);
                CAssumeEdge edge2 = (CAssumeEdge)currentElement.getEdgeToChild(child2);
                Verify.verify((boolean)edge1.getExpression().equals(edge2.getExpression()));
                Verify.verify((edge1.getTruthAssumption() != edge2.getTruthAssumption() ? 1 : 0) != 0);
                if (edge2.getTruthAssumption()) {
                    ARGState tmpState = child1;
                    CAssumeEdge tmpEdge = edge1;
                    child1 = child2;
                    edge1 = edge2;
                    child2 = tmpState;
                    edge2 = tmpEdge;
                }
                String cond = "if (" + edge1.getExpression().toASTString() + ")";
                return ImmutableList.of((Object)this.createNewBasicBlock(currentElement, child1, edge1, cond, functionStack), (Object)this.createNewBasicBlock(currentElement, child2, edge2, "else", functionStack));
            }
        }
        throw new AssertionError();
    }

    private List<ARGState> chooseIfArbitrary(ARGState parent, List<ARGState> pRelevantChildrenOfElement) {
        if (pRelevantChildrenOfElement.size() <= 1) {
            return pRelevantChildrenOfElement;
        }
        Comparator<ARGState> childCountComparator = Comparator.comparingInt(s -> s.getChildren().size()).reversed();
        ImmutableList relevantChildrenOfElement = ImmutableList.sortedCopyOf(childCountComparator, pRelevantChildrenOfElement);
        ArrayList<ARGState> result = new ArrayList<ARGState>(2);
        for (ARGState candidate : relevantChildrenOfElement) {
            boolean valid = true;
            if (!result.isEmpty()) {
                ImmutableSet candidateChildren = Collections3.transformedImmutableSetCopy(candidate.getChildren(), AbstractSerializableSingleWrapperState::getWrappedState);
                for (ARGState chosen : result) {
                    ImmutableSet chosenChildren;
                    if (!parent.getEdgesToChild(chosen).equals(parent.getEdgesToChild(candidate)) || !(chosenChildren = Collections3.transformedImmutableSetCopy(chosen.getChildren(), AbstractSerializableSingleWrapperState::getWrappedState)).containsAll((Collection<?>)candidateChildren)) continue;
                    valid = false;
                    break;
                }
            }
            if (!valid) continue;
            result.add(candidate);
        }
        return result;
    }

    private Edge createNewBasicBlock(ARGState parent, ARGState child, CAssumeEdge edge, String cond, Deque<FunctionBody> functionStack) {
        Deque<FunctionBody> newStack = this.cloneStack(functionStack);
        FunctionBody currentFunction = newStack.peek();
        currentFunction.enterBlock(parent.getStateId(), edge, cond);
        BlankEdge dummyEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), edge.getPredecessor(), edge.getSuccessor(), "");
        return new Edge(child, parent, dummyEdge, newStack);
    }

    private static FunctionBody processIncomingStacks(List<FunctionBody> pIncomingStacks) {
        FunctionBody maxStack = null;
        int maxSizeOfStack = 0;
        for (FunctionBody stack : pIncomingStacks) {
            while (stack.getCurrentBlock().isClosedBefore()) {
                stack.leaveBlock();
            }
            if (stack.size() <= maxSizeOfStack) continue;
            maxStack = stack;
            maxSizeOfStack = maxStack.size();
        }
        return maxStack;
    }

    protected String processSimpleEdge(CFAEdge pCFAEdge, BasicBlock currentBlock) {
        switch (pCFAEdge.getEdgeType()) {
            case BlankEdge: 
            case StatementEdge: 
            case ReturnStatementEdge: {
                return pCFAEdge.getCode();
            }
            case AssumeEdge: {
                CAssumeEdge lAssumeEdge = (CAssumeEdge)pCFAEdge;
                return "__CPROVER_assume(" + lAssumeEdge.getCode() + ");";
            }
            case DeclarationEdge: {
                CDeclarationEdge lDeclarationEdge = (CDeclarationEdge)pCFAEdge;
                if (lDeclarationEdge.getDeclaration().isGlobal()) {
                    this.mGlobalDefinitionsList.add(lDeclarationEdge.getCode());
                    return "";
                }
                if (currentBlock.hasDeclaration(lDeclarationEdge)) {
                    return "";
                }
                currentBlock.addDeclaration(lDeclarationEdge);
                return lDeclarationEdge.getCode();
            }
        }
        throw new AssertionError((Object)("Unexpected edge " + pCFAEdge + " of type " + pCFAEdge.getEdgeType()));
    }

    protected final String processFunctionCall(CFAEdge pCFAEdge, String functionName) {
        CFunctionCallEdge lFunctionCallEdge = (CFunctionCallEdge)pCFAEdge;
        List lArguments = Lists.transform(lFunctionCallEdge.getArguments(), AAstNode::toASTString);
        String lArgumentString = "(" + Joiner.on((String)", ").join((Iterable)lArguments) + ")";
        CFunctionSummaryEdge summaryEdge = lFunctionCallEdge.getSummaryEdge();
        if (summaryEdge == null) {
            return functionName + lArgumentString + ";";
        }
        CFunctionCall expressionOnSummaryEdge = summaryEdge.getExpression();
        if (expressionOnSummaryEdge instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignExp = (CFunctionCallAssignmentStatement)expressionOnSummaryEdge;
            String assignedVarName = assignExp.getLeftHandSide().toASTString();
            return assignedVarName + " = " + functionName + lArgumentString + ";";
        }
        assert (expressionOnSummaryEdge instanceof CFunctionCallStatement);
        return functionName + lArgumentString + ";";
    }

    protected final String getFreshFunctionName(FunctionEntryNode functionStartNode) {
        return functionStartNode.getFunctionName() + "_" + this.mFunctionIndex++;
    }

    private Deque<FunctionBody> cloneStack(Deque<FunctionBody> pStack) {
        ArrayDeque<FunctionBody> ret = new ArrayDeque<FunctionBody>();
        for (FunctionBody functionBody : pStack) {
            ret.add(new FunctionBody(functionBody));
        }
        return ret;
    }
}

